UNIT Bezier;

   { Functions and procedures for Bezier curves }

INTERFACE

USES   graph;

CONST  maxPoints = 10;    { max control points for a curve }
       segments  = 40;        { nbr of segments in a curve }

TYPE   vectorArray = ARRAY [0..maxPoints, 0..2] OF INTEGER;

PROCEDURE BezierFcn (VAR x, y, z  : REAL;
                         u        : REAL;
                         n        : INTEGER;
                     VAR p        : vectorArray);
PROCEDURE DrawBezier2D (VAR p     : vectorArray;
                            npts  : INTEGER);
{ -------------------------------------------------------- }
IMPLEMENTATION

FUNCTION c (n, i : INTEGER) : INTEGER;

   { Binomial coefficient used in blending function }

VAR   j : INTEGER;

  FUNCTION fact (q : INTEGER) : INTEGER;
  VAR    f, c : INTEGER;
  BEGIN        { Compute factorial of q }
    f := 1;
    FOR c := q DOWNTO 2 DO
      f := f * c;
    fact := f;
  END;

BEGIN
  C := fact (n) div (fact (i) * fact (n - i));
END;
{ --------------------------- }

FUNCTION blend (i, n : INTEGER; u : REAL) : REAL;

 { Bernstein blending function used in Bezier formulation }

VAR   partial : REAL;
      j       : INTEGER;

BEGIN
  Partial := c (n, i);
  FOR j := 1 TO i DO
    Partial := partial * u;
  FOR j := 1 TO (n - i) DO
    Partial := partial * (1 - u);
  Blend := partial;
End;
{ --------------------------- }

PROCEDURE BezierFcn;

  { Returns 3D coordinates for current 'u' on the curve }

VAR   i : INTEGER;
      b : REAL;

BEGIN
  x := 0;
  y := 0;
  z := 0;
  FOR i := 0 TO n DO
  BEGIN
    b := blend (i, n, u);
    x := x + p [i, 0] * b;
    y := y + p [i, 1] * b;
    z := z + p [i, 2] * b;
  END;
END;
{ --------------------------- }

PROCEDURE drawBezier2D;

  { Draws a 2D Bezier curve. Graphics mode assumed. }

VAR    i          : INTEGER;
       oldX, oldY,
       u, x, y, z : REAL;

BEGIN
  FOR i := 0 TO segments DO
  BEGIN
    u := i / segments;
    BezierFcn (x, y, z, u, npts, p);
    IF i = 0 THEN
      MoveTo (ROUND (x), ROUND (y))
    ELSE
      LineTo (ROUND (x), ROUND (y));
  END;
END;
{ --------------------------- }

END.

