{*ZD.PAD of ZD - Copyright 1988 by Pradeep Arora}
(*$M 1024,0,32000*)
(*$R-,S-,I-,F-,B-*)
(*$DEFINE IBM*)
program	SuperDirectory;

uses    Dos
{$IFDEF IBM}
	, Crt
{$ENDIF}
	;

procedure	Beep;
begin
{$IFDEF IBM}
	Sound(600);
	Delay(100);
	NoSound;
{$ENDIF}
end;		{*Beep()*}

(*$F+*)
function	CmpStr(var S1, S2) : integer; external;
{$L CMPSTR.OBJ}

procedure	UcaseStr(var S); external;
{$L	UCASESTR.OBJ}
(*$F-*)

const
	Cright : string[36] = '(C) Copyright 1988 by Pradeep Arora.';
type
	Str12 = string[12];
	Str8 = string[8];
	Str3 = string[3];

procedure	Extract(var MaskStr : SearchRec; var Ns : Str8; var Es : Str3);
var
	P : byte;
begin
	with MaskStr do
	begin
		P := Pos('.', Name);
		if (P = 0) then
		begin
			Ns := Name;
			Es := '';
		end
		else
		begin
			Ns := Copy(Name, 1, pred(P));
			Es := Copy(Name, succ(P), 3);
		end;
	end;
end;		{*Extract()*}

type
	CTypes = (Normal, Ext, SubDir, Others);
	Color = record
		Fg, Bg : Byte;
	end;
const
	MAX_FILES = 256;
	DEF_MASK = '*.*';
	Start : string[7] = '*START*';	{start of patch area}
{$IFDEF IBM}
	Colors : array[CTypes] of Color = (
		(Fg : LightGray; Bg : Black),	{normal}
		(Fg : Yellow; Bg : Black),	{extension}
		(Fg : Black; Bg : LightGray),	{subdirs}
		(Fg : Black; Bg : LightGray)	{others}
	);
{$ENDIF}

procedure	CleanupMask(var S : String);
var
	SLen : byte absolute S;
	SR : SearchRec;
	I : byte;
	SaveS : String;
label
	NotDir;
begin
	if (SLen = 0) then
		Exit;
	UcaseStr(S);
	if (Pos('*', S) <> 0) OR (Pos('?', S) <> 0) then
		goto NotDir;
    FindFirst(S, Directory, SR);
	if (DosError = 0) AND (SR.Attr = Directory) then
	begin	{subdirectory, like ZD .. / ZD ..\A / ZD A etc.}
		S := S + '\' + DEF_MASK;
		Exit;
	end;
NotDir:
    if (SLen = 1) OR ( (SLen = 2) AND (S[2] = ':') ) then
		S := S + DEF_MASK
	else
	begin
		I := SLen;
		while (I > 0) AND (S[I] <> '\') do
			Dec(I);
		SaveS := S;
		if (I > 0) then
			Delete(SaveS, 1, I);
		if Pos('.', SaveS) = 0 then
			S := S + DEF_MASK;
	end; {if..else..}
end;		{*CleanupMask()*}

var
	LastE : Str3;
	MaskStr : string;
	MaskStrLen : byte absolute MaskStr;
	A : array[1..MAX_FILES] of SearchRec;
	NRead : integer;
	Map : array[1..MAX_FILES] of integer;

procedure	LoadFNs;
var
	SR : SearchRec;
begin
	FindFirst(MaskStr, (AnyFile AND NOT(VolumeID)), SR);
	while (DosError = 0) do
	begin
		if (SR.Name <> '.') AND (SR.Name <> '..') then
		if (NRead < MAX_FILES) then
		begin
			Inc(NRead);
			A[NRead] := SR;
		end
		else
		begin
			write('** too many files **');
			Exit;	{too many files}
		end;
		FindNext(SR);
	end;
end;		{*LoadFNs()*}

function	CompareFN(var X, Y : SearchRec) : integer;
var
	ThisN, CompN : String[8];
	ThisE, CompE : String[3];
	CE : integer;
begin
	Extract(X, ThisN, ThisE);
	Extract(Y, CompN, CompE);
	CE := CmpStr(ThisE, CompE);
	if (CE <> 0) then
		CompareFN := CE
	else
		CompareFN := CmpStr(ThisN, CompN);
end;		{*CompareFN()*}

procedure	SortFNs;
var
	Gap, Bound, Exchanges, Lower, Upper, Temp, I : integer;
begin
	{** We have NRead members in array A[] to sort by rearranging the
		order indicated by Map[] array **}
	{set up initial mappings}
	for I := 1 to NRead do
		Map[I] := I;
	{sort using shell sort}
	Gap := NRead;
	while (Gap > 1) do
	begin
		Gap := Gap DIV 2;
		Bound := NRead - Gap;
		repeat
			Exchanges := 0;
			for Lower := 1 to Bound do
			begin
				Upper := Lower + Gap;
				if (CompareFN(A[Map[Lower]], A[Map[Upper]]) > 0) then
				begin
					Temp := Map[Lower];
					Map[Lower] := Map[Upper];
					Map[Upper] := Temp;
					Inc(Exchanges);
				end;
			end; {for..}
		until Exchanges <= 0;
	end; {while..}
end;		{*SortFNs()*}

procedure	WriteFNs;
var
	ThisN : Str12;	{labels}
	LastE, ThisE : Str3;
	Ft : CTypes;
	Ai, Ct : Word;
	Total : LongInt;
begin
	Total := 0;
	LastE := #00#00#00;
	Ct := 0;
	for Ai := 1 to NRead do
	begin
		with A[Map[Ai]] do
		begin
			Inc(Total, Size);	{inc total size}
			Extract(A[map[Ai]], ThisN, ThisE);	{name & ext}
			if (ThisE <> LastE) AND (ThisE <> '') then
			begin	{a new ext, write it out}
				LastE := ThisE;
{$IFDEF IBM}
				TextColor(Colors[Ext].Fg);
				TextBackground(Colors[Ext].Bg);
{$ELSE}
				write(#174);
{$ENDIF}
				write(ThisE);
{$IFDEF IBM}
				write(' ');
{$ELSE}
				write(#175);
{$ENDIF}
			end;
			{** find type of this file **}
			if (Attr AND Directory <> 0) then
				Ft := SubDir
			else
			begin
				Inc(Ct);
				if (Attr = $00) OR ((Attr AND Archive) <> 0) then
					Ft := Normal
				else
					Ft := Others;
			end;
{$IFDEF IBM}
			TextColor(Colors[Ft].Fg);
			TextBackground(Colors[Ft].Bg);
{$ENDIF}
			write(ThisN, ' ');
		end; {with A[Ai]..}
	end; {for Ai..}
{$IFDEF IBM}
	LowVideo;
{$ENDIF}
	if (Ct <> 0) then
		write('(', Total shr 10, 'K in ', Ct, ' files)');
end;		{*WriteFNs()*}

var
{$IFDEF IBM}
	SaveAttr : Word;
	SaveM : Integer;
{$ELSE}
	OutBuf : array[1..4000] of char;
{$ENDIF}
	W1, W2, W3, W4 : Word;
	Dir : String;
	Drive : byte;
label
	EndPgm;
begin
{$IFDEF IBM}
	SaveAttr := TextAttr;
	SaveM := LastMode;
{$ELSE}
	SetTextBuf(Output, OutBuf);
{$ENDIF}

	Drive := 0;	{default}
	if (ParamCount > 0) then
	begin
		MaskStr := ParamStr(1);
		if (MaskStrLen >= 2) AND (MaskStr[2] = ':') then
			Drive := ord(upcase(MaskStr[1])) - ord('A') + 1;
		CleanupMask(MaskStr);
	end
	else
	begin
		MaskStr := DEF_MASK;
	end;

	write(#254);
	GetDate(W1, W2, W3, W4);
	write(W2, '/', W3, '/', W1-1900);
	GetTime(W1, W2, W3, W4);
	write(' ', W1, ':', W2);
	write(#254);

	GetDir(Drive, Dir);
	if (IOResult <> 0) then
	begin
		Beep;
		goto EndPgm;
	end;
	write(Dir, ' ');
	write(DiskSize(Drive) shr 10, '-');
	if (IOResult <> 0) then
	begin
		Beep;
		goto EndPgm;
	end;
	write( (DiskSize(Drive) - DiskFree(Drive)) shr 10, '=');
	write(DiskFree(Drive) shr 10, 'K'#254);

	NRead := 0;
	LoadFNs;
	SortFNs;
	WriteFNs;

EndPgm:

{$IFDEF IBM}
	TextAttr := SaveAttr;
	(**NormVideo;**)
	(**TextMode(SaveM);**clears the screen**)
	writeln; write('    ');
{$ENDIF}
end.

{*----- end of ZD.PAS of ZD -----}
