     title   CMPSTR
CODE segment byte public
     assume  cs:code
     public  CMPSTR

; function CmpStr(var S1, S2) : integer;
CMPSTR proc far
     Str1      equ dword ptr [bp+10]
     Str2      equ dword ptr [bp+06]
     StackSize equ 8

     push bp            ;save bp & ds
     mov  bp,sp
     push bp
     push ds

     lds si, Str1       ;ds:si is ptr to S1
     les di, Str2       ;es:di is ptr to S2
     xor ax,ax          ;clear ax
     mov al,[si]        ;len(S1)
     mov cx,ax          ;cx = len(S1)
     mov bx,ax          ;bx = len(S1)
     mov al,es:[di]        ;len(S2)
     mov dx, ax         ;dx = len(S2)
     cmp bx,dx          ; if len(S1) > len(S2)
     jle j1             ;   skip
     mov cx, dx         ; else cx = len(S2)
j1:      ;cx now has smaller of the two lengths
         ;ds:si pts to s1[0]
         ;es:di pts to s2[0]
     xor  ax,ax         ;default answer is equal
     jcxz ZeroLen       ;one of them is null string
     inc  si            ;pt to char 1
     inc  di
     cld
     repz cmpsb         ;compare max cx bytes starting [si] to [di] till
                        ; al = [si] - [di] becomes non zero
     jl   Str1Lt
     jg   Str1Gt

MayBeEqual: ;situation here is same as case of null strs.
ZeroLen:    ;iff bx = dx they are equal.
     cmp bx, dx         ; len(S1) ? len(S2)
     je  Exit
     jg  Str1Gt   ;S1 > S2
Str1Lt:
     dec ax             ; return -1
     jmp Exit
Str1Gt:
     inc ax             ; return 1

Exit:
     pop ds             ;restore ds & bp
     pop bp
     mov sp, bp
     pop bp
     ret StackSize      ;clean stack for parms

CMPSTR endp
CODE   ends
       end
