procedure Sort(Size,Count : Word; var List);
{
   preconditions:  Size has a value of 1, 2, 4, or 6
                   Count is in the range 0..Limit
                   List is an array of type ShortInt, Integer,
                     LongInt, or Real
                   the upper bound of Limit and the type of List
                     are determined by Size as follows:
                     Size  max value of Limit   type of List
                     ----  ------------------   ------------
                       1        64,000            ShortInt
                       2        32,000            Integer
                       4        16,000            LongInt
                       6        10,667             Real
    postconditions: The elements 1..Count of List are sorted
                     in ascending order
}
var
  SList        : array[1..64000] of ShortInt absolute List;
  IList        : array[1..32000] of Integer  absolute List;
  LList        : array[1..16000] of LongInt  absolute List;
  RList        : array[1..10667] of Real     absolute List;
  Top,Min,K    : Word;

  function LessThan(I,J : Word) : Boolean;
  begin
    case Size of
      1 : LessThan := SList[I] < SList[J];
      2 : LessThan := IList[I] < IList[J];
      4 : LessThan := LList[I] < LList[J];
      6 : LessThan := RList[I] < RList[J];
      else LessThan := False
    end
  end; { of locproc LessThan }

  procedure Swap(I,J : Word);
  var
    K          : Word;
    Temp       : ShortInt;
    ch         : char;
  begin
    I := 1 + (I-1)*Size;
    J := 1 + (J-1)*Size;
    for K := 0 to Size-1 do begin
      Temp := SList[I+K];
      SList[I+K] := SList[J+K];
      SList[J+K] := Temp
    end
  end; { of locproc Swap }

begin
  for Top := 1 to Count-1 do begin
    Min := Top;
    for K := Top+1 to Count do
      if LessThan(K,Min)
        then Min := K;
    if (Min <> Top)
      then Swap(Min,Top);
  end;
end; { of proc Sort }
