procedure Sort(var List : ListType; Count : Word);
{
   preconditions:  BaseType is a type for which the operators
                     :=, <>, and < all are defined
                   ListType = array[1..Limit] of BaseType
                   Count is in the range 0..Limit
   postconditions: The elements 1..Count of List are sorted
                     in ascending order
}
var
  Top,Min,K : Integer;
  Temp      : BaseType;
begin
  for Top := 1 to Count-1 do begin
    Min := Top;
    for K := Top+1 to Count do
      if List[K] < List[Min]
        then Min := K;
    if Top <> Min then begin
      Temp := List[Top];
      List[Top] := List[Min];
      List[Min] := Temp
    end
  end
end; { of proc Sort }
