{STRLIB3.PAS}
{
Description:  Library of extended string handling routines for parsing
              demonstrations
Author:       Karl Gerhard
Date:         8/13/87
Application:  IBM PC and compatibles
}

type string1 = string[1];
{---------------------------------}
Function color(f,b:integer):string1;
{ set color, return null }
Begin
textcolor(f);
textbackground(b);
color := '';
End;

{---------------------------------}
Function strrtrim(s:stdstr):stdstr;
{ delete blanks on right of string }
var i:integer;
Begin
i := length(s);
while (i > 0) and (s[i] = ' ') do i := i - 1;
s[0] := chr(i);
strrtrim := s;
End;


{---------------------------------}
Function strltrim(s:stdstr):stdstr;
{ delete blanks on left of string }
var i:integer;
Begin
while (0 < length(s) ) and (s[1] = ' ') do delete(s,1,1);
strltrim := s;
End;

{---------------------------------}
Function struc(s:stdstr):stdstr;
{ capitalize a string }
Var i:integer;
Begin
for i := 1 to length(s) do  s[i] := upcase( s[i] );
struc := copy(s,1,i);
End;

{---------------------------------}
Function bool(b:boolean):stdstr;
{ return printable string for boolean }
Begin if b then bool := 'True' else bool := 'False';  End;

{---------------------------------}
Function strint(n:integer):stdstr;
{ return printable string for an integer }
Var s:stdstr;
Begin
str(n,s);
strint := ' ' + s + ' ';
End;

{---------------------------------}
Function nextword(s:stdstr; var ptr:integer):stdstr;
{ get next word from the input, advance ptr }
Var
inlen,ps:integer;
Begin
inlen := length(s);
s := s + ' ';

{ skip leading blanks }
ps := ptr;
if ps < inlen then
while (ps <= inlen ) and (s[ps] = ' ') do ps := ps + 1;

{ find end of the word }
if ps <= inlen then begin
  ptr := ps - 1;
  repeat  ptr := ptr + 1;
  until (ptr >= inlen ) or (s[ptr + 1] = ' ' );
  if (ptr > inlen ) then error('nextword','ptr exceeds string length');
  s := copy(s, ps, ptr - ps + 1);
end
else
  s := '';

s := strrtrim(s);
nextword := s;
ptr := ptr + 1;
{ logging('nextword',' ' + strint(ptr) + '[' + s + ']');{}
End;


{---------------------------------}
Function getoken:stdstr;
{ get next word from the input array, advance token_ptr }
Var  s:stdstr;
n,ps:integer;
Begin

{ skip leading blanks }
if token_ptr < input_length then
while (token_ptr <= input_length ) and
  (input_array[token_ptr] = ' ') do token_ptr := token_ptr + 1;

{ detect punctuation as next token }
if input_array[token_ptr] in[#33..#47,#58..#64] then begin
  { detect double punctuation as next token }
  if input_array[token_ptr + 1] in['=','>']  then begin
    s := input_array[token_ptr] + input_array[token_ptr + 1];
    token_ptr := token_ptr + 1;
  end
  else
    s := input_array[token_ptr];
  token_ptr := token_ptr + 1;
end

{ find end of the word }
else if token_ptr <= input_length then begin
  ps := token_ptr ;
  while (token_ptr <= input_length ) and
    not (input_array[token_ptr] in[#32..#47,#58..#64] )
    do  token_ptr := token_ptr + 1;

  move(input_array[ps], s[1],token_ptr - ps);
  s[0] := chr(token_ptr - ps);
end
else
  s := '';

getoken := s;
logging('  GETOKEN ',s);
End;


