{PARSLIB3.PAS}
{
Description:  Library of parsing support routines used to handle searches
              and stack operations.
Author:       Karl Gerhard
Date:         8/7/87
Application:  IBM PC and compatibles
}

{---------------------------------}
Function search_lhs( lhs:stdstr; var rhs:stdstr):boolean;
{ search grammar for lhs, return its rhs }
Var
i,p:integer; statok:boolean;
Begin
i := 0;
lhs := lhs + ' '; { enforce exact word match }
repeat
  i := i + 1;
  p := pos( lhs,grammar[i] );
  statok := (p < 3) and (p > 0);
until (i >= gr_length) or statok;
if statok then begin
  rhs := grammar[i];
  p := 2; repeat p := p + 1; until rhs[p] = ' ';
  rhs := copy(rhs,p,250);
  { logging('search_lhs','['+lhs+']'+rhs);{}
end
else begin
  rhs := 'LHS NOT FOUND';
  logging('  IS TERMINAL: ',lhs);
end;
search_lhs := statok;
End;


{---------------------------------}
Function pop(var stack:stack_type):stdstr;
{ return top of stack, at the left of the stack string }
Var
ps:integer;  s:stdstr;
Begin
if length(stack) < 1 then error('pop','stack underflow');
ps := 1;
s := nextword(stack,ps);
delete(stack,1,ps);
stack := strrtrim(strltrim(stack));
pop := s;
{logging('pop', '['+ s + ']');{P}
End;

{---------------------------------}
Procedure push(s:stdstr; var stack:stack_type);
{ append s to the stack array }
Begin
if length(s) + 3 + length(stack) > stackmax then error('push',' stack overflow');
stack := s + ' ' + stack;
{logging('push','['+ s + ']');{P}
End;


