{ACTIONS.PAS}

{
Description:  Action procedures for demonstration of parsing Pascal source.
Author:       Karl Gerhard
Date:         9/30/87
Application:  IBM PC and compatibles
}


{---------  Individual Action Procedures ------------}
Procedure print;
{ print and clear the print_string }
Begin
write(indent_string + print_string);
logging(' === ps',indent_string + print_string);
print_string := '';
End;

Procedure printno;
{ print and clear the print_string with no indent }
Begin
write(print_string);
logging(' == psn',print_string);
print_string := '';
End;

Procedure deletespace;
{ delete last char (space) of print string }
Begin
if length(print_string) < 1 then writeln(#13#10,' - - > @ds error');
delete(print_string, length(print_string),1);
End;

Procedure newline;
{ print CRLF }
Begin
writeln;
End;

Procedure indent;
{ append two indentation spaces }
Begin
indent_string := indent_string  + '  ';
End;

Procedure undent;
{ remove two indentation spaces }
Begin
if length(indent_string) < 2 then writeln(#13#10,'- - > @und error');
delete(indent_string,1,2);
End;

{---------  Main Action Decoder ------------}
Procedure actions(action:stdstr);
{ Decode action and execute it}

Begin
delete(action,1,1);
if action = 'ps' then print
else if action = 'psn' then printno
else if action = 'ind' then indent
else if action = 'und' then undent
else if action = 'nl'  then newline
else if action = 'ds'  then deletespace
else error('actions','unknown action in grammar');
End;
