PROGRAM Colors;

(*      PURPOSE: Display Color Chart
 *      SYSTEM:  Turbo Pascal 4.0
 *      AUTHOR:  Tom Swan
 *)

USES    Crt, Graph;

VAR     grDriver : Integer;     { Graphics driver number }
        grMode   : Integer;     { Graphics driver mode }
        grError  : Integer;     { Graphics error code }

        barWidth : Word;        { Pixel width of bars }
        labelHeight : Word;     { Pixel height of bar labels }
        bwd2  : Word;           { barWidth DIV 2 }
        bwt2  : Word;           { barWidth times 2 }
        lhd2  : Word;           { labelHeight DIV 2 }


PROCEDURE Initialize;

{ Initialize global variables, load text font, and display title. }

BEGIN

  { Select text style, direction, size, and justification.
    Then, display title at top center of screen. Reduce text
    size for displaying labels under bars. }
    
    SetTextStyle( SansSerifFont, HorizDir, 5 ); { Title }
    SetTextJustify( CenterText, CenterText );
    MoveTo( GetMaxX DIV 2, GetMaxY DIV 8 );
    OutText( 'Color Numbers' );
    SetTextStyle( SansSerifFont, HorizDir, 4 ); { Labels }
    
  { Initialize a few global variables }
  
    barWidth  := ( ( GetMaxX + 1 ) DIV ( GetMaxColor + 1 ) ) DIV 2;
    labelHeight := 2 * TextHeight( '0' );
    lhd2 := labelHeight DIV 2;  { labelHeight DIV 2 }
    bwd2 := barWidth DIV 2;     { barWidth DIV 2 }
    bwt2 := barWidth * 2        { barWidth times 2 }
    
END; { Initialize }


PROCEDURE DrawOneBar( x1, y1, x2, y2 : Integer; color : Word );

{ Draw a single bar filled with a color }

BEGIN
    SetFillStyle( SlashFill, color );   { Select pattern, color }
    Bar( x1, y1, x2, y2 );              { Draw filled bar }
    SetColor( White );                  { Outline bars in white }
    Rectangle( x1, y1, x2, y2 )         { Draw outline }
END; { DrawOneBar }


PROCEDURE LabelBar( x, y : Integer; color : Word );

{ Display color number centered at (x,y) under bar }

VAR     s : String[2];          { Color number as a string }

BEGIN
    Str( color, s );            { Convert color to string s }
    OutTextXY( x, y, s )        { Display text at (x,y) }
END; { LabelBar }


PROCEDURE DrawBars;

{ Draw color bars and wait for key press }

VAR     x1, y1, y2 : Integer;   { Coordinate values }
        color : Word;           { FOR-loop variable }
        ch : Char;              { Keyboard character }

BEGIN
    x1 := bwd2;                 { Initialize starting x1 value }
    y1 := GetMaxY DIV 3;        { Initialize y1 to top of bar }
    y2 := GetMaxY - labelHeight; { Initialize y2 to bottom of bar }
    
    FOR color := 0 TO GetMaxColor DO
    BEGIN
        DrawOneBar( x1, y1, x1 + barWidth, y2, color );
        LabelBar( x1 + bwd2, y2 + lhd2, color );
        x1 := x1 + bwt2         { Move x1 right for the next bar }
    END; { while }
    
    ch := ReadKey  { Wait for keypress }
    
END; { DrawBars }


BEGIN
    grDriver := Detect;
    InitGraph( grDriver, grMode, '' );
    grError := GraphResult;
    IF grError <> GrOk
     THEN 
        Writeln( 'Graphics error : ', GraphErrorMsg( grError ) )
     ELSE 
        BEGIN
            Initialize;         { Perform various initializations }
            DrawBars;           { Display color bars }
            CloseGraph          { Restore former text mode }
        END
END.
