program Simple;  {SIMPLE.PAS: A simple editor using the BINED unit}

uses BinEd, Crt;

const ExitCommands : Char = #0;   {No extra exit commands}
var EdData : EdCB;              {Editor control block}

  procedure Abort(Msg : String);
  begin  {Abort}
    GotoXY(1, 25); Write(Msg); Halt(1);
  end;   {Abort}

begin  {main}
  if (ParamCount = 0) then                      {No filename}
     Abort('Usage: SIMPLE filename.ext');
  if (InitBinaryEditor(EdData, MaxFileSize, 1, 1, 80, 25,
     True, EdOptInsert, '', ExitCommands, nil) <> 0) then
       Abort('Unable to load binary editor.');  {Couldn't load editor}
  if (ReadFileBinaryEditor(EdData, ParamStr(1)) > 1) then
     Abort('Unable to read ' + ParamStr(1));    {Couldn't read file}
  ResetBinaryEditor(EdData);                    {Reset for new file}
  if (UseBinaryEditor(EdData, '') = -1) then    {Edit the file}
     if ModifiedFileBinaryEditor(EdData) then   {Was it modified?}
        if (SaveFileBinaryEditor(EdData, True) <> 0) then {Save it}
           Abort('Error saving file.');
  GotoXY(1,25);
end.   {main}
