UNIT Box;

(*
 *      PURPOSE : A Unit for displaying boxes
 *      SYSTEM  : IBM PC/MS-DOS, Turbo Pascal 4.0
 *      AUTHOR  : Tom Swan
 *)


INTERFACE

USES    Crt;

VAR     TopLine:                CHAR;   { Horiz. top line char }
        LeftLine:               CHAR;   { Vert. left line char }
        BottomLine:             CHAR;   { Horiz. bottom line char }
        RightLine:              CHAR;   { Vert. right line char }

        TopLeftCorner:          CHAR;   { Top left corner char }
        TopRightCorner:         CHAR;   { Top right corner char }
        BottomLeftCorner:       CHAR;   { Bottom left corner char }
        BottomRightCorner:      CHAR;   { Bottom right corner char }


PROCEDURE DrawBox( Top, Left, Bottom, Right : INTEGER );

{ Call this procedure to draw a box, using the global character
  variables.  The four parameters are not checked.  Using values
  outside the legal display coordinates will produce strange-
  looking boxes! }


{ ----------------------------------------------------------------- }

IMPLEMENTATION


CONST   DefTop=                 #205;
        DefLeft=                #179;
        DefBottom=              #196;
        DefRight=               #179;

        DefTopLeft=             #213;
        DefTopRight=            #184;
        DefBottomLeft=          #192;
        DefBottomRight=         #217;



PROCEDURE DrawBox(* ( Top, Left, Bottom, Right : INTEGER ) *);

{ Draw rectangular outline pegged to these coordinate values. }

VAR     x, y : INTEGER;    { Temporary screen coordinates }

BEGIN

        { First, draw the box's four corners }

        GotoXY( Left, Top );            { Top, Left }
         Write( TopLeftCorner );
        GotoXY( Right, Top );           { Top, Right }
         Write( TopRightCorner );
        GotoXY( Left, Bottom );         { Bottom, Left }
         Write( BottomLeftCorner );
        GotoXY( Right, Bottom );        { Bottom, Right }
         Write( BottomRightCorner );


        { Next, fill in the top and bottom sides }

        GotoXY( Left + 1, Top );
        FOR x := ( Left + 1 ) TO ( Right - 1 ) DO
                Write( TopLine );

        GotoXY( Left + 1, Bottom );
        FOR x := ( Left + 1 ) TO ( Right - 1 ) DO
                Write( BottomLine );


        { And then fill in the left and right sides }

        FOR y := ( Top + 1 ) TO ( Bottom - 1 ) DO BEGIN
                GotoXY( Left, y );
                Write( LeftLine );
                GotoXY( Right, y );
                Write( RightLine )
        END { for }

END; { DrawBox }



BEGIN   { Unit initialization }

        TopLine := DefTop;              { Assign default character }
        LeftLine := DefLeft;            {  values to global vars.  }
        BottomLine := DefBottom;
        RightLine := DefRight;

        TopLeftCorner := DefTopLeft;
        TopRightCorner := DefTopRight;
        BottomLeftCorner := DefBottomLeft;
        BottomRightCorner := DefBottomRight

END.    { Box unit }
