{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Counter (version 2.0) by Rafael Del Vecchio enables its user to set up
event counters that can replace their mechanical counterparts. Written
in Turbo Pascal 4.0, this program provides up to 20 counters for use on
your PC, with output that can be directed to the printer or a file.

* ASSOCIATED FILES
COUNTER.PAS
COUNTER1.PAS
COUNTER2.PAS
COUNTER3.PAS
COUNTER.EXE

}
program counter;

{compiler directives}
{$R-}    {no range checking, the program has been debugged}
{$I-}    {no IO checking, IO errors are handled from within COUNTER}

{
Description:  COUNTER allows you to define up to 20 keys to use as
              counters.  COUNTER is very useful when large numbers
              of different items must be counted rapidly and accurately.
              COUNTER eliminates the need to purchase expensive mechanical
              counters and allows you, instead, to use your IBM.
              Additionally, COUNTER allows you to output your results
              to the printer or to a file; the output provides the status
              of each counter key as well as information for
              benchmarking.

Author:       Rafael J Del Vecchio
              PO Box 1243
              Davis,  CA  95617-1243
              U.S.A.

Date:         8/27/1987

LastRevised:  2/15/1988 at 21:15

Application:  IBM PC or compatible with DOS 2.0 or higher.

Published in: Unpublished as of above date.  Entered in the TUG O'Wards III
              programming competition on 2/16/1988 and placed in the
              public domain as of that date.

Notes:        Compiled with Turbo Pascal version 4.0 (CopyRight Borland
              International).

              The constants MinCount, MaxCount, and StartCount define the
              minimum, maximum, and starting values, respectively, of the
              counters.  These constant definitions are in the file
              COUNTER1.PAS in case you want to modify them.

              If you want to modify the output format (file or printer)
              you will have to modify the procedure ProcessUserInput
              in COUNTER3.PAS. <F6> for output to file and <F7> for
              output to the printer.

              I hope you find this program useful.  I welcome any
              suggestions to make the program more useful and/or user
              friendly.

}


uses
 dos,crt,printer;



{include types, constants, variables and forward declarations}
{$I counter1.pas}



{include service procedures}
{$I counter2.pas}



{include main processing procedures}
{$I counter3.pas}



begin {program counter}

  Initialize;
  Execute;
  Terminate;

end. {program counter}

