{$R-}    {Range checking}
{$B-}    {Boolean complete evaluation}
{$S+}    {Stack checking}
{$I+}    {I/O checking}
{$N-}    {No numeric coprocessor}
{$M 32768,65536,655360}

program PXL (input, Output);     {Version 2.11 for Turbo Pascal 3-5}  {.CP25}
   {Pascal X-ref Lister.  Not copyright.  Enjoy.                        }
   {Programmer: R. N. Wisan, 37 Clinton St., Oneonta, NY 13820          }
   {Options (available via menu or command line):                       }
   {  1. Make a cross-reference of all identifiers.                     }
   {  2. Number lines.                                                  }
   {  3. Mark Turbo Pascal reserved words.                              }
   {     (When both #2 and #3 selected, counts begin/end depth.         }
   {  4. If printer uses #12, feeds out FF before printing if requested.}
   {Makes standard default header containing file name & creation date. }
   {  If user ID found in file PXL.ID, puts that in header, too.  Can   }
   {  take user defined header (& some other format instructions) from  }
   {  PXL.HDR or in body of listed file.                                }
   {Paginates automatically or per absolute or conditional page advance.}
   {Takes printer info and list of reserved words from data files:      }
   {  PXL.PRN and PXL.WDS.  Can be set to use internal data instead.    }
   {Can be run from a batch file.  Reports failure as ERRORLEVEL 1.     }
   {Requires DOS 2.00 or higher.                                        }

Uses
  Crt,
  Dos,
  PXLINIT,
  PXLMENU,
  PXLLIST;

{=========The following values are the ones you may want to adjust===={.CP21}

procedure SetUp;
begin
   DataFiles := True;         {True loads printer symbols data from PXL.WDS }
                              {   and reserved word list from PXL5.PRN.     }
                              {False uses internal data, correct for Epson  }
                              {   printers & Turbo Pascal 4 & 5.            }

   Turbo3 := False;   {Default TP version.  Overridden by M or X options if }
                      {DataFiles=False.  That forces PXL.WDS to be read; PXL}
                      {then sets for TP3/TP4 by number of reserved words.   }

   NormalColor  := 2;   {Colors for screen.  NormalColor is for main text,  }
   FrameColor   := 6;   {FrameColor is used for frame, and Background is the}
   Background   := 0;   {same for both.  PXL doesn't change a CGA border, & }
                        {on exit, restores any screen text colors it found. }

   BottomMargin :=  4;  {Number of lines to leave blank at bottom of page.  }
   OutputDevice := 'PRN';  {Default printer device --can be any filename or }
                           {'Prn' or 'LPT1' etc. (Note: no colon!)  Can be  }
                           {overriden from the command line.                }
end; {Setup}

{====Don't tinker with things below this line unless you're going in deep===}

begin {Main}                                                          {.CP15}
   CursorOff;
   SetUp;
   Initialize;
   Menu;
   if NumberLines or Mrk or XRef then begin
      if not GotPrnData and (Mrk or XRef) then
         CantCont(' reading '+ PrnFileName,'Can''t find it on path');
      SetStyle;
      if Mrk or XRef then
         LoadReserv;
   end; {if Num...}
   Blank(9,16);
   ListIt;
   ByeBye
end.
