{

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(*****************************************************************************)
(* Beginning of Include file PRCSSFIL.INC                                    *)
(* < Matrix Creation File Handling >                                         *)
(*****************************************************************************)

 procedure ProcessFile;
  var
    Continue, Exit: Boolean;


  procedure InitMtrx(var InpMtrx : Matrix);
   { Load with 99999999. the matrix sent, except main diagonal (with 0's) }
   var
     i,j: Byte;
   begin
     for i:=1 to MaxArraySize do
         for j:=1 to MaxArraySize do
             if i=j then InpMtrx[i,j]:= 0.0
             else InpMtrx[i,j]:= BigNo
   end;  { InitMtrx }


  procedure ReadInData;
   begin
     case Reply of
      '1': begin
             InitMtrx(Distance);
             FillOutMtrx(Distance,'D',ArraySize,MtrxFilNam,'CREATE')
           end;
      '2': begin
             InitMtrx(WorkFlow);
             FillOutMtrx(WorkFlow,'W',ArraySize,MtrxFilNam,'CREATE')
           end;
      '3': begin
             InitMtrx(TransCost);
             FillOutMtrx(TransCost,'C',ArraySize,MtrxFilNam,'CREATE')
           end;
     end; { case }
   end; { ReadInData }

  procedure InitDiskFile;
   { In charge of creating a file in disk whose all components will be initial-
     ized to zero.The size of the file is determined by (ArraySize**2)+1. The
     first component of the file however (a real#), is assigned a key value for
     ID purposes.This value is the combination of the Reply #(mtrx type)and the
     ArraySize. For example.,if Reply = 2, and ArraySize = 4, then Key = 2.04 }
   var
     Zero,IDkey,IntPart,FracPart : Real;
     MtrxSize, Code, i           : Integer;

   begin  { InitDiskFile }
     InitFile_Mssg(MtrxFilNam,Blue,Black,White);
     Zero:= 0.0;
     MtrxSize:= Sqr(ArraySize);
     Val(Reply,IntPart,Code);          { "Reply" is converted to real"IntPart"}
     FracPart:= ArraySize/100;                     { Fractional part of "Key" }
     IDkey:= IntPart + FracPart;
     Write(MtrxFile,IDkey);   { Save "IDkey" as the 1st component of the file }
     for i:=1 to MtrxSize do Write(MtrxFile,Zero);               { Initialize }
     Done_Mssg(WhereX-1,25,Black,White)
   end;  { InitDiskFile }


  procedure GetArrySiz(X,Y: Byte);
   const
     Dgts: CharSet = ['0'..'9'];
   var
     SizStr: Strng6;
     Code  : Integer;

   procedure ShowMessg2;
    begin
      Draw_Enter(2,25);  Draw_Del(21,25);
      WriteFast('Enter size',6,25,Black,Yellow);
      WriteFast('Clear',25,25,Black,LightRed);
      Gotoxy(X+1,Y)
    end;

   procedure ShowMessg1;
    begin
      ClrLn(25);
      VertBar(1,40,25,Black,LightRed);
      Draw_Esc(42,25);
      WriteFast('Exit',46,25,Black,LightCyan);
      Gotoxy(X,Y)
    end;

   procedure GetStrng(var Inpstr: Strng6;
                          Inpset: CharSet; Maxlen: Integer);
    { Gets a valid input strng from keyboard allowing to end the input with a
      CR or to get out at any time with the ESC key. Allows switching between
      two messgs as the 1st chr is typed or removed. Also allows to clear the
      field using the Del key }
    const
      BS  = ^H;  { Back Space }            ESC = ^[;   { Escape key }
      CR  = ^M;  { Carriage Return }       Del = #83;  { Delete key }
      NUL = #0;  { Null char. }
    var
     Ch   : Char;     { Char read }        CombKey: Boolean;  { Comb'tn key }
     OKset: CharSet;  { Allowed set }

    procedure Clear;
     begin
       InpStr:= '';
       CombKey:= False;  Exit:= False;
       Gotoxy(X,Y);  Write(Dup(MaxLen,'_'))
     end;

    begin { GetStrng }
      Clear;
      repeat {until Ch=CR or Exit}
        CombKey:= False;
        if Length(Inpstr) < 1 then begin
           OKset:= Inpset + [ESC];  ShowMessg1
           end
        else begin
           if Length(Inpstr)=1 then ShowMessg2;
           if Length(Inpstr) < Maxlen
              then OKset:= Inpset + [CR,BS,NUL,ESC]
              else OKset:= [CR,BS,NUL,ESC]
           end;
        repeat
          Ch:= ReadKey;
          if Not(Ch in OKset) then Play(900,10)
        until Ch in OKset;

        case Ch of
          BS  : begin
                  Write(Ch); Write('_' + BS);
                  Delete(InpStr,Length(InpStr),1)
                end;
          NUL : begin
                  Ch:= ReadKey;
                  if Ch=Del then Clear else CombKey:=True
                end;
          ESC : begin
                  Clear;
                  Exit:=True
                end;
          else  if (Ch<>CR)and(Not CombKey)and(Not Exit) then
                   begin
                     Write(Ch);
                     InpStr:= InpStr + Ch
                   end;
        end; { case }
      until (Ch=CR) or Exit
    end; { GetStrng }

   procedure ArrySizMssg;
    const
      Mssg1 = ' ENTER size of (sqr) matrix:';
      Mssg2 = '(min=3; max=20)';
    begin
      Play(494,10);
      CentrColrdWndw(Black,47,12,23);
      DfltWndw;
      WriteFast(Mssg1,18,8,Red,White);
      WriteFast(Mssg2,48,8,LightGray,Black+Blink)
    end;

   procedure BttmLines;
    { Draw bottom line with vert. divider at X=40 }
    begin
      ClrLn(25);  ClrLn(24);
      DivdBttmLn(40,Black,LightRed)
    end; { BttmLines }

   begin { GetArrySiz }
     BttmLines;
     ArrySizMssg;
     repeat
       ArraySize:= 0;
       GetStrng(SizStr,Dgts,2);
       Val(SizStr,ArraySize,Code);
       if Not(ArraySize in [3..20])and(Not Exit) then Beep
     until ((Code=0)and(ArraySize in [3..20])) or Exit
   end; { GetArrySiz }


  procedure Process;
   begin
     GetArrySiz(39,11);
     if Not Exit then
        begin
          OpenNewFile_of_Real(MtrxFile,MtrxFilNam);
          InitDiskFile;
          Close(MtrxFile);
          GenratFlagFilNam;
          if Exist(FlagFilNam) then EraseFile(FlagFilNam);
          ReadInData
        end {if Not Exit}
   end;  { Process }


  procedure Warning;
   const
     WrngA='>>> File "';  WrngB='" Exists!! <<<';
     Wrnng='Do You Want to Replace its Contents? <Y/N>:';
   begin
     ClrLn(24); ClrLn(25);
     WriteAtCenter(WrngA+SetUpCase(MtrxFilNam)+WrngB,Black,White,14);
     WriteAtCenter(Wrnng,Black,Yellow,15); Beep; Beep;
     if Not(Yes) then Continue:= False
   end;  { Warning }


  begin  { ProcessFile }
    Continue:= True;
    if Exist(MtrxFilNam) then Warning;
    if Continue then Process
  end;  { ProcessFile }

(* End of Include file PRCSSFIL.INC ******************************************)
