{

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(*****************************************************************************)
(* Beginning of Unit "Messages"                                              *)
(* < Execution Status Messages >                                             *)
(*****************************************************************************)

{ Comprises all the messages that notify the user about the execution of a
  certain task at any one time }

Unit Messages;

Interface

Uses
  Crt,
  MainDecl,
  ColrText;


procedure Suspend(Mssg: Strng80);

procedure CenteredMssg(Mssg: Strng80; BdrpColr,BckColr,ForColr: Byte);

procedure Done_Mssg(x,y,BckColr,ForColr: Byte);

procedure BeginExec_Mssg(BdrpColr,BckColr,ForColr: Byte);

procedure Iter_Mssg(Iter,BdrpColr,BckColr,ForColr1,ForColr2 : Byte);

procedure PairExchng_Mssg(Cntr,BckColr,ForColr1,ForColr2: Byte);

procedure Exit_Mssg;

procedure HowToView_Mssg(BdrpColr,BckColr,ForColr: Byte);

procedure Randomize_Mssg(BdrpColr,BckColr,ForColr: Byte);

procedure FileNams_Mssg(BdrpColr,BckColr,ForColr: Byte);

procedure UnitCostMtx_Mssg(BdrpColr,BckColr,ForColr: Byte);

procedure ReadMtxFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);

procedure ReadFlgsFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);

procedure SavMtxFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);

procedure SavFlgsFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);

procedure InitFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);


{=============================================================================}

Implementation


 procedure Suspend(Mssg: Strng80);
  { Issue a delay according to a linear function of Time(ms) vs. Length(Mssg) }
  begin
    Delay( Round(29.41*Length(Mssg) - 20.0) )
  end;


 procedure CenteredMssg(Mssg: Strng80; BdrpColr,BckColr,ForColr: Byte);
  begin
    BlackYellw; ClrScr;
    ColoredLn(24,BdrpColr); ColoredLn(25,BdrpColr);
    WriteAtCenter(Mssg,BckColr,ForColr,25);
    Suspend(Mssg)
  end;


 procedure Done_Mssg(x,y,BckColr,ForColr: Byte);
  var i: Byte;
  begin
    WriteFast('... DONE ',x,y,BckColr,ForColr)
  end;


 procedure BeginExec_Mssg(BdrpColr,BckColr,ForColr: Byte);
  const
    Mssg = '   Begin Execution ... ';
  begin
    CenteredMssg(Mssg,BdrpColr,BckColr,ForColr)
  end;


 procedure Iter_Mssg(Iter,BdrpColr,BckColr,ForColr1,ForColr2 : Byte);
  const Mssg = ' Iteration ';
  var   s    : String[2];
  begin
    Str(Iter,s);
    ColoredLn(25,BdrpColr);
    WriteFast(Mssg+Dup(33,' '),18,25,BckColr,ForColr1);
    WriteFast(s,29,25,BckColr,ForColr2)
  end;


 procedure PairExchng_Mssg(Cntr,BckColr,ForColr1,ForColr2: Byte);
  const Mssg = 'Pair exchange ';
  var   s    : String[3];
  begin
    Str(Cntr,s);
    WriteFast(Mssg,34,25,BckColr,ForColr1);
    WriteFast(s,48,25,BckColr,ForColr2)
  end;


 procedure Exit_Mssg;
  const
    Mssg = 'Exiting  M.A.C.R.A.F.T.  . . .';
  begin
    BlackLGray; ClrScr;
    PromptFast(Mssg,1,1,Black,Yellow);
    Delay(200); Play(123,30);
    Writeln
  end;


 procedure HowToView_Mssg(BdrpColr,BckColr,ForColr: Byte);
  const
    Mssg = '  Select whether or not to view partial results  ';
  begin
    Play(243,20);
    CenteredMssg(Mssg,BdrpColr,BckColr,ForColr);
    ColoredLn(25,Black)
  end;


 procedure Randomize_Mssg(BdrpColr,BckColr,ForColr: Byte);
  const
    Mssg = ' Randomize Initial Assignment? <Y/N(CR)>:';
  begin
    ColoredLn(25,BdrpColr); Config(BckColr,ForColr);
    WriteAtCenter(Mssg+' ',BckColr,ForColr,25);
    if Yess then RndmAsg:= True else RndmAsg:= False
  end;


 procedure FileNams_Mssg(BdrpColr,BckColr,ForColr: Byte);
  const
    Mssg = ' Please, start entering the file names ';
  begin
    CenteredMssg(Mssg,BdrpColr,BckColr,ForColr)
  end;


 procedure UnitCostMtx_Mssg(BdrpColr,BckColr,ForColr: Byte);
  const
    Mssg = ' Initializing cost matrix with unit cost ... ';
  begin
    CenteredMssg(Mssg,BdrpColr,BckColr,ForColr)
  end;


 procedure ReadMtxFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);
  const
    MsgA = ' Reading in from matrix file "';
    MsgB = '" ... ';
  begin
    CenteredMssg(MsgA+SetUpCase(FilNam)+MsgB,BdrpColr,BckColr,ForColr)
  end;


 procedure ReadFlgsFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);
  const
    MsgA = ' Reading in from flags file "';
    MsgB = '" ... ';
  begin
    CenteredMssg(MsgA+SetUpCase(FilNam)+MsgB,BdrpColr,BckColr,ForColr)
  end;


 procedure SavMtxFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);
  const
    MsgA = ' Saving matrix to file "';
    MsgB = '" ... ';
  begin
    CenteredMssg(MsgA+SetUpCase(FilNam)+MsgB,BdrpColr,BckColr,ForColr)
  end;


 procedure SavFlgsFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);
  const
    MsgA = ' Saving flags array to file "';
    MsgB = '" ... ';
  begin
    CenteredMssg(MsgA+SetUpCase(FilNam)+MsgB,BdrpColr,BckColr,ForColr)
  end;


 procedure InitFile_Mssg(FilNam: Strng24; BdrpColr,BckColr,ForColr: Byte);
  const
    MsgA = ' Initializing disk file "';
    MsgB = '" ... ';
  begin
    CenteredMssg(MsgA+SetUpCase(FilNam)+MsgB,BdrpColr,BckColr,ForColr)
  end;


End.

(* End of Unit "Messages" ****************************************************)
