{

* DESCRIPTION
M.A.C.R.A.F.T. (version 1.0) by Roberto Fontana is a microcomputer
implementation of the CRAFT algorithm, which is used to provide a suboptimal
solution to the "Facility Layout" problem from the field of Operational
Research. Can be used as a valuable aid when designing a production
environment. Written in Turbo Pascal 4.0.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(**********************************************************************************)
(* Description: The M.A.C.R.A.F.T. program stands for "Microcomputer Aplication   *)
(*              of the Computerized Relative Allocation of Facilities Technique", *)
(*              (CRAFT) heuristic algorithm. The algorithm provides a sub-optimal *)
(*              solution  to  the  Facility Layout  problem, which is  frequently *)
(*              encountered  when  designing  intermittent (Job-Shop)  productive *)
(*              systems.                                                          *)
(*                                                                                *)
(* Application: IBM PC and compatibles.                                           *)
(* Last update: March 30, 1988.                                                   *)
(* Author:      Roberto A. Fontana                                                *)
(*              P.O.Box 538; Syracuse, NY 13210                                   *)
(*              (315) 471-1387                                                    *)
(*                                                                                *)
(**********************************************************************************)


{$R-}    {Range checking off}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$V-}    {Var-string checking off}
{$B-}    {Boolean complete evaluation off}
{$N-}    {Numeric coprocessor: No}

program MACRAFT;


Uses
  Crt,
  MainDecl,
  ColrText,
  Messages,
  GtFilNam,
  IntrMenu,
  FileHndl;

{$I ERRHNDLR.INC}

procedure AlgrthmExec;
 const
   Prmpt1= ' Enter File Name of DISTANCES ';
   Prmpt2= ' Enter File Name of WORK-FLOW Rates ';
   Prmpt3= ' Enter File Name of TRANSACTION COSTS ';
 var
   Choice                   : Char;
   DSize, WSize, CSize      : Integer;
   Proceed,ReStart,Continue,
   Exit,    Rpeat, UnitCost : Boolean;

 {$I EXECUTE.INC}
 {$I FCHNXTMV.INC}
 {$I FLLINMTX.INC}

 begin { AlgrthmExec }
   AlgExecIntrdctn;
   AlgExecNotice(Proceed);
   if Proceed then
      begin
        repeat
          repeat
            FileNams_Mssg(Blue,Black,Yellow);
            FillIn_WorkMtrx(Distance,MtrxFilNam,Prmpt1,'1');
            if Continue then FillIn_WorkMtrx(WorkFlow,MtrxFilNam,Prmpt2,'2');
            if Continue then FillIn_WorkMtrx(TransCost,MtrxFilNam,Prmpt3,'3')
          until Continue or Exit;
          if Not(Exit) then
             repeat
               AlgExecMenu(Choice,Exit);
               case Choice of
               '1': Execute('ByIter');
               '2': Execute('Entire');
               '3': Exit:= True
               end; {case}
               if (Choice<>'3') and (Not Exit) then Fetch_NextMove;
             until Rpeat or Exit
        until Exit
      end {if Proceed}
 end; { AlgrthmExec }




procedure DataEntry;
 const
   Mssg = 'Return to previous menu';
 var
   Choice: Char;
   Exit  : Boolean;


 procedure FillOutMtrx( WrkMtrx: Matrix;  Typ: Char;  ArrySiz: Integer;
                        var MtrxFilNam: Strng24;  Status: Strng6);
  { In charge of all interactive data entry from user }

  {$I FLLOUTMX.DEC}
  {$I FLLFIELD.INC}
  {$I GETDTVAL.INC}
  {$I FLLSCRN.INC}
  {$I FLLFILE.INC}
  {$I FLLDATA.INC}

  { begin } { FillOutMtrx }
  {$I FLLOUTMX.BDY}
  { end } { FillOutMtrx }


 procedure UpdateMatrix;
  { In charge of Menus and of calling "FillOutMtrx" for the 'update' case }
  const
    Prompt = ' Enter name of file to UPDATE ';

  {$I UPDATFIL.INC}

  begin { UpdateMatrix }
    Get_Mtrx_FilNam( MtrxFilNam,
                     28,12,Blue,Black,Yellow,Yellow,
                     Prompt, Mssg, 'U', 'UPDATE', Exit );
    if Length(MtrxFilNam) > 0 then UpdatFile
  end; { UpdateMatrix }


 procedure CreateMatrix;
  { In charge of Menus and of calling "FillOutMtrx" for the 'create' case }
  const
    Prompt = ' Enter name of file to CREATE ';
  var
    Reply: Char;

  {$I PRCSSFIL.INC}

  begin  { CreateMatrix }
    repeat
      CreatMtrxMenu(Reply,Exit);
      if Reply in ['1'..'3'] then
         begin
           if ShowWrnng then WrnngNotice;
           Get_Mtrx_FilNam( MtrxFilNam,
                            28,12,Blue,Black,Yellow,Yellow,
                            Prompt, Mssg, Reply, 'CREATE', Exit );
           if Length(MtrxFilNam) > 0 then ProcessFile
         end
    until (Reply= '4') or Exit
  end;   { CreateMatrix }


 begin { DataEntry }
   DatEntryIntrdctn;
   DatEntryNotice;
   repeat
     DatEntryMenu(Choice,Exit);
     case Choice of
      '1': CreateMatrix;
      '2': UpdateMatrix;
     end {case}
   until (Choice= '3') or Exit
 end; { DataEntry }




BEGIN { main }
  Init_ErrorHndlr;
  MainIntrdctn;
  repeat
    MainMenu(Choice,Done);
    case Choice of
     '1': DataEntry;
     '2': AlgrthmExec
    end {case}
  until (Choice= '3') or Done;
  Exit_Mssg
END. { main }
