{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(*****************************************************************************)
(* Beginning of Unit "IntrMenu"                                              *)
(* < Introductory Screens and Menus >                                        *)
(*****************************************************************************)

{ Used by all the relevant procedures in the program to create menus,
  introductory screens, and message-screens }

Unit IntrMenu;

Interface

Uses
  Crt,
  MainDecl,
  ColrText,
  Messages;


procedure Intrdctn(MidStr,KeyStr: Strng80; KeyBColr,KeyFColr,Levl: Byte);
  { Creates a somewhat generic introductory screen for opening program (Levl=1)
    and for opening both main subsequent sections (Levl=2) }

procedure Menu( var Reply: Char;  var Quit: Boolean;
                 Mssg,Str1,Str2,Str3,Str4: Strng80;
                 NoStrs, BckColr,WdwColr,DLnColr,SLnColr,
                 NosColr,TxTColr,LwrLmt: Byte;  Hrtz,msec: Integer );
  { Creates a somewhat generic menu based upon the parameters received. To be
    used by all menu-creation procedures in the program }

procedure Notice( Ln1,Ln2,Ln3,Ln4,Ln5,Ln6,Ln7,Ln8,Ln9,
                   Ln10,Ln11,Ln12,Ln13,Ln14,Ln15: Strng80;  NoLns,
                   BckColr,WdwColr,DLnColr,SLnColr,TxTBckColr,TxTForColr,
                   WdwWdth,WdwHght,LwrLimt,TopLine: Byte;
                   Draw: Boolean );

procedure MainIntrdctn;

procedure DatEntryIntrdctn;

procedure AlgExecIntrdctn;

procedure MainMenu(var Reply: Char;  var Quit: Boolean);

procedure DatEntryMenu(var Reply: Char;  var Quit: Boolean);

procedure AlgExecMenu(var Reply: Char;  var Quit: Boolean);

procedure CreatMtrxMenu(var Reply: Char;  var Quit: Boolean);

procedure DatEntryNotice;

procedure AlgExecNotice(var Proceed: Boolean);

procedure WrnngNotice;


{=============================================================================}

Implementation


 procedure Intrdctn(MidStr,KeyStr: Strng80; KeyBColr,KeyFColr,Levl: Byte);
  { Creates a somewhat generic introductory screen for opening program (Levl=1)
    and for opening both main subsequent sections (Levl=2) }

  const
    Str1= 'MICROCOMPUTER APPLICATION OF THE C.R.A.F.T. HEURISTIC ALGORITHM';
    Str2= '(Computerized Relative Allocation of Facilities Technique)';
    Str3= 'Copyright (C) 1988,  Roberto A. Fontana';
    Str4= '( M.A.C.R.A.F.T.,  v 1.0 )';
  const
    BckColr  = Black;  DLnColr = Cyan;   SLnColr= LightRed;
    WdwColr1 = Black;  WdwColr2= Blue;
    TxBckColr= Black;  TxTColrA= Yellow; TxTColrB= LightGray; TxTColrC= White;

  procedure WriteMssg2;
   begin
     WriteAtCenter(Str1,BckColr,TxTColrA,3);
     WriteAtCenter(Str2,BckColr,TxTColrB,4);
     WriteAtCenter(Str4,BckColr,TxTColrC,5);
     WriteAtMiddle(MidStr,TxBckColr,TxTColrA,25);
     Play(123,50); Delay(50); Play(988,50)
   end;

  procedure WriteMssg1;
   begin
     WriteAtMiddle(Str1,TxBckColr,TxTColrA,19);
     WriteAtMiddle(Str2,TxBckColr,TxTColrB,21);
     WriteAtCenter(Str4,BckColr,TxTColrC,12);
     WriteAtMiddle(Str3,TxBckColr,TxTColrA,28);
     Play(988,70); Delay(50); Play(123,70)
   end;

  procedure BckGrnd;
   var
     WdwWdth: Byte;
   begin
     BlackLGray;
     ClrScr;
     case Levl of
       1: begin
            WdwWdth:= Length(Str1) + 5;
            Paint(BckColr,WdwColr1,DLnColr,SLnColr,78,21,WdwWdth,8,23);
            CentrWndwBox(BckColr,SLnColr,WdwWdth+2,10,23,'Double')
          end;
       2: begin
            WdwWdth:= Length(MidStr) + 8;
            Paint(BckColr,WdwColr2,DLnColr,SLnColr,78,21,WdwWdth,5,23);
            CentrColrdWndw(TxBckColr,WdwWdth,1,23)
          end
     end; {case}
     DfltWndw
   end; { BckGrnd }

  begin { Intrdctn }
    BckGrnd;
    case Levl of
      1: WriteMssg1;
      2: WriteMssg2
    end; {case}
    PressAnyKey(KeyStr,KeyBColr,KeyFColr)
  end; { Intrdctn }




 procedure Menu( var Reply: Char;  var Quit: Boolean;
                 Mssg,Str1,Str2,Str3,Str4: Strng80;
                 NoStrs, BckColr,WdwColr,DLnColr,SLnColr,
                 NosColr,TxTColr,LwrLmt: Byte;  Hrtz,msec: Integer );
  { Creates a somewhat generic menu based upon the parameters received.
    To be used by all menu-creation procedures in the program }

  const
    MssgA= ' MENU: ';  MssgB= ' Choice?:';
    MssgC= 'M.A.C.R.A.F.T., v 1.0;  (C) 1988, R.A.Fontana';
    MgABckColr= LightGray;  MgAForColr= Red;
    MgBBckColr= LightGray;  MgBForColr= Black;
    ESC = ^[;

  var
    Str : array[1..4] of String[50];
    No  : array[1..4] of String[2];
    WdwWdth,WdwHght : Byte;

  function LngstStr: Byte;
   { Calculates the longest string }
   var i,MaxLen: Byte;
   begin
     MaxLen:= 0;
     for i:=1 to NoStrs do
         if Length(Str[i])>MaxLen then MaxLen:= Length(Str[i]);
     LngstStr:= MaxLen
   end;

  procedure WriteMenu;
   var
     i,MgARow,MgBRow,Str1X,Str1Y: Byte;
   procedure MenuDims;
    { Calculates vert.pos.of MssgA/B, as well as coords.of 1st-line's 1st-Chr }
    begin
      MgARow:= (LwrLmt-WdwHght) div 2 - 2;
      MgBRow:= MgARow + WdwHght + 4;
      if Mssg='MAIN' then begin
         MgARow:= MgARow - 1;
         MgBRow:= MgBRow + 1
         end; {if}
      Str1X:= (80-LngstStr) div 2 - 1;
      Str1Y:= (LwrLmt-WdwHght) div 2 + 1
    end;
   begin { WriteMenu }
     MenuDims;
     WriteAtCenter(MssgA+Mssg+' ',MgABckColr,MgAForColr,MgARow);
     for i:=1 to NoStrs do WriteFast(No[i],Str1X,Str1Y+2*i,WdwColr,NosColr);
     for i:=1 to NoStrs do WriteFast(Str[i],Str1X+3,Str1Y+2*i,WdwColr,TxTColr);
     WriteAtCenter(MssgB,MgBBckColr,MgBForColr,MgBRow);
     Play(Hrtz,msec)
   end; { WriteMenu }

  procedure BckGrnd;
   var BlckHght: Byte;
   begin
     BlckHght:= LwrLmt - 2;
     Paint(BckColr,WdwColr,DLnColr,SLnColr,78,BlckHght,WdwWdth,WdwHght,LwrLmt);
     if Mssg= 'MAIN' then begin
        CentrWndwBox(Black,LightRed,WdwWdth+2,WdwHght+2,LwrLmt,'Double');
        WriteAtCenter(MssgC,Black,Yellow,2)
     end {if}
   end;

  procedure WndwDims;
   { Calculates width & hight of the window based on the longest Str and the
     No of Strs, respectively }
   begin { WndwDims }
     WdwWdth:= LngstStr + 10;
     WdwHght:= 2*NoStrs + 3     { NoStrs + (NoStrs-1) + 4 }
   end; { WndwDims }

  procedure Assgn;
   begin
     Quit:= False;
     Str[1]:= Str1;  Str[2]:= Str2;  Str[3]:= Str3;  Str[4]:= Str4;
     No[1] := '1:';  No[2] := '2:';  No[3] := '3:';  No[4] := '4:'
   end;

  begin { Menu }
    Assgn;
    WndwDims;
    BckGrnd;
    WriteMenu;
    repeat
      Reply:= ReadKey;
      if Reply=ESC then Quit:= True
    until (Reply in ['1'..Chr(NoStrs+48)]) or Quit
  end; { Menu }




 procedure Notice( Ln1,Ln2,Ln3,Ln4,Ln5,Ln6,Ln7,Ln8,Ln9,
                   Ln10,Ln11,Ln12,Ln13,Ln14,Ln15: Strng80;  NoLns,
                   BckColr,WdwColr,DLnColr,SLnColr,TxTBckColr,TxTForColr,
                   WdwWdth,WdwHght,LwrLimt,TopLine: Byte;
                   Draw: Boolean );

  var
    Ln : array[1..15] of Strng80;
    LeftCol, TopRow: Byte;

  procedure WriteNotice;
   var i: Byte;
   begin
     for i:=1 to NoLns do
         PromptFast(Ln[i],LeftCol,TopRow+i,TxTBckColr,TxTForColr)
   end; {WriteNotice}

  procedure BckGrnd;
   begin
     BlackLGray; ClrScr;
     Paint( BckColr,WdwColr,DLnColr,SLnColr,
            78,LwrLimt-2,WdwWdth,WdwHght,LwrLimt )
   end; {BckGrnd}

  procedure Origin;
   { calculates on which Col all the lines will be aligned. The longest line
     will be centered on the screen. All the other ones will start at the
     same Col as the longest one }
   function LngstLn: Byte;
    var i, MaxLen: Byte;
    begin
      MaxLen:= 0;
      for i:=1 to NoLns do
          if Length(Ln[i])>MaxLen then MaxLen:= Length(Ln[i]);
      LngstLn:= MaxLen
    end;
   begin {Origin}
     LeftCol:= (80-LngstLn) div 2 + 1;
     TopRow:= TopLine - 1
   end; {Origin}

  procedure Assgn;
   begin
     Ln[1]:= Ln1;  Ln[2]:= Ln2;  Ln[3]:= Ln3;  Ln[4]:= Ln4;  Ln[5]:= Ln5;
     Ln[6]:= Ln6;  Ln[7]:= Ln7;  Ln[8]:= Ln8;  Ln[9]:= Ln9;  Ln[10]:=Ln10;
     Ln[11]:=Ln11; Ln[12]:=Ln12; Ln[13]:=Ln13; Ln[14]:=Ln14; Ln[15]:=Ln15
   end;

  begin { Notice }
    Assgn;
    Origin;
    if Draw then BckGrnd;
    WriteNotice
  end; { Notice }




 procedure MainIntrdctn;
  const
    KeyStr = 'to BEGIN PROGRAM';
  begin
    Intrdctn('',KeyStr,Black,White,1)
  end; { MainIntrdctn }



 procedure DatEntryIntrdctn;
  const
    MidStr = 'DATA ENTRY Section';
    KeyStr = 'to BEGIN';
  begin
    Intrdctn(MidStr,Keystr,Blue,Yellow,2)
  end; { DatEntryIntrdctn }



 procedure AlgExecIntrdctn;
  const
    MidStr = 'ALGORITHM EXECUTION Section';
    KeyStr = 'to BEGIN';
  begin
    Intrdctn(MidStr,KeyStr,Blue,Yellow,2)
  end; { AlgExecIntrdctn }



 procedure MainMenu(var Reply: Char;  var Quit: Boolean);
  const
    Mssg = 'MAIN';
    Str1 = 'DATA ENTRY Section';
    Str2 = 'ALGORITHM EXECUTION Section';
    Str3 = 'Exit (Esc)';
  begin
    Menu( Reply,Quit,Mssg,Str1,Str2,Str3,'',3,
          Black,Black,Cyan,LightRed,White,Yellow,25,494,50)
  end; { MainMenu }



 procedure DatEntryMenu(var Reply: Char;  var Quit: Boolean);
  const
    Mssg = 'Data Entry';
    Str1 = 'CREATE a new matrix-file';
    Str2 = 'UPDATE an existing matrix-file';
    Str3 = 'RETURN to Main Menu (Esc)';
  begin
    Menu( Reply,Quit,Mssg,Str1,Str2,Str3,'', 3,
          Black,Blue,Cyan,LightRed,LightRed,Yellow,25,988,50)
  end; { DatEntryMenu }



 procedure AlgExecMenu(var Reply: Char;  var Quit: Boolean);
  const
    Mssg = 'Algorithm Execution';
    Str1 = 'SHOW RESULTS AFTER EACH ITERATION';
    Str2 = 'SHOW FINAL RESULTS ONLY';
    Str3 = 'Exit (Esc)';
  begin
    HowToView_Mssg(Blue,Black,Yellow);
    Menu( Reply,Quit,Mssg,Str1,Str2,Str3,'', 3,
          Black,Blue,Cyan,LightRed,LightRed,Yellow,24,988,50)
  end; { AlgrthmExecMenu }



 procedure CreatMtrxMenu(var Reply: Char;  var Quit: Boolean);
  const
    Mssg = 'Create Matrix';
    Str1 = 'Distances between locations';
    Str2 = 'Work flow rates between work-centers';
    Str3 = 'Transaction costs between work-centers';
    Str4 = 'RETURN to previous menu';
  begin
    Menu( Reply,Quit,Mssg,Str1,Str2,Str3,Str4, 4,
          Blue,Black,Yellow,Yellow,LightRed,Yellow,25,494,10)
  end; { CreatMtrxMenu }



 procedure DatEntryNotice;
  const
    Ln1 = 'Would you like to include the warning';
    Ln2 = 'message regarding file names? <Y/N(CR)>:';
    Mssg= '( You should, if this is your first time )';

  begin { DatEntryNotice }
    Notice( Ln1,Ln2,'','','','','','','','','','','','','',2,
            Black,Black,LightRed,LightCyan,Black,Yellow,50,5,25,12,True );
    WriteAtCenter(Mssg,Black,LightGray,14);
    BlackWhite; Gotoxy(WhereX,WhereY-1);
    Play(123,20); Delay(7); Play(494,20);
    if Yess then ShowWrnng:= True
    else ShowWrnng:= False
  end; { DatEntryNotice }



 procedure AlgExecNotice(var Proceed: Boolean);
  const
    Ln1 = 'You will be prompted to input the            ';
    Ln2 = 'names of the data files of:';
    Ln3 = '- DISTANCES between locations';
    Ln4 = '- WORK FLOW RATES between work-centers';
    Ln5 = '- TRANSACTION COSTS between work-centers (Optional)';
    Ln6 = '  These files MUST be created in the "DATA ENTRY Section".';
  const
    CR = ^M;  ESC = ^[;
  var
    Ch    : Char;
    Return: Boolean;

  begin { AlgExecNotice }
    Proceed:= False;  Return:= False;
    Notice( Ln1,Ln2,'','','','','','','','','','','','','',2,
            Black,Black,LightRed,LightCyan,Black,Yellow,64,12,23,8,True);
    Notice( Ln3,Ln4,Ln5,'','','','','','','','','','','','',3,
            Black,Black,LightRed,LightCyan,Black,LightGray,60,10,23,11,False);
    Notice( Ln6,'','','','','','','','','','','','','','',1,
            Black,Black,LightRed,LightCyan,Black,Yellow,60,10,23,15,False);
    ColoredLn(25,Black);
    DivdBttmLn(40,Black,Green);
    Draw_Enter(2,25);  Draw_Esc(42,25);
    WriteFast('Proceed',6,25,Black,White);
    PromptFast('Return to Main Menu',46,25,Black,White);
    Play(123,20); Delay(7); Play(494,20);
    repeat
      Ch:= ReadKey;
      case Ch of
       CR : Proceed:= True;
       ESC: Return:= True;
       else Play(900,10)
      end; {case}
    until Proceed or Return
  end; { AlgExecNotice }



 procedure WrnngNotice;
  const
    Mssg= ' W A R N I N G ';
    Ln1 = 'If two different files are to have slightly different names,';
    Ln2 = 'make sure that the last character of the three-char extension';
    Ln3 = 'IS NOT the ONLY one that makes the difference between the two';
    Ln4 = 'names.';
    Ln5 = 'ANY other character can be the ONLY different one.';
    Ln6 = 'For example, file names';
    Ln7 = '              DISTANCE.001  and  DISTANCE.002';
    Ln8 = 'for two different files, should be avoided.';
    Ln9 = 'Use instead,';
    Ln10= '              DISTANCE.010  and  DISTANCE.020,  or so.';
    Ln11= 'If you choose to use file-names with  one-  or  two-char';
    Ln12= 'extension, or no extension at all, disregard this notice.';

  begin { WrnngNotice }
    BlackLGray; ClrScr;
    Notice( Mssg,'','','','','','','','','','','','','','',1,
            Black,Black,LightRed,LightRed,LightGray,Red+Blink,70,17,23,5,True);
    Notice( Ln1,Ln2,Ln3,Ln4,Ln5,Ln6,Ln7,Ln8,Ln9,Ln10,Ln11,Ln12,'','','',12,
            Black,Black,LightRed,LightRed,Black,White,70,17,23,7,False );
    Play(123,50); Delay(5); Play(900,50);
    PressAnyKey('to continue',Red,White)
  end; { WrnngNotice }



End.

(* End of Unit "IntrMenu" ****************************************************)
