{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

* CHECKED BY
DRM - 03/17/88

* KEYWORDS
CONTEST TUG-O-WARDS PROGRAM PASCAL V4.0

==========================================================================
}
(*****************************************************************************)
(* Beginning of Unit "GtFilNam"                                              *)
(* < File-Name Retrieval >                                                   *)
(*****************************************************************************)

{ Used by all relevant procedures in order to get a file name }

Unit GtFilNam;

Interface

Uses
  Crt,
  MainDecl,
  ColrText,
  FileHndl;



procedure Get_Mtrx_FilNam(var FilNam: Strng24;
                          X,Y,BckColr,WdwColr,DLnColr,SLnColr: Byte;
                          Prompt, Mssg: Strng80;
                          PsdoRply: Char; Status: Strng6; var Quit: Boolean);
  { Gets a file name at pos (X,Y), allowing the input of only the DOS legal
    file-name characters }


{=============================================================================}

Implementation


 procedure Get_Mtrx_FilNam(var FilNam: Strng24;
                          X,Y,BckColr,WdwColr,DLnColr,SLnColr: Byte;
                          Prompt, Mssg: Strng80;
                          PsdoRply: Char; Status: Strng6; var Quit: Boolean);
  { Gets a file name at pos (X,Y), allowing the input of only the DOS legal
    file-name characters }

  const
    ValidChars: CharSet =
    ['A'..'Z','a'..'z','0'..'9','!','#'..')',
     '-','.',':','\','@','^'..'`','{','}','~'];


  procedure ERROR_Wrnng;
   const
     Wrnng= '>>> Invalid filename (or path)!! <<<';
     Mssg = 'Try again!';
   begin
     WriteAtCenter(' ERROR ',Red,Yellow+Blink,14);
     WriteAtCenter(Wrnng,Black,White,15);
     WriteAtCenter(Mssg,Black,White,16); Gotoxy(WhereX-1,16);
     Play(247,100); Delay(20); Play(988,100); Delay(2000);
     WriteAtCenter(' ERROR ',Black,Black,14);
     WriteAtCenter(Wrnng,Black,Black,15);
     WriteAtCenter(Mssg,Black,Black,16)
   end; { ERROR-Wrnng }


  procedure Mssg_of_UnitCost;
   const
     Ln1 = 'If you wish to use a unit cost for';
     Ln2 = 'ALL transactions between work-centers';
     Ln3 = 'enter the number "1" instead of a file name';
   begin
     WriteAtCenter(Ln1,Black,White,Y+2);
     WriteAtCenter(Ln2,Black,White,Y+3);
     WriteAtCenter(Ln3,Black,White,Y+4);
     Play(243,100); Delay(100); Play(243,100);
     Gotoxy(X,Y)
   end;


  procedure Clr_UnitCostMsg;
   var i: Byte;
   begin
     for i:=2 to 4 do WriteAtCenter(Dup(43,' '),Black,White,Y+i);
     Gotoxy(X+1,Y)
   end;


  procedure ShowMessg2;
   { Messages of "Enter name" and "Clear field" for "Enter" and "Del" respct.}
   begin
     ClrEol_at(6,25);
     Draw_Del(21,25);
     Draw_Esc(42,25);
     WriteFast('Enter name',6,25,Black,Yellow);
     WriteFast('Clear field',25,25,Black,LightRed);
     WriteFast('Exit to Main Menu',46,25,Black,LightCyan);
     VertBar(1,40,25,Black,LightRed);
     Gotoxy(X+1,Y)
   end;


  procedure ShowMessg1;
   { Message of "Mssg" for "Enter" }
   begin
     ClrEol_at(6,25);
     Draw_Esc(42,25);
     WriteFast(Mssg,6,25,Black,Yellow);
     WriteFast('Exit to Main Menu',46,25,Black,LightCyan);
     VertBar(1,40,25,Black,LightRed);
     Gotoxy(X,Y)
   end;


  procedure GetNam(var Inpstr: Strng24;
                       Inpset: CharSet; Maxlen: Integer);
   { Gets a valid input strng from keybrd allowing to end the input with a CR,
     or to get out at any time by pressing "ESC". Allows switching between two
     messages as the 1st chr is typed or removed. It also allows to clear the
     field by using "Del" }

   const
     BS  = ^H;  { Back Space }            NUL = #0;   { Null Char. }
     CR  = ^M;  { Carriage Return }       Del = #83;  { Delete key }
     ESC = ^[;  { Escape key }
   var
     Ch   : Char;     { Char read }       CombKey: Boolean;  { Comb'tn key }
     OKset: CharSet;  { Allowed set }

   procedure Clear;
    begin
      InpStr:= '';  CombKey:= False;  Quit:= False;
      WriteFast(Dup(MaxLen,'_'),X,Y,Black,Yellow)
    end;

   begin { GetNam }
     Clear;
     repeat { until Ch=CR }
       CombKey:= False;
       if Length(Inpstr) < 1 then begin
          OKset:= Inpset + [CR,ESC];  ShowMessg1;
          if (PsdoRply='3') and (Status='FILLIN') then Mssg_of_UnitCost
          end
       else begin
          if Length(Inpstr)=1 then begin
             ShowMessg2;
             if (PsdoRply='3') and (Status='FILLIN') then Clr_UnitCostMsg
             end;
          if Length(Inpstr) < Maxlen
             then OKset:= Inpset + [CR,BS,ESC,NUL]
             else OKset:= [CR,BS,ESC,NUL]
          end;
       repeat
         Ch:= ReadKey;
         if Not(Ch in OKset) then Play(900,10)
       until Ch in OKset;
       case Ch of
         BS  : begin
                 Write(Ch);
                 Write('_' + BS);
                 Delete(InpStr,Length(InpStr),1)
               end;
         NUL : begin
                 Ch:= ReadKey;
                 if Ch=Del then Clear else CombKey:= True
               end;
         ESC : begin
                 Clear;
                 Quit:= True
               end;
         else  if (Ch<>CR)and(Not CombKey) then
                  begin
                    Write(Ch);
                    InpStr:= InpStr + Ch
                  end;
       end { case }
     until (Ch=CR) or Quit
   end; { GetNam }


  procedure Prmpt_of_EnterName;
   begin
     WriteAtCenter(Prompt,Red,White,Y-3);
     Play(494,10)
   end;


  procedure MtrxTypMessg;
   { Top message of matrix type }
   const
     Mtrx   =' MATRIX';
     ColrBck=LightGray; Colr1=Red; Colr2=Blue;
   begin
     WriteFast(Mtrx,3,2,ColrBck,Colr1);
     case PsdoRply of
      '1': WriteFast(':Distances ',10,2,ColrBck,Colr2);
      '2': WriteFast(':Work-Flow rates ',10,2,ColrBck,Colr2);
      '3': WriteFast(':Transaction costs ',10,2,ColrBck,Colr2);
     end {case}
   end; { MtrxTypMessg }


  procedure BttmLines;
   { Bottom line with divider and "Enter" symbol }
   begin
     ClrLn(25);  ClrLn(24);
     DivdBttmLn(40,Black,LightRed);
     Draw_Enter(2,25)
   end; { BttmLines }


  procedure BckGrnd;
   var
     WndwWdth: Byte;
   begin
     if Length(Prompt) > 52 then Beep;
     WndwWdth:= Length(Prompt) + 24;
     Paint(BckColr,WdwColr,DLnColr,SLnColr,78,21,WndwWdth,12,23)
   end; { BckGrnd }


  begin { Get_Mtrx_FilNam }
    BckGrnd;
    BttmLines;
    if (Status='CREATE') or (Status='FILLIN') then MtrxTypMessg;
    repeat
      Prmpt_of_EnterName;
      GetNam(FilNam,ValidChars,24);
      if Not ValidFileNam(FilNam) then ERROR_Wrnng
    until ValidFileNam(FilNam)
  end; { Get_Mtrx_FilNam }


End.

(* End of Unit "GtFilNam" ****************************************************)
