{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(*****************************************************************************)
(* Beginning of Include file GETDTVAL.INC                                    *)
(* < Matrix Fill-Out Value Retrieval >                                       *)
(*****************************************************************************)

procedure GetDataVal(Row, Col: Integer);
 { Configures field before and after getting a value according to whether or
   not it had been updated. Gets value from field at coords (Row,Col) }
 type
   String8 = String[8];

 var
   CurrVal,NewVal : Real;     { Current/New value }
   ResetFld       : Boolean;  { Flag to reset field to empty state }


 procedure SetFlag(i,j: Integer);
  begin FLAG[i,j]:= 1 end;


 procedure ClrFlag(i,j: Integer);
  begin FLAG[i,j]:= 0 end;


 procedure SetVal(i,j: Integer);
  { Updates WrkMtrx when a new value is entered }
  begin
    WrkMtrx[i,j]:= NewVal;
    if Not LocUpdated(i,j) then begin
       SetFlag(i,j); NoONflags:= NoONflags+1 end
  end; { SetVal }


 procedure WriteSymmElmnt(elmnt: String8; Val: Real; X,Y,BckColr,ForColr: Byte);
  { Writes elmnt ['__',NewVal,or CurrVal] in field at (Y,X) if type 'D' mtrx }
  begin
    if LeftScrnON then WriteElmnt(elmnt,Val,X,Y,BckColr,ForColr)
    else begin {i.e.,if left screen is OFF}
           if Row > LeftMaxCol then WriteElmnt(elmnt,Val,X,Y,BckColr,ForColr)
           else SymmElmnts:= True
         end
  end; { WriteSymmElmnt }


 procedure EmptyState;
  { Updates WrkMtrx when "Home" is pressed and field is left }
  procedure Reset(i,j: Integer);
   begin
     WrkMtrx[i,j]:= BigNo;
     ClrFlag(i,j); NoONflags:= NoONflags-1
   end;
  begin { EmptyState }
    Reset(Row,Col);
    EmptFldColrs;
    WriteElmnt( 'UndScors',dumR,
                 LocfCol[Col],LocfRow[Row],EFBckColr,EFForColr );
    if Typ='D' then
      begin
        Reset(Col,Row);
        DissFldColrs;
        WriteSymmElmnt( 'UndScors',dumR,
                         LocfCol[Row],LocfRow[Col],DFBckColr,DFForColr )
      end
  end; { EmptyState }


 procedure GetStr(var Inpstr: Strng80; var IntPart: Byte;
                      Inpset: CharSet;  Maxlen,X,Y : Byte);
  { Returns a valid numeric input string from keyboard allowing to end the
    input by hitting either CR or any of the arrow keys. It also returns the
    length of the integer part of the number entered }
  const
    DCM  = '.';  { Decimal point }
    DEL  = #83;  { Delete key }         NUL= #0;  { Null char.}
    HOME = #71;  { Home key }           BS  = ^H;  { Back Space }
    { Both CR and the Arrow-Keys are declared in proc. "FillOutMtrx" }
  var
    Arrkey : Boolean;  { Arrow key }    DCMnotInp : Boolean;  { DCM not input }
    OKset  : CharSet;  { Allowed set }  IntCnt    : Byte;     { Integer count }

  procedure UpdateIntCnt;
   begin
     case Ch of
       BS : begin
              if Length(Inpstr) <= IntCnt then
                begin DCMnotInp:= True; IntCnt:= Length(Inpstr) end
            end;
       else begin
              if Ch<>DCM then
                begin if DCMnotInp then IntCnt:= Length(Inpstr) end
              else DCMnotInp:= False
            end;
     end; { case }
     IntPart:= IntCnt
   end; { UpdateIntCnt }

  procedure Initialize;
   begin
     IntPart := 0;  IntCnt := 0;  Inpstr := '';
     DCMnotInp:= True; Arrkey:= False; ResetFld:= False
   end;

  procedure Clear;
   begin
     Initialize; Gotoxy(X,Y);
     Write(Dup(7,'_')); Gotoxy(X,Y)
   end;

  begin { GetStr }
    Initialize;
    repeat
      if Length(Inpstr) < 1 then
         OKset:= Inpset + [CR,NUL]
      else { if it is >= 1 }
           if Length(Inpstr) < Maxlen
              then OKset:= Inpset + [CR,BS,NUL]
              else OKset:= [CR,BS,NUL];
      repeat
        Ch:= ReadKey;
        if Not(Ch in OKset) then Play(900,10)
      until Ch in OKset;

      case Ch of
        BS  : begin
                Write(Ch);
                Write('_' + BS);
                Delete(Inpstr,Length(Inpstr),1);
                UpdateIntCnt
              end;
        NUL : begin
                Ch:= ReadKey;
                if Ch in ArrsSet then Arrkey:= True;
                if Ch=DEL then Clear;
                if Ch=HOME then begin
                   Play(49,100); Clear;
                   ResetFld:= True
                   end;
              end;
        else  if (Ch<>CR) and Not Arrkey then
                begin
                  Write(Ch);
                  Inpstr:= Inpstr + Ch;
                  UpdateIntCnt;
                  ResetFld:= False
                end;
      end; { case }
    until (Ch=CR) or Arrkey
  end; { GetStr }


 procedure FillField(Xpos,Ypos: Byte);
  { Prepare field before getting new-value,i.e.if field is empty show under_
    scores; if not empty, then show current value }
  begin
    InvVideo;
    Gotoxy(Xpos,Ypos);
    if LocUpdated(Row,Col) then
       begin
         FixInts(Row,Col);
         WriteElmnt('CurrentV',CurrVal,LocfCol[Col],LocfRow[Row],LightGray,Black)
       end {if LocUpdated}
    else WriteElmnt('UndScors',dumR,LocfCol[Col],LocfRow[Row],LightGray,Black);
    Gotoxy(Xpos,Ypos)
  end; { FillField }


 procedure GetNewVal(Xpos,Ypos: Byte);
  { With the help of "GetStr", get a string into "Strng" and convert it to
    the Real # "NewVal" }
  const
    Digits : CharSet = ['.', '-', '0'..'9', 'e', 'E'];
  var
    Strng : Strng80;
    Code  : Integer;

  begin { GetNewVal }
    NewVal:= WrkMtrx[Row,Col];
    repeat
      FillField(Xpos,Ypos);
      GetStr(Strng, NoInt, Digits, 7, Xpos, Ypos);
      if Strng[1]='.' then Strng:= '0' + Strng;
      {$R-}   {To avoid a "RunTime Error" if out of range when using "Val"}
      Val(Strng,NewVal,Code);
      if Strng = '' then begin
         NewVal:= WrkMtrx[Row,Col];
         Code:= 0
         end;
      if (Code<>0) or (NewVal<0) then Beep;
    until (Code=0) and (NewVal>=0);
    if NewVal=0.0 then NoInt:= 0
  end; { GetNewVal }


 begin { GetDataVal }
   CurrVal:= WrkMtrx[Row,Col];
   GetNewVal(LocfCol[Col],LocfRow[Row]);

   if NewVal=CurrVal then  { i.e., no digit has been entered }
     begin
       if LocUpdated(Row,Col) then
         begin
           if ResetFld then EmptyState  { i.e., <Ctrl>Home was pressed }
           else begin
                  UpdtFldColrs; FixInts(Row,Col);
                  WriteElmnt( 'CurrentV',CurrVal,
                               LocfCol[Col],LocfRow[Row],UFBckColr,UFForColr )
                end
         end { if LocUpdated }
       else { if Loc Not Updated }
         begin
           EmptFldColrs;
           WriteElmnt( 'UndScors',dumR,
                        LocfCol[Col],LocfRow[Row],EFBckColr,EFForColr )
         end
     end { if NewVal=CurrVal }
   else { if NewVal<>CurrVal,i.e.,at least one digit was entered }
     begin
       SetVal(Row,Col);
       UpdtFldColrs;
       WriteElmnt( 'NewValue',NewVal,
                    LocfCol[Col],LocfRow[Row],UFBckColr,UFForColr );
       if Typ='D' then begin
          SetVal(Col,Row);
          DissFldColrs;
          WriteSymmElmnt( 'NewValue',NewVal,
                           LocfCol[Row],LocfRow[Col],DFBckColr,DFForColr )
          end
     end { if NewVal<>CurrVal }
 end; { GetDataVal }

(* End of Include file GETDTVAL.INC ******************************************)
