{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

}
(*****************************************************************************)
(* Beginning of Include file FLLSCRN.INC                                     *)
(* < Matrix Fill-Out Screen Handling >                                       *)
(*****************************************************************************)

 procedure GenratScrn(Scrn: Strng6);
  { Generates the whole data entry working space,including the mtrx-position
    idntfiers and the From/To title for the three different types of matrices
    and for the three cases of Middle(1-Scrn), Left, or Right(2-Scrn) screens.
    The scrn is not regenerated if the user presses "Enter" and then decides
    not to save in disk. ( Done by means of the 'X'scrnBlank flag ) }
  var
    Selector: Char;


  procedure CleanUp;
   begin
     ColoredWindow(Black,3,23,1,80);
     DfltWndw
   end;


  procedure MtrxToScrnMap(FrstRow,LstRow,FrstCol,LstCol: Byte);
   var i,j: Byte;
   begin
     for i:=FrstRow to LstRow do
         for j:=FrstCol to LstCol do
             if LocUpdated(i,j) then
                begin
                  FixInts(i,j);
                  if ((Typ='D')and(i>j)) or (i=j) then
                     WriteElmnt( 'CurrentV',WrkMtrx[i,j],
                                  LocfCol[j],LocfRow[i],DFBckColr,DFForColr )
                  else
                     WriteElmnt( 'CurrentV',WrkMtrx[i,j],
                                  LocfCol[j],LocfRow[i],UFBckColr,UFForColr )
                end {if LocUpdated}
             else {i.e.,if Loc NotUpdated}
                begin
                  if (Typ='D')and(i>j) then
                     WriteElmnt( 'UndScors',dumR,
                                  LocfCol[j],LocfRow[i],DFBckColr,DFForColr )
                  else
                     WriteElmnt( 'UndScors',dumR,
                                  LocfCol[j],LocfRow[i],EFBckColr,EFForColr )
                end {if Loc NotUpdated}
   end; { MtrxToSscrnMap }


  procedure MtrxBorders(Scrn: Strng6);
   { Writes matrx pos identifiers. Writes top from/to title. Scrn can
     be either 'Middle'(1-Scrn case), 'Left',or 'Right'(2-Scrn case) }
   var
     Selector: Char;

   procedure TopIdntfiers(LGap,Llimit,Rlimit: Byte);
    var i: Byte;
    begin
      for i:=Llimit to Rlimit do
          begin
            if Typ='D' then
               WriteFast(Chr(i+64),LocfCol[i]+3,TopGap,Black,LightRed)
            else begin
               if i<=9 then
                  WriteFast(Chr(i+48),LocfCol[i]+3,TopGap,Black,LightRed)
               else if i>=20 then
                  WriteFast('2'+Chr(i-20+48),LocfCol[i]+3,TopGap,Black,LightRed)
                    else
                  WriteFast('1'+Chr(i-10+48),LocfCol[i]+3,TopGap,Black,LightRed)
               end {if Typ<>'D'}
          end {for}
    end; { TopIdntfiers }

   procedure SidIdntfiers(Gap: Byte);
    var i: Byte;
    begin
      for i:=1 to ArrySiz do
          begin
            if Typ='D' then
               WriteFast(Chr(i+64),Gap,LocfRow[i],Black,LightRed)
            else begin
               if i<=9 then WriteFast(Chr(i+48),Gap,LocfRow[i],Black,LightRed)
               else if i>=20 then
                       WriteFast(Chr(i-20+48),Gap,LocfRow[i],Black,LightRed)
                    else WriteFast(Chr(i-10+48),Gap,LocfRow[i],Black,LightRed)
               end {if Typ<>'D'}
          end {for}
    end; { SidIdntfiers }

   procedure FromTo_Title(Wdth,LGap: Byte);
    const
      LTitle: Strng80 = 'Location';
      WTitle: Strng80 = 'Work-Center';
    var
      Str : Strng80;
      i,t : Byte;
    function Center(Space,Adjsmnt: Byte): Byte;
     begin
       Center:= (Space - Length(Str)) div 2 + Adjsmnt + 1
     end;
    begin { FromTo_Title }
      if Typ='D' then Str:=LTitle else Str:=WTitle;
      if TopGap>=4 then
         WriteFast(Str,Center(Wdth,LGap),TopGap-1,Black,LightGray)
    end; { FromTo_Title }

   begin { MtrxBorders }
     Selector:= Scrn[1];
     case Selector of
      'M' : begin
              FromTo_Title(BlckWdth,LeftGap);
              TopIdntfiers(LeftGap,LeftMinCol,RghtMaxCol);
              SidIdntfiers(LeftGap-1)
            end; { case of one(Mddle) scrn }
      'L' : begin
              FromTo_Title(LeftBlckWdth,LeftGap);
              TopIdntfiers(LeftGap,LeftMinCol,LeftMaxCol);
              if ArrySiz<>20 then SidIdntfiers(LeftGap-1)
            end; { case of Left scrn }
      'R' : begin
              FromTo_Title(RghtBlckWdth,RscrLeftGap);
              TopIdntfiers(RscrLeftGap,RghtMinCol,RghtMaxCol);
              if ArrySiz>=19 then SidIdntfiers(RghtBlckWdth+1)
              else SidIdntfiers(RghtBlckWdth+2)
            end; { case of Right scrn }
     end { case }
   end; { MtrxBorders }


  begin { GenratScrn }
    Selector:= Scrn[1];
    case Selector of
     'M' : begin
             Play(400,10);
             if SscrnBlank then
                begin
                  MtrxBorders('Middle');
                  MtrxToScrnMap(MinRow,MaxRow,LeftMinCol,RghtMaxCol);
                  SscrnBlank:= False
                end; {if}
           end; { case of one (Mddle) scrn }
     'L' : begin
             Play(247,10);
             if LscrnBlank then
                begin
                  CleanUp;
                  MtrxBorders('Left');
                  MtrxToScrnMap(MinRow,MaxRow,LeftMinCol,LeftMaxCol);
                  LscrnBlank:= False
                end; {if}
           end; { case of Left scrn }
     'R' : begin
             Play(182,10);
             if RscrnBlank then
                begin
                  CleanUp;
                  MtrxBorders('Right');
                  MtrxToScrnMap(MinRow,MaxRow,RghtMinCol,RghtMaxCol);
                  RscrnBlank:= False
                end; {if}
           end; { case of Right scrn }
    end; { case }
    BlackYellw
  end; { GenratScrn }



 procedure SaveMessg;
  begin
    ClrLn(25);  VertBar(1,40,25,Black,LightRed);
    WriteFast('Save matrix to disk? <Y/N(CR)>: ',2,25,Black,White);
    Play(49,100); Delay(50); Play(49,100)
  end; { SaveMessg }



 function AdjustedFilNam(FilNam: Strng24): Strng24;
  { Adjusts a file name to a max of 12 Chars. JUST for the purpose of
    showing it at the top messages }
  var
    Pos1, Pos2: Byte;
  begin
    while Length(FilNam) > 12 do
      begin
        Pos1:= Pos('\',FilNam);
        if Pos1>1 then Delete(FilNam,1,Pos1-1)
        else begin { i.e., if Pos1= 1 or 0 }
           if Pos1=1 then
              begin
                Delete(FilNam,1,1);
                Pos2:= Pos('\',FilNam);
                if Pos2<>0 then Delete(FilNam,1,Pos2)
              end;
           Delete(FilNam,13,10)
           end
      end; { while }
    AdjustedFilNam:= SetUpCase(FilNam)
  end; { AdjustedFilNam }



 procedure TopMssgs;
  { Messages corresponding to Matrix, Units, Size, and File }
  var
    Mtrx  : String[11];
    Units : String[24];
  begin
    case Typ of
     'D' : begin Mtrx:= ':Distances';  Units:= ':length-unit' end;
     'W' : begin Mtrx:= ':Work-Flows'; Units:= ':# work-units/time-unit' end;
     'C' : begin Mtrx:= ':Costs';      Units:= ':$/work-unit/length-unit' end;
    end; {case}
    ClrLn(1);  ClrLn(2);
    DivdTopLn(62,Black,LightRed);
    WriteFast('MATRIX',1,1,Black,White);
    WriteFast('UNITS',20,1,Black,White);
    WriteFast('SIZE',52,1,Black,White);
    WriteFast('FILE',64,1,Black,White);
    WriteFast(Mtrx,7,1,Black,LightGreen);
    WriteFast(Units,25,1,Black,LightGreen);
    BlackLGreen;  Gotoxy(56,1);
    Write(':',ArrySiz,'x',ArrySiz);
    WriteFast(':'+AdjustedFilNam(MtrxFilNam),68,1,Black,Yellow)
  end; { TopMssgs }



 procedure BottmMssgs;
  { Messages corresponding to Arrows, Return, Del, and Home keys }
  begin
    ClrLn(25);  ClrLn(24);
    DivdBttmLn(40,Black,LightRed);
    Draw_Enter(2,25); Draw_Arrows(21,25);
    Draw_Del(42,25);  Draw_Home(62,25);
    WriteFast('Save to disk',6,25,Black,LightCyan);
    WriteFast('Store & Move',26,25,Black,LightCyan);
    WriteFast('Clear field',46,25,Black,LightRed);
    WriteFast('Empty field',67,25,Black,LightRed)
  end; { BottmMssgs }



 procedure Messages;
  begin
    TopMssgs;
    BottmMssgs
  end;



 procedure Alarm;
  const
    WrngA= '>>> File "';  WrngB= '" Exists!! <<<';
  begin
    WriteFast(Dup(37,' '),1,24,Black,Black);  ClrEol_at(40,25);
    WriteFast(WrngA+SetUpCase(NewMtrxFilNam)+WrngB,1,24,Black,White);
    Beep; Beep; Delay(2000)
  end; { Alarm }



 procedure Get_NewMtrx_FilNam(var NewNam: Strng24; X,Y: Byte);
  const
    ValidChars: CharSet =
    ['A'..'Z','a'..'z','0'..'9','!','#'..')',
     '-','.',':','\','@','^'..'`','{','}','~'];

  procedure ERROR_Wrnng;
   const
     Wrnng= '>>> Invalid filename (or path)!! <<<';
   begin
     WriteFast(Dup(37,' '),1,24,Black,Black); ClrEol_at(40,25);
     WriteFast(Wrnng,1,24,Black,White);
     Play(247,100); Delay(20); Play(988,100);
     Delay(2000)
   end;

  procedure ShowMessg2;
   begin
     ClrEol_at(44,25);  Draw_Del(65,25);
     WriteFast('Clear field',69,25,Black,LightRed);
     WriteFast('Save with new name',44,25,Black,Yellow);
     Gotoxy(X+1,Y)
   end;

  procedure ShowMessg1;
   begin
     Draw_Enter(40,25);  ClrEol_at(44,25);
     WriteFast('"'+SetUpCase(MtrxFilNam)+'"',44,25,Black,Yellow);
     Gotoxy(X,Y)
   end;

  procedure GetStrng(var Inpstr: Strng24;
                         Inpset: CharSet; Maxlen: Integer);
   { Gets a valid input strng from keybrd allowing to end the input with a CR.
     Allows switching between two messgs as the 1st chr is keyed in or removed.
     It also allows to clear the field using the Del key }
   const
     BS  = ^H;  { Back Space }            NUL= #0;   { Null char. }
     CR  = ^M;  { Carriage Return }       Del = #83;  { Delete key }
   var
     Ch   : Char;     { Char read }       CombKey: Boolean;  { Comb'tn key }
     OKset: CharSet;  { Allowed set }

   procedure Clear;
    begin
      InpStr:= '';  CombKey:= False;
      WriteFast(Dup(MaxLen,'_'),X,Y,Black,Yellow)
    end;

   begin { GetStrng }
     Clear;
     repeat { until Ch=CR }
       CombKey:= False;
       if Length(Inpstr) < 1 then begin
          OKset:= Inpset + [CR]; ShowMessg1
          end
       else begin
          if Length(Inpstr)=1 then ShowMessg2;
          if Length(Inpstr) < Maxlen
             then OKset:= Inpset + [CR,BS,NUL]
             else OKset:= [CR,BS,NUL]
          end;
       repeat
         Ch:= ReadKey;
         if Not(Ch in OKset) then Play(900,10)
       until Ch in OKset;

       case Ch of
         BS  : begin
                 Write(Ch);
                 Write('_' + BS);
                 Delete(InpStr,Length(InpStr),1)
               end;
         NUL : begin
                 Ch:= ReadKey;
                 if Ch=Del then Clear else CombKey:= True
               end;
         else  if (Ch<>CR)and(Not CombKey) then
                  begin
                    Write(Ch);
                    InpStr:= InpStr + Ch
                  end;
       end; { case }
     until Ch=CR
   end; { GetStrng }

  procedure NewNamMessg;
   begin
     ClrLn(25);  ClrLn(24);  Play(494,60);
     WriteFast('Enter file name for this new version:',1,24,Black,White);
     VertBar(2,38,24,Black,LightRed)
   end;

  begin { Get_NewMtrx_FilNam }
    repeat
      NewNamMessg;
      GetStrng(NewNam,ValidChars,24);
      if Not ValidFileNam(NewNam) then ERROR_Wrnng
    until ValidFileNam(NewNam)
  end; { Get_NewMtrx_FilNam }

(* End of Include file FLLSCRN.INC *******************************************)
