{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

==========================================================================
}
(*****************************************************************************)
(* Beginning of Include file FLLINMTX.INC                                    *)
(* < File Reading and Validity Checking >                                    *)
(*****************************************************************************)

procedure FillIn_WorkMtrx( var WorkMtrx: Matrix;  var FilName : Strng24;
                               Prmpt   : Strng80;     PsdoRply: Char );
 { In charge of prompting for the input files, checking their validity, reading
   them in if they are valid, and filling in the corresponding matrices }

 var
   ArrySiz : Integer;



 procedure ReadIn_MtrxFile;
  var
    i,j: Byte;

  begin
    ArraySize:= ArrySiz;
    if UnitCost then
       begin
         UnitCostMtx_Mssg(Blue,Black,White);
         for i:=1 to ArrySiz do
             for j:=1 to ArrySiz do
                 WorkMtrx[i,j]:= 1.0;
         Done_Mssg(WhereX-1,25,Black,White)
       end {if UnitCost}
    else begin
       ReadMtxFile_Mssg(FilName,Blue,Black,White);
       OpenExstngFile_of_Real(MtrxFile,FilName);
       Seek(MtrxFile,1);
       for i:=1 to ArrySiz do
           for j:=1 to ArrySiz do
               Read(MtrxFile,WorkMtrx[i,j]);
       Close(MtrxFile);
       Done_Mssg(WhereX-1,25,Black,White)
       end {if Not(UnitCost)}
  end; { ReadIn_MtrxFile }



 procedure Check_Validity;
  const
    KeyBcolr= Black;  KeyFcolr= Yellow;
    Mssg = 'Restart Entering the File Names';
    WrngA= '>>> File "';

  var
    Exists,BinFile,
    Updated,RghtFile,RghtSize: Boolean;
    Rply                     : Integer;


  procedure ERROR_Mssg(MsgStr1,MsgStr2: Strng80);
   begin
     Play(247,100); Delay(20); Play(988,100);
     WriteAtCenter(' ERROR ',Red,Yellow+Blink,14);
     WriteAtCenter(MsgStr1,Black,White,15);
     WriteAtCenter(MsgStr2,Black,White,16);
     ClrLn(24); PressAnyKey('',KeyBcolr,KeyFcolr)
   end; { Error_Mssg }


  procedure Check_if_RghtSize;
   { Checks whether all files are of the same size,based on the 1st one input }
   const
     Wrnng= '>>> SIZE of File Does Not Match Previous One!! <<<';
     MsgA = '( Size ';   MsgB = ' Expected )';

   procedure Check_Size(var MtrxSize: Integer);
    var Strg: String[2];
    begin
      MtrxSize:= ArrySiz;
      if MtrxSize=DSize then RghtSize:= True
      else begin
         RghtSize:= False;
         Str(DSize:2,Strg);
         ERROR_Mssg(Wrnng,MsgA+Strg+MsgB)
      end {if/else}
    end; {Check_Size}

   begin
     case PsdoRply of
     '1': begin DSize:= ArrySiz; RghtSize:= True end;
     '2': Check_Size(WSize);
     '3': Check_Size(CSize)
     end {case}
   end; { Check_if_RghtSize }


  procedure Check_if_RghtFile;
   { Cheks whether file input by user corrsponds with file expected(prompted) }
   const
     WrngB1='" Is Not a DISTANCES File!! <<<';
     WrngB2='" Is Not a WORK-FLOW-RATES File!! <<<';
     WrngB3='" Is Not a TRANS.COSTS File!! <<<';
   begin
     if PsdoRply=Chr(Rply+48) then RghtFile:= True
     else begin
        RghtFile:= False;
        case PsdoRply of
        '1': ERROR_Mssg(WrngA+SetUpCase(FilName)+WrngB1,'');
        '2': ERROR_Mssg(WrngA+SetUpCase(FilName)+WrngB2,'');
        '3': ERROR_Mssg(WrngA+SetUpCase(FilName)+WrngB3,'')
        end {case}
     end {if/else}
   end; { Check_if_RghtFile }


  procedure Check_if_Updated(FilNam: Strng24);
   { Cheks if all components of the file have been filled }
   const
     WrngB= '" Not Updated!! <<<';
     Mssg = '( Partially Filled )';
   var
     LstCmpnt : Real;
     NoONFlags: Integer;

   procedure GetInf_from_IDkeys;
    var
      FstCmpnt, TmpR: Real;
      TmpI          : Integer;
    begin
      OpenExstngFile_of_Real(MtrxFile,FilNam);
      Read(MtrxFile,FstCmpnt);        { Read 1st compnt of file into FstCmpnt }
      Seek(MtrxFile,FileSize(MtrxFile)-1);  { Move pntr to last cmpnt of file }
      Read(MtrxFile,LstCmpnt);       { Read last compnt of file into LstCmpnt }
      Close(MtrxFile);
      {--------------}
      TmpR:= FstCmpnt;
      Rply:= Trunc(FstCmpnt);
      FstCmpnt:= TmpR*100;
      TmpI:= Round(FstCmpnt);
      ArrySiz:= TmpI - Rply*100
    end; {GetInf_from_IDkeys}

   begin { Check_if_Updated }
     GetInf_from_IDkeys;
     NoONFlags:= Round(LstCmpnt);
     if NoONFlags=Sqr(ArrySiz) then Updated:= True
     else begin
        Updated:= False;
        ERROR_Mssg(WrngA+SetUpCase(FilNam)+WrngB,Mssg)
     end {if/else}
   end; { Check_if_Updated }


  procedure Check_if_BinaryFile(FilNam: Strng24);
   { Checks whether "FilNam" is a binary file }
   const
     WrngB= '" is a Binary File!! <<<';
   begin
     BinFile:= BinaryFile(FilNam);
     if BinFile then ERROR_Mssg(WrngA+SetUpCase(FilNam)+WrngB,'')
   end; { Check_if_BinaryFile }


  procedure Check_if_Exists(FilNam: Strng24);
   { Checks whether file "FilNam" exists, warning if it doesn't }
   const
     WrngB= '" Not Found!! <<<';
   begin
     Exists:= Exist(FilNam);
     if Not(Exists) then ERROR_Mssg(WrngA+SetUpCase(FilNam)+WrngB,'')
   end; { Check_if_Exists }


  begin { Check_Validity }
    repeat
      case PsdoRply of
       '1': Play(247,10);
       '2': Play(494,10);
       '3': Play(988,10);
      end; {case}
      Get_Mtrx_FilNam( FilName,
                       28,12,Blue,Black,LightCyan,LightRed,
                       Prmpt,Mssg,PsdoRply,'FILLIN',Exit);
      if FilName<>'' then
         begin
           if (FilName='1') and (PsdoRply='3') then begin
              UnitCost:= True; Exists:= True; BinFile:= False;
              Updated:= True; RghtFile:= True; RghtSize:= True
             end {if FileName='1'}
           else begin
             Check_if_Exists(FilName);
             if Exists then
                begin
                  Check_if_BinaryFile(FilName);
                  if Not BinFile then
                     begin
                       Check_if_Updated(FilName);
                       if Updated then
                          begin
                            Check_if_RghtFile;
                            if RghtFile then
                               begin
                                 Check_if_RghtSize
                               end {if RghtFile}
                          end {if Updated}
                     end {if Not BinFile}
                end {if Exists}
             end {if FilName<>1}
         end {if FilName<>''}
      else {if FilName=''} ReStart:= True
    until (Exists and (Not BinFile) and Updated and RghtFile and RghtSize)
           or ReStart or Exit
  end; { Check_Validity }



 procedure Initialize;
  begin
    ReStart:= False;  Continue:= False;
    Exit:= False;     UnitCost:= False
  end; { Initialize }



 begin { FillIn_WorkMtrx }
   Initialize;
   Check_Validity;
   if (Not ReStart) and (Not Exit) then begin
      Continue:= True;
      ReadIn_MtrxFile
   end {if}
 end; { FillIn_WorkMtrx }

(* End of Include file FLLINMTX.INC ******************************************)
