{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

==========================================================================
}
(*****************************************************************************)
(* Beginning of Include file FLLFILE.INC                                     *)
(* < Matrix Fill-Out File Handling >                                         *)
(*****************************************************************************)

 procedure InitNewFile;
  { Opens a file, writes ID key in 1st component, and closes it }
  var
    IntPart, FracPart, Key: Real;
  begin
    case Typ of
     'D' : IntPart:= 1;
     'W' : IntPart:= 2;
     'C' : IntPart:= 3;
     else  Beep;
    end; { case }
    FracPart:= ArrySiz/100;
    Key:= IntPart + FracPart;
    OpenNewFile_of_Real(MtrxFile,MtrxFilNam);
    Write(MtrxFile,Key);
    Close(MtrxFile)
  end; { InitNewFile }


 procedure SaveFlagsFile;
  begin
    SavFlgsFile_Mssg(FlagFilNam,Blue,Black,White);
    OpenNewFile_of_Int(FlagFile,FlagFilNam);
    Write(FlagFile,NoONflags);   { Write "NoONflags" as 1st component of file }
    for dumi:=1 to ArrySiz do
        for dumj:=1 to ArrySiz do
            Write(FlagFile,FLAG[dumi,dumj]);
    Close(FlagFile);
    Done_Mssg(WhereX-1,25,Black,White)
  end; { SaveFlagsFile }


 procedure ReadInFlagsFile;
  begin
    ReadFlgsFile_Mssg(FlagFilNam,Blue,Black,White);
    OpenExstngFile_of_Int(FlagFile,FlagFilNam);
    Read(FlagFile,NoONflags);   { Read 1st component of file into "NoONflags" }
    for dumi:=1 to ArrySiz do
        for dumj:=1 to ArrySiz do
            Read(FlagFile,FLAG[dumi,dumj]);
    Close(FlagFile);
    Done_Mssg(WhereX-1,25,Black,White)
  end; { ReadInFlagsFile }


 procedure SaveMtrxFile;
  var NoONflagsR: Real;
  begin
    SavMtxFile_Mssg(MtrxFilNam,Blue,Black,White);
    NoONflagsR:= NoONflags;
    OpenExstngFile_of_Real(MtrxFile,MtrxFilNam);
    Seek(MtrxFile,1);        { move file pointer to 2nd component of the file }
    for dumi:=1 to ArrySiz do                 { (1st component is the ID key) }
        for dumj:=1 to ArrySiz do
            Write(MtrxFile,WrkMtrx[dumi,dumj]);
    Write(MtrxFile,NoONflagsR);   { save Real NoONflags as the last component }
    Close(MtrxFile);
    Done_Mssg(WhereX-1,25,Black,White)
  end; { SaveMtrxFile }


 procedure ReadInMtrxFile;
  begin
    ReadMtxFile_Mssg(MtrxFilNam,Blue,Black,White);
    OpenExstngFile_of_Real(MtrxFile,MtrxFilNam);
    Seek(MtrxFile,1);        { move file pointer to 2nd component of the file }
    for dumi:=1 to ArrySiz do                 { (1st component is the ID key) }
        for dumj:=1 to ArrySiz do
            Read(MtrxFile,WrkMtrx[dumi,dumj]);
    Close(MtrxFile);
    Done_Mssg(WhereX-1,25,Black,White)
  end; { ReadInMtrxFile }

(* End of Include file FLLFILE.INC *******************************************)
