{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6


==========================================================================
}
(*****************************************************************************)
(* Beginning of Include file FLLDATA.INC                                     *)
(* < Matrix Fill-Out Data Initialization >                                   *)
(*****************************************************************************)

 procedure CalcCommnMppingData;
  { The following parameters are used in both 1_ or 2_screen cases }
  begin
    BlckHght:= ArrySiz + (ArrySiz-1)*HorzDivWdth;
    TopGap:=(25-BlckHght) div 2 + 1;
    BottmGap:= 25 - BlckHght - TopGap;
    MinRow:= 1;     MaxRow:= ArrySiz;
    LeftMinCol:= 1; RghtMaxCol:= ArrySiz
  end; { CalcCommnMppingData }


 procedure Fillout_LocfRow_vector;
  { Initialize vector of logical to physical row mapping }
  var i: Byte;
  begin
    for i:=1 to MaxRow do
        LocfRow[i]:= TopGap + i + (i-1)*HorzDivWdth
  end; { Fillout_LocfRow_vector }


 procedure Calc1scrMppingData;
  { The following parameters are used in the 1_screen case }
  begin
    BlckWdth:= RghtMaxCol*7 + (RghtMaxCol-1)*VertDivWdth;
    LeftGap:= (80-BlckWdth) div 2
  end; { Calc1scrMppingData }


 procedure Fillout1scr_LocfCol_vector;
  { Initialize vector of logical to physical col mapping for the 1_scrn case }
  var j: Byte;
  begin
    for j:=1 to RghtMaxCol do
        LocfCol[j]:= LeftGap + 7*(j-1) + VertDivWdth*(j-1) + 1
  end; { Fillout1scr_LocfCol_vector }


 procedure Calc2scrMppingData;
  { The following parameters are used in the 2_screen case }
  function V : Integer;
   begin if ArrySiz=19 then V:=0 else V:=1 end;

  begin
    if Left_EQ_Rght
     then LeftMaxCol:= ArrySiz div 2
     else LeftMaxCol:= ArrySiz div 2 + V;
    RghtMinCol:= LeftMaxCol + 1;
    LeftBlckWdth:= LeftMaxCol*7 + (LeftMaxCol-1)*VertDivWdth;
    RghtBlckWdth:= (RghtMaxCol-LeftMaxCol)*7 +
                   (RghtMaxCol-LeftMaxCol-1)*VertDivWdth;
    LeftGap:= 79 - LeftBlckWdth;
    RscrLeftGap:= 0
  end; { Calc2scrMppingData }


 procedure Fillout2scr_LocfCol_vector;
  { Initialize vector of logical to physical col mapping for the 2_scrn case }
  var j: Byte;
  begin
    for j:=LeftMinCol to LeftMaxCol do
        LocfCol[j]:= LeftGap + (7+VertDivWdth)*(j-1) + 1;
    for j:=RghtMinCol to RghtMaxCol do
        LocfCol[j]:= (7+VertDivWdth)*(j-LeftMaxCol-1) + 1
  end; { Fillout2scr_LocfCol_vector }


 procedure InitScrnDefVals;
  { Initialize all necessary values for screen definition }
  var
    i,j: Byte;
  begin
    (* Horizontal dividers width according to array size *)
    for i:=20 downto 11 do Width[i,HorzDiv]:= 0;
    for i:=10 downto 7  do Width[i,HorzDiv]:= 1;
    for i:= 6 downto 5  do Width[i,HorzDiv]:= 2;
    Width[4,HorzDiv]:= 3;  Width[3,HorzDiv]:= 4;
    Width[2,HorzDiv]:= 7;

    (* Vertical dividers width according to array size *)
    for i:=20 downto 17 do Width[i,VertDiv]:= 1;
    for i:=16 downto 15 do Width[i,VertDiv]:= 2;
    for i:=14 downto 13 do Width[i,VertDiv]:= 3;
    for i:=12 downto 11 do Width[i,VertDiv]:= 4;
    Width[10,VertDiv]:= 6;
    for i:= 9 downto 4  do Width[i,VertDiv]:= 10-i;
    Width[3,VertDiv]:= 9; Width[2,VertDiv]:= 22;

    (* Width of dividers *)
    HorzDivWdth:= Width[ArrySiz,HorzDiv];
    VertDivWdth:= Width[ArrySiz,VertDiv];

    (* Flags *)
    SscrnBlank:= True; LscrnBlank:= True; RscrnBlank:= True;
    LeftScrnON:= True; SnglScrnInMem:= False;
    LeftScrnInMem:= False; RghtScrnInMem:= False;
    SymmElmnts:= False; Done:= False;

    (* Matrix of updated/empty_Location flags *)
    for i:=1 to ArrySiz do
      for j:=1 to ArrySiz do
        if i=j then FLAG[i,j]:=1 else FLAG[i,j]:=0;

    (* # of set flags *)
    NoONFlags:= ArrySiz;  { Main diagonal elements are diss.fields and hence }
                          { always updated. # elmnts in diagonal = Array size}

    (* "NoofScrns" counter and "Left_EQ_Rght" flag *)
    if ArrySiz > 9 then
       begin
         NoofScrns:= 2;
         if Odd(ArrySiz) then Left_EQ_Rght:= False
         else Left_EQ_Rght:= True
       end
    else { if ArrySiz<=9 }  NoofScrns:= 1;

    (* Internal file name for the flags file *)
    GenratFlagFilNam;

    (* Initial position on the scrn *)
    ROW:= 1; COL:= 2

  end; { InitScrnDefVals }

(* End of Include file FLLDATA.INC *******************************************)
