{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

==========================================================================
}
(*****************************************************************************)
(* Beginning of Unit "FileHndl"                                              *)
(* < File Handling >                                                         *)
(*****************************************************************************)

{ Common procedures and functions for file-handling }

Unit FileHndl;

Interface

Uses
  Crt,
  MainDecl,
  ColrText;


procedure OpenNewFile_of_Real(var FilVar:File_of_Real; FilNam:Strng24);

procedure OpenExstngFile_of_Real(var FilVar:File_of_Real; FilNam:Strng24);

procedure OpenNewFile_of_Int(var FilVar:File_of_Int; FilNam:Strng24);

procedure OpenExstngFile_of_Int(var FilVar:File_of_Int; FilNam:Strng24);

procedure EraseFile(FilNam: Strng24);
  { It works as long as a file exists; otherwise a I/O error occurs }

function Exist(FilNam : Strng24): Boolean;
  { Returns True if File "FilNam" exists. False otherwise }

function ValidFileNam(FilNam : Strng24): Boolean;
  { Returns True if File "FilNam" is a valid name. False otherwise }

function BinaryFile(FilNam : Strng24): Boolean;
  { Checks whether "FilNam" is a .COM,  or .EXE, or .OBJ file }

procedure GenratFlagFilNam;
  { Generate file name for the flags file. Ex.: if MtrxFilNam is, say,
    DIST.DS1, then FLagFilNam would be DIST.$DS }


{=============================================================================}

Implementation



 procedure OpenNewFile_of_Real(var FilVar:File_of_Real; FilNam:Strng24);
  begin
    Assign(FilVar,FilNam);
    Rewrite(FilVar)
  end;


 procedure OpenExstngFile_of_Real(var FilVar:File_of_Real; FilNam:Strng24);
  begin
    Assign(FilVar,FilNam);
    Reset(FilVar)
  end;


 procedure OpenNewFile_of_Int(var FilVar:File_of_Int; FilNam:Strng24);
  begin
    Assign(FilVar,FilNam);
    Rewrite(FilVar)
  end;


 procedure OpenExstngFile_of_Int(var FilVar:File_of_Int; FilNam:Strng24);
  begin
    Assign(FilVar,FilNam);
    Reset(FilVar)
  end;


 procedure EraseFile(FilNam: Strng24);
  { It works as long as a file exists; otherwise a I/O error occurs }
  var
    FilVar: file;
  begin
    Assign(FilVar,FilNam);
    Erase(FilVar)
  end; { EraseFile }


 function Exist(FilNam : Strng24): Boolean;
  { Returns True if File "FilNam" exists. False otherwise }
  var
    FilVar : file;
    Code   : Word;
  begin
    {$I-}                                { Checking for I/O errors is ceased }
    Assign(FilVar,FilNam);
    Reset(FilVar);
    Close(FilVar);
    Code:= IOresult;
    {$I+}                                           { Cheking is reactivated }
    Exist:= (Code = 0)
  end;  { Exist }


 function ValidFileNam(FilNam : Strng24): Boolean;
  { Returns True if File "FilNam" is a valid name. False otherwise }
  var
    FilVar      : file;
    Code1,Code2 : Word;
  begin
    Code1:= 0;
    if FilNam <> '' then
       if (Not Exist(FilNam)) then begin
          {$I-}                           { Checking for I/O errors is ceased }
          Assign(FilVar,FilNam);
          Rewrite(FilVar);
          Code1:= IOresult;
          Close(FilVar);
          Code2:= IOresult; { IOresult MUST be called after each possbl error }
          {$I+}                                      { Cheking is reactivated }
          if Exist(FilNam) then EraseFile(FilNam)
        end; {if Not ''}
    ValidFileNam:= (Code1 = 0)
  end;  { ValidFilNam }


 function BinaryFile(FilNam : Strng24): Boolean;
  { Checks whether "FilNam" has a typical binary file extension }
  const
   a= 'EXE'; b= 'COM'; c= 'OBJ'; d='BIN'; e= 'M_U';
  var
    DotPos: Byte;
    Ext   : String[3];
  begin
    DotPos:= Pos('.',FilNam);
    Ext:= Copy(FilNam,DotPos+1,3);
    Ext:= SetUpCase(Ext);
    BinaryFile:= ( (Ext=a)or(Ext=b)or(Ext=c)or(Ext=d)or(Ext=e) )
  end; { BinaryFile }


 procedure GenratFlagFilNam;
  { Generate file name for the flags file. Ex.: if MtrxFilNam is, say,
    DIST.DS1, then FLagFilNam would be DIST.$DS }
  var DotPos: Byte;
  begin
    FlagFilNam:= MtrxFilNam;
    DotPos:= Pos('.',FlagFilNam);
    if DotPos=0 { i.e., no dot was found }
       then Insert('.$',FlagFilNam,Length(FlagFilNam)+1)
       else Insert('$',FlagFilNam,DotPos+1)
  end; { GenratFlagFilNam }



End.

(* End of Unit "FileHndl" ****************************************************)
