{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

PASCAL V4.0

==========================================================================
}
(*****************************************************************************)
(* Beginning of Include file EXECUTE.INC                                     *)
(* < Algorithm Execution >                                                   *)
(*****************************************************************************)

procedure Execute( Display: Strng6 );

 label
   Interruption;

 var
   Iter,n,Yl,
   Xa,Ya,XaInc,
   Xs,Ys,Xs1Inc,Xs2Inc    : Byte;
   Abort, NoImprvmnt      : Boolean;
   FirstCost,  BestCost   : Real;
   FirstAsgmt, BestAsgmt  : Ivector;
   FrstWFMtrx, FrstTCMtrx : Matrix;




 procedure LastPrompts;

  const
    LASTbc= Red;     LASTfc= White;     { "LAST" mssg bck/for color }
    FRbc  = Black;   FRfc  = LightRed;  { "FINAL RESULTS" mssg bck/for color }
  begin
    WriteFast('LAST',Xs-4,Yl,LASTbc,LASTfc);
    WriteFast(' FINAL ',3,21,FRbc,FRfc+Blink);
    WriteFast(' RESULTS ',2,22,FRbc,FRfc+Blink);
    Play(247,100); Play(494,100); Play(988,100)
  end; { LastPrompts }




 procedure Show_Results(Iter    : Byte; Display: Strng6;
                        CurrCost: Real; CurrAsg: Ivector; Sound,Stop: Boolean);
  const
    CWCbc = Red;     CWCfc = White;     { Curr.Wrk-Cntr Assgmt bck/for color }
    ITRbc = Blue;    ITRfc = LightCyan; { Iteration # bck/for color }
    Sbc   = Blue;    Sfc   = Yellow;    { Stats. data bck/for color }

  var
    Yinc : Byte;


  procedure Inquire_ifContinue;
   const ESC = ^[;
         NUL = #0;
   var   Ch  : Char;

   procedure BottomLine;
    const
      Msg1 = 'Press any key for next iteration....';
      Msg2 = 'Abort Execution';
      BColr=  Blue; FColr1= Yellow; FColr2= LightGray;
    begin
      Gotoxy(1,25); Config(BColr,FColr1); ClrEol;
      Draw_Esc(60,25); WriteFast(Msg2,64,25,BColr,FColr2);
      PromptFast(Msg1,2,25,BColr,FColr1)
    end;

   begin {Inquire_ifContinue}
     BottomLine;
     Ch:= ReadKey;
     case Ch of
      NUL :  Ch:= ReadKey;
      ESC :  Abort:= True
     end; {case}
     ColoredLn(25,Black)
   end; {Inquire_ifContinue}


  procedure Map_StatData;
   var
     Gap1,Gap2,Gap3,Gap4 : Byte;         PerCent : Real;
     PerCnt              : Strng6;       Itr     : String[2];
     InitCst,CurrCst     : String[15];

   begin { Map_StatData }
     Gap1:= Xs1Inc div 2;
     Gap2:= Xs1Inc + 2;
     Gap3:= Xs1Inc + Xs2Inc + 3;
     Gap4:= Xs1Inc + 2*Xs2Inc + 5;
     PerCent:= 100.0 - (CurrCost/FirstCost)*100.0;
     Str(Iter, Itr); Str(FirstCost:Xs2Inc:1, InitCst);
     Str(CurrCost:Xs2Inc:1, CurrCst); Str(PerCent:9:2, PerCnt);
     if Iter<10 then Itr:= ' ' + Itr;
     Writefast(Itr,Xs+Gap1,Ys+Yinc+Iter,ITRbc,ITRfc);if Sound then Play(988,60);
     Writefast(InitCst,Xs+Gap2,Ys+Yinc+Iter,Sbc,Sfc);if Sound then Play(494,30);
     Writefast(CurrCst,Xs+Gap3,Ys+Yinc+Iter,Sbc,Sfc);if Sound then Play(494,30);
     Writefast(PerCnt,Xs+Gap4,Ys+Yinc+Iter,Sbc,Sfc);if Sound then Play(494,30);
     Writefast('%',WhereX+1,Ys+Yinc+Iter,Sbc,Sfc); Yl:= WhereY
   end; { Map_StatData }


  procedure Map_CurrWCAsgmt;
   var
     i,Gap,Xpos : Byte;

   function StrVal(i : Byte): Strng6;
    var Strng: Strng6;
    begin
      Str(CurrAsg[i],Strng);
      if CurrAsg[i]>9 then StrVal:= Strng
      else StrVal:= ' ' + Strng
    end;

   begin { Map_CurrWCAsgmt }
     Gap:= (XaInc+2-2) div 2 + 2*XaInc + 2;
     Xpos:= Xa + Gap;
     for i:=1 to n do begin
         WriteFast(StrVal(i),Xpos,Ya+i,CWCbc,CWCfc);
         if Sound then Play(20,15)
     end {for}
   end; { Map_CurrWCAsgmt }


  procedure Initialize;
   begin
     if n=20 then Yinc:= 2 else Yinc:= 3
   end;


  begin { Show_Results }
    Initialize;
    Map_CurrWCAsgmt;
    Map_StatData;
    if (Display='ByIter') and (Iter<>n) then
       if Stop then Inquire_ifContinue
  end; { Show_Results }




 procedure Handle_Intrruption;

  procedure Complete_Table;
   var
     i,j: Integer;
   begin
     Play(40,300);Delay(200);
     Play(40,300);Delay(200);Play(40,300);Delay(200);
     for i:=Iter+1 to n do begin
         Iter_Mssg(i,Blue,Black,White,Yellow);
         for j:=1 to (n*(n-1) div 2) do begin
             PairExchng_Mssg(j,Black,White,Yellow);
             Delay(1)
         end; {for}
         Show_Results(i,Display,BestCost,BestAsgmt,False,False);
         Done_Mssg(53,25,Black,White); Play(988,50)
     end {for}
   end; {Complete_Table}

  procedure AbortPrompt;
   const FC = LightRed;
   begin
     Play(494,100);Delay(100);
     Play(494,100);Delay(100);Play(494,100);Delay(100);
     WriteFast('EXECUTION',3,21,Black,FC+Blink);
     WriteFast('ABORTED',4,22,Black,FC+Blink)
   end; {AbortPrompt}

  begin { Handle_Intrruption }
    if Abort then AbortPrompt
    else begin
       if NoImprvmnt then Complete_Table;
       LastPrompts
    end {if/else}
  end; { Handle_Intrruption }




 procedure Eval_Cost(var Cost: Real;  Mtrx1,Mtrx2: Matrix);
  var
    i,j: Byte;
  begin
    Cost:= 0.0;
    for i:=1 to n do
        for j:=1 to n do
            Cost:= Cost + Distance[i,j]*Mtrx1[i,j]*Mtrx2[i,j]
  end; { Eval_Cost }




 procedure Exchng_MtrxElmnts(Asgmt: Ivector;  BaseMtrx: Matrix;  var A: Matrix);
  var
    i,j : Byte;
    v   : Ivector;
  begin
    v:= Asgmt;
    for i:=1 to n do
        for j:=1 to n do
            A[i,j]:= BaseMtrx[v[i],v[j]]
  end; {Exchng_MtrxElmnts}




 procedure Perfrm_Iteration(InitAsgmt: Ivector);
  var
    Cntr                : Integer;
    MinCost, TempCost   : Real;
    MinCstVct, NewAsgmt : Ivector;



  procedure Updt_GloblParams;
   begin
     BestCost:= MinCost; BestAsgmt:= MinCstVct;
     if (Display='Entire') and (MinCost=TempCost) then NoImprvmnt:= True
   end; { Updt_GloblParams }



  procedure GnratAndEval_PairExchgs;
   var
     i,j : Byte;


   procedure Eval_Asgmt;
    var
      Cost        : Real;
      Mtrx1,Mtrx2 : Matrix;

    procedure Updt_LoclMins;
     begin
       if Cost < MinCost then begin
          MinCost:= Cost;  MinCstVct:= NewAsgmt
       end {if}
     end; {Updt_LoclMins}

    begin {Eval_Asgmt}
      Exchng_MtrxElmnts(NewAsgmt,WorkFlow,Mtrx1);
      if UnitCost then Mtrx2:= TransCost
      else Exchng_MtrxElmnts(NewAsgmt,TransCost,Mtrx2);
      Eval_Cost(Cost,Mtrx1,Mtrx2);
      Show_Results(Iter,Display,Cost,NewAsgmt,False,False);
      Updt_LoclMins
    end; {Eval_Asgmt}


   procedure Gnrat_NewAsgmt;
    begin
      Cntr:= Cntr + 1;
      NewAsgmt:= InitAsgmt;
      NewAsgmt[i]:= InitAsgmt[j];
      NewAsgmt[j]:= InitAsgmt[i];
      PairExchng_Mssg(Cntr,Black,White,Yellow)
    end; {Gnrat_NewAsgmt}


   begin { GnratAndEval_PairExchgs }
     for i:=1 to n-1 do begin
         j:= i + 1;
         while j<=n do begin
           Gnrat_NewAsgmt;
           Eval_Asgmt;
           j:= j + 1
         end {while}
     end {for}
   end; { GnratAndEval_PairExchgs }



  procedure Init_LoclMins;
   begin
     Cntr:= 0;
     MinCstVct:= InitAsgmt;
     MinCost:= BestCost; TempCost:= MinCost
   end; { Init_LoclMins }



  begin { Perfrm_Iteration }
    Iter_Mssg(Iter,Blue,Black,White,Yellow);
    Init_LoclMins;
    GnratAndEval_PairExchgs;
    Updt_GloblParams;
    Done_Mssg(53,25,Black,White)
  end; { Perfrm_Iteration }




 procedure Draw_RsltsTmplate;
 {
 The following achronims for the relevant color combinations will be used:
 Bbc/Bfc  : Border backgrnd/forgrnd color; Bdrc     : Backdrop color;
 AAbc/AAfc: Asgmts Achronims bck/for colr; AMbc/AMfc: Asgmts Meanings b/c colr;
 OAbc/OAfc: Other Achronims bck/for colr;  OMbc/OMfc: Other Meanings b/f colr;
 Abc/Afc  : "ASSIGNMENTS" bck/for colr;
 AGbc/AGfc: Asgmts Grid bck/for colr;      AGbdc  : Asgmts Grid backdrop colr;
 Lbc/Lfc  : Locations bck/for colr;        SGbdc  : Stats  Grid backdrop colr;
 IWCbc/IWCfc: Init.Work-Cntrs Asgmt bck/for colr;
 SGbc/SGfc  : Statstcs Grid bck/for colr;  Hbc/Hfc: Stats Headngs bck/for colr;
 }


  const
    Bdrc = Black;     Bbc  = Black;      Bfc  = LightCyan;
    AAbc = Bdrc;      AAfc = LightCyan;  OAbc = Bdrc;      OAfc = White;
    AMbc = Bdrc;      AMfc = Green;      OMbc = Bdrc;      OMfc = Cyan;
    Abc  = Bdrc;      Afc  = LightRed;
    AGbdc= LightGray; AGbc = AGbdc;      AGfc = Yellow;
    Lbc  = AGbdc;     Lfc  = Red;        IWCbc= Blue;      IWCfc= White;
    SGbdc= Blue;      SGbc = Black;      SGfc = White;
    Hbc  = Black;     Hfc  = LightRed;   Vrt1 = #179;



  procedure StatsGrid;

   const
     UL2 : Char= #213;  UR2  : Char= #184;  LL2  : Char= #212;  LR2: Char= #190;
     Hrz2: Char= #205;  UpJct: Char= #209;  DnJct: Char= #207;
     RtJct:Char= #181;  LtJct: Char= #198;  IntJct:Char= #216;

   var
     X,Y,X1Inc,X2Inc : Byte;


   procedure Headings;
    var
      Gap1,Gap2,Gap3,Gap4 : Byte;
    begin
      Gap1:= (X1Inc+2-4) div 2 - 1;
      Gap2:= ((X2Inc+2-7) div 2) + X1Inc;
      Gap3:= ((X2Inc+2-7) div 2) + X2Inc + X1Inc + 1;
      Gap4:= ((X2Inc+2-7) div 2) + 2*X2Inc + X1Inc + 2;
      WriteFast(' Iter ',X+Gap1,Y+1,Hbc,Hfc);
      WriteFast('      ',X+Gap1,Y+2,Hbc,Hfc);
      WriteFast(' Initial ',X+Gap2,Y+1,Hbc,Hfc);
      WriteFast(' Current ',X+Gap3,Y+1,Hbc,Hfc);
      WriteFast('  Cost   ',X+Gap4,Y+1,Hbc,Hfc);
      WriteFast('  Cost   ',X+Gap2,Y+2,Hbc,Hfc);
      WriteFast('  Cost   ',X+Gap3,Y+2,Hbc,Hfc);
      WriteFast(' Reductn ',X+Gap4,Y+2,Hbc,Hfc)
    end; { Headings }


   procedure Draw_Grid(X,Y: Byte);

    var j : Byte;

    procedure VertLines(x1,x2,x3,x4,x5: Byte);
     var
       i: Byte;
     procedure WritFast(x,y: Byte);
      begin WriteFast(Vrt1,x,y,SGbc,SGfc) end;
     begin {VertLines}
       for i:=Y+1 to Y+2 do begin
           WritFast(x1,i); WritFast(x2,i);
           WritFast(x3,i); WritFast(x4,i);
           WritFast(x5,i)
       end; {for}
       for i:=Y+4 to j-1 do begin
           WritFast(x1,i); WritFast(x2,i);
           WritFast(x3,i); WritFast(x4,i);
           WritFast(x5,i)
       end; {for}
       if n=20 then begin
           WritFast(x1,Y+3); WritFast(x2,Y+3);
           WritFast(x3,Y+3); WritFast(x4,Y+3);
           WritFast(x5,Y+3)
       end; {if}
     end; {VertLines}

     procedure Corners(ch1,ch2,ch3: Char;  x: Byte);
      begin
        WriteFast(ch1,x,Y,SGbc,SGfc);
        if n<>20 then WriteFast(ch2,x,Y+3,SGbc,SGfc);
        WriteFast(ch3,x,j,SGbc,SGfc)
      end; {Corners}

     procedure Jnctns(x: Byte);
      begin
        WriteFast(UpJct,x,Y,SGbc,SGfc);
        if n<>20 then WriteFast(IntJct,x,Y+3,SGbc,SGfc);
        WriteFast(DnJct,x,j,SGbc,SGfc)
      end; {Jnctns}

     procedure HorzLines(x1,x2: Byte);
      var i: Byte;
      begin
        for i:=x1 to x2 do begin
            WriteFast(Hrz2,i,Y,SGbc,SGfc);
            if n<>20 then WriteFast(Hrz2,i,Y+3,SGbc,SGfc);
            WriteFast(Hrz2,i,j,SGbc,SGfc)
        end {for}
      end; {HorzLines}

    begin { Draw_Grid }
      if n=20 then j:=Y+n+3 else j:=Y+n+4;
      ColoredWindow(SGbdc,Y+1,j-1,X+1,X+X1Inc+3*X2Inc+3); DfltWndw;
      HorzLines(X+1, X+X1Inc); HorzLines(X+X1Inc+2, X+X1Inc+X2Inc+1);
      HorzLines(X+X1Inc+X2Inc+3, X+X1Inc+2*X2Inc+2);
      HorzLines(X+X1Inc+2*X2Inc+4, X+X1Inc+3*X2Inc+3);
      Jnctns(X+X1Inc+1);  Jnctns(X+X1Inc+X2Inc+2);  Jnctns(X+X1Inc+2*X2Inc+3);
      Corners(UL2,LtJct,LL2,X);  Corners(UR2,RtJct,LR2,X+X1Inc+3*X2Inc+4);
      VertLines(X,X+X1Inc+1,X+X1Inc+X2Inc+2,X+X1Inc+2*X2Inc+3,X+X1Inc+3*X2Inc+4)
    end; { Draw_Grid }


   procedure Initialize;
    begin
      X:= 41;  X1Inc:= 6;  X2Inc:= 9;
      Xs:= X;  Xs1Inc:= X1Inc;  Xs2Inc:= X2Inc;
      if (n=20) or (n=19) then Y:=1 else Y:= Round((24-n-5) / 2);
      Ys:= Y
    end; { Initialize }


   begin { StatsGrid }
     Initialize;
     Draw_Grid(X,Y);
     Headings
   end; { StatsGrid }



  procedure AsgmtsGrid;

   const
     UL1 : Char= #218;  UR1  : Char= #191;  LL1  : Char= #192;  LR1: Char= #217;
     Hrz1: Char= #196;  UpJct: Char= #194;  DnJct: Char= #193;

   var
     X,Y,XInc : Byte;


   procedure Map_InitWC_Asgmt;
    var
      i,Gap,Xpos : Byte;

    function StrVal(i: Byte): Strng6;
     var Strng: Strng6;
     begin
       Str(FirstAsgmt[i],Strng);
       if FirstAsgmt[i]>9 then StrVal:= Strng
       else StrVal:= ' ' + Strng
     end; {StrVal}

    begin { Map_InitWC_Asgmt }
      Gap:= (XInc+2-2) div 2 + XInc + 1;
      Xpos:= X + Gap;
      for i:=1 to n do begin
          WriteFast(StrVal(i),Xpos,Y+i,IWCbc,IWCfc);
          Play(123,25); Play(494,25)
      end {for}
    end; { Map_InitWC_Asgmt }


   procedure Map_Locations;
    var
      i,Gap,Xpos : Byte;
    begin
      Gap:= (XInc+2-1) div 2;
      Xpos:= X + Gap;
      for i:=1 to n do WriteFast(Chr(i+64),Xpos,Y+i,Lbc,Lfc)
    end; { Map_Locations }


   procedure Draw_Grid(X,Y: Byte);

    procedure VertLines(x1,x2,x3,x4: Byte);
     var i: Byte;
     begin
       for i:=Y+1 to Y+n do begin
           WriteFast(Vrt1,x1,i,AGbc,AGfc);
           WriteFast(Vrt1,x2,i,AGbc,AGfc);
           WriteFast(Vrt1,x3,i,AGbc,AGfc);
           WriteFast(Vrt1,x4,i,AGbc,AGfc)
       end {for}
     end; {VertLines}

    procedure Corners(ch1,ch2: Char;  x: Byte);
     begin
       WriteFast(ch1,x,Y,AGbc,AGfc);
       WriteFast(ch2,x,Y+n+1,AGbc,AGfc)
     end; {Corners}

    procedure Jnctns(x: Byte);
     begin
       WriteFast(UpJct,x,Y,AGbc,AGfc);
       WriteFast(DnJct,x,Y+n+1,AGbc,AGfc)
     end; {Jnctns}

    procedure HorzLines(x1,x2: Byte);
     var i: Byte;
     begin
       for i:=x1 to x2 do begin
           WriteFast(Hrz1,i,Y,AGbc,AGfc);
           WriteFast(Hrz1,i,Y+n+1,AGbc,AGfc)
       end {for}
     end; {HorzLines}

    begin { Draw_Grid }
      ColoredWindow(AGbdc,Y+1,Y+n,X+1,X+3*XInc+2);
      DfltWndw;  HorzLines(X+1,X+XInc);
      HorzLines(X+XInc+2,X+2*XInc+1);
      HorzLines(X+2*XInc+3,X+3*XInc+2);
      Jnctns(X+XInc+1); Jnctns(X+2*XInc+2);
      Corners(UL1,LL1,X); Corners(UR1,LR1,X+3*XInc+3);
      VertLines(X,X+XInc+1,X+2*XInc+2,X+3*XInc+3)
    end; { Draw_Grid }


   procedure LocWC_Symbls(y: Byte);
    { Draws the symbols "Loc" & "WC" below the assignments grid }
    var
      LocGap,WC1Gap,WC2Gap: Byte;
    begin
      LocGap:= (XInc-1) div 2;
      WC1Gap:= (XInc div 2) + XInc + 1;
      WC2Gap:= (XInc div 2) + 2*XInc + 2;
      WriteFast('Loc',X+LocGap,y,OAbc,OAfc);
      WriteFast('WC',X+WC1Gap,y,OAbc,OAfc);
      WriteFast('WC',X+WC2Gap,y,OAbc,OAfc)
    end; { LocWC_Symbls }


   procedure IACA_Symbls(y: Byte);
    { Draws the symbols "Loc" & "WC" below the assignments grid }
    var
      IAGap,CAGap: Byte;
    begin
      IAGap:= (XInc div 2) + XInc + 1;
      CAGap:= (XInc div 2) + 2*XInc + 2;
      WriteFast('IA',X+IAGap,y,AAbc,AAfc);
      WriteFast('CA',X+CAGap,y,AAbc,AAfc)
    end; { IACA_Symbls }


   procedure ASGMTS_Heading(y: Byte);
    var
      Gap: Byte;
    begin
      Gap:= Round( (3*XInc + 4 - 11) / 2 );
      WriteFast(' ASSIGNMENTS ',X+Gap,y,Abc,Afc)
    end; { ASGMTS_Heading }


   procedure Initialize;
    begin
      X:= 16;  XInc:= 4;
      Xa:= X;  XaInc:= XInc;
      Y:= Round( (24-n) / 2 );
      if (Not Odd(n)) and (n<17) then Y:= Y+1;
      Ya:= Y
    end; {Initialize}


   begin { AsgmtsGrid }
     Initialize;
     case n of
      20  : begin {null} end;
      19  : IACA_Symbls(Y-1);
      18  : begin
              IACA_Symbls(Y-1); LocWC_Symbls(Y+n+2)
            end;
      else  begin
              ASGMTS_Heading(Y-2);
              IACA_Symbls(Y-1);
              LocWC_Symbls(Y+n+2)
            end
     end; {case}
     Draw_Grid(X,Y);
     Map_Locations;
     Map_InitWC_Asgmt
   end; { AsgmtsGrid }



  procedure Legend;
   const
     X: Byte= 3;   Y: Byte= 7;   Step: Byte= 3;

   procedure Idntifcation;
    const MsgA= 'M.A.C.R.A.F.T.';  MsgB= 'v 1.0';
    var   Z: Byte;
    begin
      case n of
       3..14 : WriteAtCenter(MsgA+', '+MsgB,Bdrc,Yellow,2);
       15..16: WriteFast(MsgA+', '+MsgB,3,2,Bdrc,Yellow);
       else    begin
                 if n in [17..19] then Z:= 3 else Z:= 2;
                 WriteFast(MsgA,Z,2,Bdrc,Yellow);
                 WriteFast(MsgB,6,3,Bdrc,Yellow)
               end
      end {case}
    end; {Idntifcation}

   begin { Legend }
     Idntifcation;
     if n < 20 then begin
        WriteFast('IA',X,Y,AAbc,AAfc);
        WriteFast('CA',X,Y+Step,AAbc,AAfc);
        WriteFast(':Initial',X+3,Y,AMbc,AMfc);
        WriteFast('Assgmnt',X+4,Y+1,AMbc,AMfc);
        WriteFast(':Current',X+3,Y+Step,AMbc,AMfc);
        WriteFast('Assgmnt' ,X+4,Y+Step+1,AMbc,AMfc);
        if n < 19 then begin
           WriteFast('Loc',X,Y+2*Step,OAbc,OAfc);
           WriteFast('WC' ,X,Y+3*Step-1,OAbc,OAfc);
           WriteFast(':Location',X+3,Y+2*Step,OMbc,OMfc);
           WriteFast(':Work-',X+3,Y+3*Step-1,OMbc,OMfc);
           WriteFast('Center',X+4,Y+3*Step,OMbc,OMfc)
        end {if n<19}
     end {if n<20}
   end; { Legend }



  procedure Border;
   begin
     ClrScr;
     WindowBox(Bbc,Bfc,1,24,1,80,'Double');
     ColoredWindow(Bdrc,2,23,2,79); DfltWndw
   end; { Border }



  begin { Draw_RsltsTmplate }
    Border;
    Legend;
    AsgmtsGrid;
    StatsGrid;
    PressAnyKey('to START',Blue,Yellow)
  end; { Draw_RsltsTmplate }




 procedure Init_GloblParams;
  var
    i: Byte;

  procedure Assgn_AtRandm;
   var i,r  : Byte;
       OKset: set of 1..MaxArraySize;
   begin
     Okset:= [];
     Randomize;
     for i:=1 to n do begin
         repeat
           r:= Random(n+1)
         until (r>0) and Not(r in OKset);
         FirstAsgmt[i]:= r;
         OKset:= OKset + [r]
     end {for}
   end; {Assgn_AtRandm}

  begin { Init_GloblParams }
    Randomize_Mssg(Blue,Black,Yellow);
    n:= ArraySize;
    Abort:= False; NoImprvmnt:= False;
    if RndmAsg then begin
       Assgn_AtRandm;
       Exchng_MtrxElmnts(FirstAsgmt,WorkFlow,FrstWFMtrx);
       if UnitCost then FrstTCMtrx:= TransCost
       else Exchng_MtrxElmnts(FirstAsgmt,TransCost,FrstTCMtrx)
      end {if RndmAsg}
    else begin
       for i:=1 to n do FirstAsgmt[i]:= i;
       FrstWFMtrx:= WorkFlow;
       FrstTCMtrx:= TransCost
      end; {if Not RndmAsg}
    Eval_Cost(FirstCost,FrstWFMtrx,FrstTCMtrx);
    BestCost:= FirstCost;
    BestAsgmt:= FirstAsgmt;
    BeginExec_Mssg(Blue,Black,White)
  end; { Init_GloblParams }




 begin { Execute }
   Init_GloblParams;
   Draw_RsltsTmplate;
   for Iter:= 1 to n do begin
       Perfrm_Iteration(BestAsgmt);
       Show_Results(Iter,Display,BestCost,BestAsgmt,True,True);
       if Abort or NoImprvmnt then GOTO Interruption
   end; {for}
   Interruption:
   Handle_Intrruption
 end; { Execute }

(* End of Include file EXECUTE.INC *******************************************)
