{

* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

PASCAL V4.0

==========================================================================
}
(*****************************************************************************)
(* Beginning of Include file ERRHNDLR.INC                                    *)
(* < Runtime Error Handler >                                                 *)
(*****************************************************************************)
{Taken from article by Tom Swan published in "TURBO TECHNIX" March/April 1988}


{$F+} procedure CustomExit; {$F-}
{ Error handler and custom exit for runtime errors }

 const
   MsgA = ' HALTING  M.A.C.R.A.F.T. ';
   MsgB = 'M.A.C.R.A.F.T.  halted';
   Ln1  = 'A small problem has developed.';
   Ln2  = 'M.A.C.R.A.F.T. must be halted.';
   Ln3  = ' Please write down the following information';
   Ln4  = 'and call the programmer at (315)471-1387.';
   Ln5  = 'Your support is very much appreciated!';
   TxT  =  White;  Lines = LightCyan;  Codes = LightRed;  Numbrs = Yellow;

 begin { CustomExit }
   TextAttr:= Black*16 + Numbrs;
   if ErrorAddr <> NIL then
      begin
        Play(494,200);Delay(200);
        Play(494,200);Delay(200);
        Play(494,200);Delay(200);
        ClrScr;
        WriteAtCenter(Dup(60,'-'),Black,Lines,1);
        WriteAtCenter(MsgA,Red,White+Blink,3);
        WriteAtCenter(Ln1,Black,TxT,5);
        WriteAtCenter(Ln2,Black,TxT,6);
        WriteAtCenter(Ln3,Black,TxT,8);
        WriteAtCenter(Ln4,Black,TxT,9);
        PromptFast('Address =  ',32,11,Black,Codes);
        Write(Seg(ErrorAddr^),':',Ofs(ErrorAddr^));
        PromptFast('Code    =  ',32,12,Black,Codes);
        Write(ExitCode);
        WriteAtCenter(Ln5,Black,TxT,14);
        WriteAtCenter(Dup(60,'-'),Black,Lines,16);
        Gotoxy(1,20); Delay(2000); Play(243,40); Writeln(MsgB);

        ErrorAddr:= NIL;       { Cancel runtime error }
        ExitCode:= 0
      end; { if }

   ExitProc:= SavedExitProc    { Restore saved ExitProc pointer }
 end; { CustomExit }



procedure Init_ErrorHndlr;
 begin
   BlackYellw; ClrScr;
   SavedExitProc:= ExitProc;   { Save ExitProc pointer }
   ExitProc:= @CustomExit      { Install custom error procedure }
 end; { Init_ErrorHndlr }

(* End of Include file ERRHNDLR.INC ******************************************)
