{
* DESCRIPTION
File used with MACRAFT.PAS.

* ASSOCIATED FILES
MACRAFT.PAS
COLRTEXT.PAS
DIST.11
DIST.15
DIST.17
DIST.20
DIST.3
DIST.4
DIST.5
DIST.6
ERRHNDLR.INC
EXECUTE.INC
FCHNXTMV.INC
FILEHNDL.PAS
FLLDATA.INC
FLLFIELD.INC
FLLFILE.INC
FLLINMTX.INC
FLLOUTMX.BDY
FLLOUTMX.DEC
FLLSCRN.INC
GETDTVAL.INC
GTFILNAM.PAS
INTRMENU.PAS
MACRAFT.EXE
MAINDECL.PAS
MESSAGES.PAS
PRCSSFIL.INC
TCOST.11
TCOST.15
TCOST.17
TCOST.20
TCOST.3
TCOST.4
TCOST.5
TCOST.6
UPDATFIL.INC
WFLOW.11
WFLOW.15
WFLOW.17
WFLOW.20
WFLOW.3
WFLOW.4
WFLOW.5
WFLOW.6

TURBO PASCAL V4.0

==========================================================================
}
(*****************************************************************************)
(* Beginning of Unit "ColrText"                                              *)
(* < Screen Handling >                                                       *)
(*****************************************************************************)

{ Library of several useful screen/sound-related procedures and functions }

Unit ColrText;

Interface

Uses
  Crt,
  MainDecl;


procedure Beep;

procedure Pause;

procedure Play(Hrtz, msec : Integer);

function SetUpCase(Str: Strng80): Strng80;

function Dup(NoofTimes: Integer; Symbol: Char) : Strng80;
 { Creates a string containing "NoofTimes" copies of "Symbol" }

function Yes : Boolean;
 { This function is in charge of assuring that answer is only Y or N,
   after CR is pressed }

function Yess : Boolean;
 { This function is in charge of assuring that answer is only Y or N,
   reading Ch from keyboard. Also, CR is a substitute for NO. Pressing "Enter"
   is not necessary }

procedure Config(BackGrndColr, ForeGrndColr : Integer);

procedure InvVideo;

procedure BlackWhite;

procedure BlackYellw;

procedure BlackLRed;

procedure BlackLGreen;

procedure BlackLCyan;

procedure BlackLGray;

procedure GetNum(PrptLen: Integer;  var i: Integer;  var r: Real;  Typ: Char);
 { Gets a correct int. or real # depending upon "Typ". If in error, it will
   indicate its position }

procedure WriteFast(Mssg: Strng80; Col,Row,BckColr,ForColr: Byte);
 { Memory-maps string "Mssg" directly into the graphics buffer area }

procedure PromptFast(Mssg: Strng80;
                     Xpos,Ypos,BckGrndColr,ForGrndColr: Byte);
{ Write a message at absolute coord. Xpos,Ypos with the back-ground and fore-
  ground colors received, using "WriteFast" }

procedure WriteAtCenter(Strng: Strng80;
                        BckGrndColr,ForGrndColr,Ypos: Byte );
 { Considering the default window (whole screen), locate the passed string
   in the middle of the screen (X-wise) at the received Y position, using
   the background and foreground colors received }

procedure WriteAtMiddle(Strng: Strng80;
                        BckColr,ForColr,LwrLimt: Byte);
 { With the help of "WriteAtCenter", writes 'Strng' at the middle of the scrn,
   considering "LwrLimt" as the last line }

procedure WriteAtHalfY(Strng: Strng80;
                       BckColr,ForColr,Xpos,LwrLimt: Byte);
 { Locate strng at the received "Xpos" and at half of the screen (Y-wise)
   considering "LwrLimt" as the last line }

procedure ColoredLn(LnNo,Colr: Byte);

procedure PressAnyKey(Str: Strng24; BckColr,ForColr: Byte);

procedure DfltWndw;

procedure ColoredWindow(Color,Top,Bttm,Left,Rght: Byte);

procedure CentrColrdWndw(Colr,Wdth,Hght,LwrLimt: Byte);

procedure WindowBox(BckColr,ForColr,Top,Bttm,Left,Rght: Byte;
                    BoxStyle: Strng6);
 { Draw either a single-line box or a double-line box with the colors spe-
   cified by BckColr/ForColr and with the dimensions spec.by Top,.,.,Right,
   mapping directly into graphics buffer }

procedure CentrWndwBox(BckColr,ForColr,BlckWdth,BlckHght,LwrLimt: Integer;
                       BoxTyp: Strng6);
 { Draws a box in the middle of the screen with the help of "WindowBox" }

procedure Paint(BckColr,WdwColr,DLnColr,SLnColr,
                BlckWdth,BlckHght,WdwWdth,WdwHght,LwrLimt: Byte);
 { Creates a double line box surrounding the whole scrn and a single line box
   surrounding an inner window. It centers these boxes according to the Lower
   Limit received }

procedure ClrLn(LnNo: Byte);

procedure ClrEol_at(X,Y: Byte);

procedure Draw_Enter(X,Y: Byte);
 { Draws the "Enter" arrow-symbol at coord. X,Y in inv-video }

procedure Draw_Arrows(X,Y: Byte);
 { Draws the "Arrow-Keys" symbol at coord. X,Y in inv-video }

procedure Draw_Del(X,Y: Byte);
 { Draws "Del" at coord. X,Y in inv-video }

procedure Draw_Home(X,Y: Byte);
 { Draws "Home" at coord. X,Y in inv-video }

procedure Draw_Esc(X,Y: Byte);
 { Draws "Esc" at coord. X,Y in inv-video }

procedure VertBar(Times,X,Y,BckColr,ForColr: Byte);
 { Draws a vertical bar from pos.(X,Y) downwards "Times" number of times }

procedure DivdTopLn(DividerCol,BckColr,ForColr: Byte);
 { Draws a full-scrn horz. line at Row#2, placing an upward length-2 vert
   divider at pos "DividerCol" }

procedure DivdBttmLn(DividerCol,BckColr,ForColr: Byte);
 { Draws a full-scrn horz. line at Row#24, placing a downward length-2 vert
   divider at pos "DividerCol" }


{=============================================================================}

Implementation


procedure Beep;
 begin
   Write(#7)
 end;


procedure Pause;
 const
   A_key: CharSet = [#8,#13,#32..#127];
 var
   C    : Char;
 begin
   repeat
     C:= ReadKey
   until C in A_key
 end; { Pause }


procedure Play(Hrtz, msec : Integer);
 begin
   Sound(Hrtz); Delay(msec);
   NoSound
 end; { Play }


function SetUpCase(Str: Strng80): Strng80;
 var i: Byte;
 begin
   for i:=1 to Length(Str) do
       Str[i]:= UpCase(Str[i]);
   SetUpCase:= Str
 end; { SetUpCase }


function Dup(NoofTimes: Integer; Symbol: Char) : Strng80;
 { Creates a string containing "NoofTimes" copies of "Symbol" }
 var
   Temp : Strng80;
   i    : Byte;
 begin
   Temp:= '';
   for i:= 1 to NoofTimes do
     Temp:= Temp + Symbol;
   Dup:= Temp
 end; { Dup }


function Yes : Boolean;
 { This function is in charge of assuring that answer is only Y or N,
   after "Enter" is pressed }
 const
   CR = ^M;  { Carriage Return }
   BS = ^H;  { Back Space }
 var
   x,y: Byte;  Ch1,Ch2: Char;
 begin
   x:= WhereX; y:= WhereY;                         { Save cursor coordinates }
   repeat
     Gotoxy(x,y); Write(' ' + BS);
     Ch1:= ReadKey; Write(Ch1);
     Gotoxy(x+1,y); Ch2:= ReadKey
   until (UpCase(Ch1) in ['Y','N']) and (Ch2=CR);
   Yes:= (Ch1 in ['Y','y'])
 end; { Yes }


function Yess : Boolean;
 { This function is in charge of assuring that answer is only Y or N,
   reading Ch from keyboard. Also, CR is a substitute for NO. Pressing "Enter"
   is not necessary }
 const
   CR = ^M;  { Carriage Return }
   BS = ^H;  { Back Space }
 var
   x,y: Byte;   Ch: Char;
 begin
   x:= WhereX;  y:= WhereY;
   repeat
     Gotoxy(x,y);
     Write(' ' + BS);
     Ch:= ReadKey;
     if Ch in ['Y','y'] then Write('Y');
     if Ch in ['N','n',CR] then Write('N');
     if Not(Ch in ['Y','y','N','n',CR]) then Play(900,10)
   until Ch in ['Y','y','N','n',CR];
   Yess:= (Ch in ['Y','y']);
   Delay(50)
 end; { Yess }


procedure Config(BackGrndColr, ForeGrndColr : Integer);
 begin
   TextBackground(BackGrndColr);
   TextColor(ForeGrndColr)
 end;  { Config }


procedure InvVideo;
 begin Config(LightGray,Black) end;


procedure BlackWhite;
 begin Config(Black,White) end;


procedure BlackYellw;
 begin Config(Black,Yellow) end;


procedure BlackLRed;
 begin Config(Black,LightRed) end;


procedure BlackLGreen;
 begin Config(Black,LightGreen) end;


procedure BlackLCyan;
 begin Config(Black,LightCyan) end;


procedure BlackLGray;
 begin Config(Black,LightGray) end;



procedure GetNum(PrptLen: Integer;  var i: Integer;  var r: Real;  Typ: Char);
 { Gets a correct int. or real # depending upon "Typ". If in error, it will
   indicate its position }
 var
   ErrPos : Integer;
   Str    : Strng80;

 begin
   repeat
     i:= 0; r:= 0.0;
     Readln(Str);
     case Typ of
      'I' :   Val(Str,i,ErrPos);
      'R' :   Val(Str,r,ErrPos)
     end; {case}
     if ErrPos <> 0 then begin
        BlackWhite; Beep;
        Writeln('^':PrptLen+ErrPos, '-- Entry Error!');
        BlackYellw
     end {if}
   until ErrPos=0
 end; { GetNum }



procedure WriteFast(Mssg: Strng80; Col,Row,BckColr,ForColr: Byte);
 { Memory-maps string "Mssg" directly into the graphics buffer area }
 const
   GBuffLoc : Word = $B800;
 var
   CharOffSet,AttrOffSet,ColrComb : Word;
   Pntr                           : Byte;

 begin { WriteFast }
   ColrComb:= BckColr*16 + ForColr;
   CharOffSet:= (Row-1)*160 + (Col-1)*2;
   AttrOffSet:= CharOffSet + 1;
   for Pntr:=1 to Length(Mssg) do begin
       Mem[GBuffLoc:CharOffSet + Pntr + Pntr - 2]:= Ord(Mssg[Pntr]);
       Mem[GBuffLoc:AttrOffSet + Pntr + Pntr - 2]:= ColrComb
       end;
   Gotoxy(Col+Length(Mssg)-1,Row)
 end; { WriteFast }


procedure PromptFast(Mssg: Strng80;
                     Xpos,Ypos,BckGrndColr,ForGrndColr: Byte);
{ Write a message at absolute coord. Xpos,Ypos with the back-ground and fore-
  ground colors received, using "WriteFast" }
 begin
   WriteFast(Mssg,Xpos,Ypos,BckGrndColr,ForGrndColr);
   Gotoxy(WhereX+1,WhereY)
 end; { Prompt }


procedure WriteAtCenter(Strng: Strng80;
                        BckGrndColr,ForGrndColr,Ypos: Byte );
 { Considering the default window (whole screen), locate the passed string
   in the middle of the screen (X-wise) at the received Y position, using
   the background and foreground colors received }
 var
   Xpos : Byte;
 begin
   Xpos:= (80-Length(Strng)) div 2 + 1;
   PromptFast(Strng,Xpos,Ypos,BckGrndColr,ForGrndColr)
 end;  { WriteAtCenter }


procedure WriteAtMiddle(Strng: Strng80;
                        BckColr,ForColr,LwrLimt: Byte);
 { With the help of "WriteAtCenter", writes 'Strng' at the middle of the scrn,
   considering "LwrLimt" as the last line }
 var
   Ypos: Byte;
 begin
   Ypos:= LwrLimt div 2;
   WriteAtCenter(Strng,BckColr,ForColr,Ypos)
 end; { WriteAtMiddle }


procedure WriteAtHalfY(Strng: Strng80;
                       BckColr,ForColr,Xpos,LwrLimt: Byte);
 { Locate strng at the received "Xpos" and at half of the screen (Y-wise)
   considering "LwrLimt" as the last line }
 var
   Ypos: Byte;
 begin
   Ypos:= LwrLimt div 2;
   PromptFast(Strng,Xpos,Ypos,BckColr,ForColr)
 end; { WriteAtHalfY }


procedure ColoredLn(LnNo,Colr: Byte);
 { This procedure combined with "PromptFast" will make dissapear the cursor }
 begin
   Config(Colr,Colr);
   Gotoxy(1,LnNo); ClrEol;
   BlackLGray
 end; { ColoredLn }


procedure PressAnyKey(Str: Strng24; BckColr,ForColr: Byte);
 begin
   Config(BckColr,ForColr); Gotoxy(1,25); ClrEol;
   PromptFast('Press any key ' + Str + '....',2,25,BckColr,ForColr);
   Pause; ColoredLn(25,Black)
 end; { PressAnyKey }


procedure DfltWndw;
 begin
   Window(1,1,80,25);
   Gotoxy(1,1)
 end; { DfltWndw }


procedure ColoredWindow(Color,Top,Bttm,Left,Rght: Byte);
 begin
   DfltWndw;
   TextBackground(Color);
   Window(Left,Top,Rght,Bttm);
   ClrScr
 end; { ColoredWindow }


procedure CentrColrdWndw(Colr,Wdth,Hght,LwrLimt: Byte);
 var
   Top,Bttm,Left,Rght: Byte;
 begin
   Top:= (LwrLimt-Hght) div 2 + 1;
   Bttm:= Top + Hght - 1;
   Left:= (80-Wdth) div 2 + 1;
   Rght:= Left + Wdth - 1;
   ColoredWindow(Colr,Top,Bttm,Left,Rght)
 end; { CentrColrdWndw }



procedure WindowBox(BckColr,ForColr,Top,Bttm,Left,Rght: Byte;
                    BoxStyle: Strng6);
 { Draw either a single-line box or a double-line box with the colors spe-
   cified by BckColr/ForColr and with the dimensions spec.by Top,.,.,Right,
   mapping directly into graphics buffer }
 const
   ULchar1: Char= #218;     ULchar2: Char= #201;
   URchar1: Char= #191;     URchar2: Char= #187;
   LLchar1: Char= #192;     LLchar2: Char= #200;
   LRchar1: Char= #217;     LRchar2: Char= #188;
   HrzChr1: Char= #196;     HrzChr2: Char= #205;
   VrtChr1: Char= #179;     VrtChr2: Char= #186;
 var
   Selector: Char;

 procedure DrawBox(ULcrnr,URcrnr,LLcrnr,LRcrnr,HrzChr,VrtChr: Char);
  var
    Y : Byte;
  begin
    WriteFast(Dup(Rght-Left-1,HrzChr),Left+1,Top, BckColr,ForColr);
    WriteFast(Dup(Rght-Left-1,HrzChr),Left+1,Bttm,BckColr,ForColr);
    for Y:=Top+1 to Bttm-1 do begin
        WriteFast(VrtChr,Left,Y,BckColr,ForColr);
        WriteFast(VrtChr,Rght,Y,BckColr,ForColr)
        end; {for}
    WriteFast(ULcrnr,Left,Top, BckColr,ForColr);
    WriteFast(URcrnr,Rght,Top, BckColr,ForColr);
    WriteFast(LLcrnr,Left,Bttm,BckColr,ForColr);
    WriteFast(LRcrnr,Rght,Bttm,BckColr,ForColr);
  end; { DrawBox }

 begin { WindowBox }
   DfltWndw;
   Selector:= BoxStyle[1];
   case Selector of
    'S' : DrawBox(ULchar1,URchar1,LLchar1,LRchar1,HrzChr1,VrtChr1); {1line-box}
    'D' : DrawBox(ULchar2,URchar2,LLchar2,LRchar2,HrzChr2,VrtChr2); {2line-box}
   end { case }
 end; { WindowBox }



procedure CentrWndwBox(BckColr,ForColr,BlckWdth,BlckHght,LwrLimt: Integer;
                       BoxTyp: Strng6);
 { Draws a box in the middle of the screen with the help of "WindowBox" }
 var
   Top,Bttm,Left,Rght: Integer;
 begin
   Top:= (LwrLimt-BlckHght) div 2;
   Bttm:= Top + BlckHght + 1;
   Left:= (80-BlckWdth) div 2;
   Rght:= Left + BlckWdth + 1;
   WindowBox(BckColr,ForColr,Top,Bttm,Left,Rght,BoxTyp)
 end; { CentrWndwBox }



procedure Paint(BckColr,WdwColr,DLnColr,SLnColr,
                BlckWdth,BlckHght,WdwWdth,WdwHght,LwrLimt: Byte);
 { Creates a double line box surrounding the whole scrn and a single line box
   surrounding an inner window. It centers these boxes according to the Lower
   Limit received }
 begin
   CentrWndwBox(BckColr,DLnColr,BlckWdth,BlckHght,LwrLimt,'Double');
   CentrColrdWndw(BckColr,BlckWdth,BlckHght,LwrLimt);
   CentrWndwBox(BckColr,SLnColr,WdwWdth,WdwHght,LwrLimt,'Single');
   CentrColrdWndw(WdwColr,WdwWdth-2,WdwHght,LwrLimt);
   DfltWndw
 end; { Paint }



procedure ClrLn(LnNo: Byte);
 begin
   BlackYellw;
   Gotoxy(1,LnNo); ClrEol
 end;


procedure ClrEol_at(X,Y: Byte);
 begin
   BlackYellw;
   Gotoxy(X,Y); ClrEol
 end;


procedure Draw_Enter(X,Y: Byte);
 { Draws the "Enter" arrow-symbol at coord. X,Y in inv-video }
 begin
   WriteFast(#17#196#217,X,Y,LightGray,Black)
 end;


procedure Draw_Arrows(X,Y: Byte);
 { Draws the "Arrow-Keys" symbol at coord. X,Y in inv-video }
 begin
   WriteFast(#27#24#25#26,X,Y,LightGray,Black)
 end;


procedure Draw_Del(X,Y: Byte);
 { Draws "Del" at coord. X,Y in inv-video }
 begin
   WriteFast('Del',X,Y,LightGray,Black)
 end;


procedure Draw_Home(X,Y: Byte);
 { Draws "Home" at coord. X,Y in inv-video }
 begin
   WriteFast('Home',X,Y,LightGray,Black)
 end;


procedure Draw_Esc(X,Y: Byte);
 { Draws "Esc" at coord. X,Y in inv-video }
 begin
   WriteFast('Esc',X,Y,LightGray,Black)
 end;


procedure VertBar(Times,X,Y,BckColr,ForColr: Byte);
 { Draws a vertical bar from pos.(X,Y) downwards "Times" number of times }
 var
   i,Ypos: Byte;
 begin
   Ypos:= Y - 1;
   for i:=1 to Times do
       WriteFast(#179,X,Ypos+i,BckColr,ForColr)
 end; { VertBar }


procedure DivdTopLn(DividerCol,BckColr,ForColr: Byte);
 { Draws a full-scrn horz. line at Row#2, placing an upward length-2 vert
   divider at pos "DividerCol" }
 begin
   WriteFast(Dup(DividerCol-1,#196),1,2,BckColr,ForColr);
   WriteFast(#193,DividerCol,2,BckColr,ForColr);
   WriteFast(Dup(80-DividerCol,#196),DividerCol+1,2,BckColr,ForColr);
   WriteFast(#179,DividerCol,1,BckColr,ForColr);
 end; { DivdTopLn }


procedure DivdBttmLn(DividerCol,BckColr,ForColr: Byte);
 { Draws a full-scrn horz. line at Row#24, placing a downward length-2 vert
   divider at pos "DividerCol" }
 begin
   WriteFast(Dup(DividerCol-1,#196),1,24,BckColr,ForColr);
   WriteFast(#194,DividerCol,24,BckColr,ForColr);
   WriteFast(Dup(80-DividerCol,#196),DividerCol+1,24,BckColr,ForColr);
   WriteFast(#179,DividerCol,25,BckColr,ForColr)
 end; { DivdBttmLn }



End.

(* End of Unit "ColrText" ****************************************************)
