{$R-}    {Range checking off}
{$B-}    {Boolean short circuiting off}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

Program WidgitProg(Input,Output);
{  8/30/87 :   Data entry and screen handling are the strong suits of MiniGen.
             This program demonstrates the use of MiniGen generated procedures
             to get a program up and running quickly. After setting up the
             background color and clearing the screen, call the procedure you
             created with the MiniGen screen painter to display the main
             screen. Calls to EnterData() will gather your data which can then
             be written to a file or processed however you choose.
               While the structure of this program is quite simple, it does a
             lot for you. A better way to gather your data would be to use a
             case structure when calling EnterData(). The case selector should
             be a byte variable, while the case labels represent input fields
             numbered top to bottom, left to right on the screen. Hitting
             return or the tab key ( --> ), should take the user to the next
             field. Conversely, the back tab key ( <-- ), should take the user
             to the previous field. By embedding the case statement in a
             Repeat/Until loop and initializing the case selector to one,
             you can use the return code of EnderData to increment or
             decrement the case selector at the bottom of the loop. That will
             take you up and down the screen.
               In future versions of MiniGen, this data entry procedure will
             be automated, making the promise of full data entry application
             generation a reality. Until then, this program architecture should
             be easy to create, allowing you to turn out data entry programs
             in a couple of hours (once you get the hang of it), as I did with
             this one.

      Minigen Products
      Eric H. Snyder
      1417 Evergreen
      Homewood, IL  60430
}

Uses
  Crt,
  MGProg;

Const
  ScreenCount = 1;       { Enter the number of screens you wish to define }

{$I WIDGIT.INC}          { Screen procedure developed with MiniGen }

                         { Enter any ScrnGen window procedres here }

Var
  ReturnCode  : Integer;
  Continue    : Char;
  Name        : String[25];
  Addr1,Addr2 : String[30];
  City        : String[12];
  State       : String[2];
  Zip         : String[5];
  SSN1        : String[3];
  SSN2        : String[2];
  SSN3        : String[4];
  Cash,Check,
  Charge      : Char;
  Each,Box,
  _Case       : Char;
  Quantity    : Integer;
  Discount    : Integer;
  Price       : Real;
  Extension   : Real;

Type
  CharSet = Set of Char;

Function GetChar(Var CharIn:Char;XLoc,YLoc:Integer;
                     GoodChars,CharExits:Charset) : Integer;
Var
  Ch : Char;
Begin
GotoXY(Xloc,YLoc);
Repeat
  Ch := ReadKey;
Until (Ch in (GoodChars + CharExits));
If Ch in GoodChars then
  Begin
  CharIn := Ch;
  Write(Ch);
  End;
GetChar := 0;
If Ch in CharExits then
  GetChar := Ord(Ch);
End; {GetChar}

Procedure MainLoop;      { Main program logic }
Begin
TextBackground(Blue);
Continue := 'Y';
Repeat
  ClrScr;
  WidgitOEScreen;
  MG_TimeOut := 30;
  Name       := '';
  Addr1      := '';
  Addr2      := '';
  City       := '';
  State      := '';
  Zip        := '';
  SSN1       := '';
  SSN2       := '';
  SSN3       := '';
  Cash       := ' ';
  Check      := ' ';
  Charge     := ' ';
  Each       := ' ';
  Box        := ' ';
  _Case      := ' ';
  Quantity   := 1;
  Discount   := 0;
  Price      := 0.0;
  ReturnCode := EnterData(Name, 'S',22, 7,25,0,78,$87,[27]);
  ReturnCode := EnterData(Addr1,'S',22, 8,30,0,78,$87,[27]);
  ReturnCode := EnterData(Addr2,'S',22, 9,30,0,78,$87,[27]);
  ReturnCode := EnterData(City, 'S',22,10,12,0,78,$87,[27]);
  ReturnCode := EnterData(State,'U',36,10, 2,0,78,$87,[27]);
  ReturnCode := EnterData(Zip,  'N',40,10, 5,0,78,$87,[27]);
  ReturnCode := EnterData(SSN1, 'N',22,12, 3,0,95,$87,[27]);
  ReturnCode := EnterData(SSN2, 'N',26,12, 2,0,95,$87,[27]);
  ReturnCode := EnterData(SSN3, 'N',29,12, 4,0,95,$87,[27]);
  {
       EnterData() does not perform controlled I/O on Character data, so you
     may need to write a little routine like GetChar(), or use this one.
     The routine should be a function returning an integer, have a VAR
     variable which will receive the entered character, and be able to tell
     the difference between good data and an exit key.
  }
  ReturnCode := GetChar(Cash,  28,16,['X','x'],[#27]);
  ReturnCode := GetChar(Check, 38,16,['X','x'],[#27]);
  ReturnCode := GetChar(Charge,49,16,['X','x'],[#27]);
  ReturnCode := GetChar(Each,  28,17,['X','x'],[#27]);
  ReturnCode := GetChar(Box,   36,17,['X','x'],[#27]);
  ReturnCode := GetChar(_Case, 45,17,['X','x'],[#27]);
  GotoXY(1,1);
  LowerInt   := 1;
  UpperInt   := 144;
  ReturnCode := EnterData(Quantity, 'I',22,18,6,0,80,$87,[27]);
  LowerReal  := 0.50;
  UpperReal  := 100.00;
  ReturnCode := EnterData(Price,'R',38,18,6,2,80,$87,[27]);
  LowerInt   := 0;
  UpperInt   := 100;
  ReturnCode := EnterData(Discount, 'I',22,19,2,0,80,$87,[27]);
  Extension  := (Price * ((100 - Discount) / 100)) * Quantity;
  GotoXY(22,20);
  Write(Extension:8:2);
  GotoXY(1,25);
  Write('Again ? (Y/N) ');
  Continue   := Upcase(ReadKey);
Until Continue = 'N';
End;

Begin
ClrScr;
MaxLimits;
                        {** No screens defined in this demo **}
MainLoop;
TextBackground(Black);
ClrScr;
End.
