; Assembler interface to Turbo Pascal - MULKEY
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE     MULTRANS

DATA      SEGMENT WORD PUBLIC

          ASSUME  DS:DATA

          EXTRN   TransActive: BYTE
          EXTRN   TransLocks : BYTE
          EXTRN   IndexError : BYTE
          EXTRN   LastErrCode: WORD

DATA      ENDS

CODE      SEGMENT WORD PUBLIC

          ASSUME  CS:CODE

          EXTRN   AdjOp : NEAR
          EXTRN   SetErr: FAR
          EXTRN   Btrv  : FAR

          PUBLIC  BeginTransaction
          PUBLIC  AbortTransaction
          PUBLIC  EndTransaction

FALSE     EQU     0
TRUE      EQU     1
LocalSize EQU     2
BeginTransactionOp EQU 19
EndTransactionOp   EQU 20
AbortTransactionOp EQU 21

; CallBtrv calls btrieve with dummy arguments for these procs and then SetErr
; call with:   ax = op code

CallBtrv  PROC    NEAR
          sub     sp, LocalSize          ; make local data area
          mov     bx, sp                 ; make bx = OFFSET of local data area
          push    ax                     ; push op code in ax
          push    ss                     ; dummy 1 - local data area
          push    bx
          push    ss                     ; dummy 2 - local data area
          push    bx
          push    ss                     ; dummy 3 - local data area
          push    bx
          push    ss                     ; dummy 4 - local data area
          push    bx
          mov     ax, LocalSize * 256    ; push 0
          push    ax
          mov     al, ah                 ; push local size
          push    ax
          call    Btrv                   ; call the routine
          mov     bx, sp                 ; ss:[bx] = local data
          mov     ss:[bx], ax            ; send status to seterr
          call    SetErr                 ; call it and remove local data
          ret                            ; return to caller
CallBtrv  ENDP

; PROCEDURE AbortTransaction; EXTERNAL;

AbortTransaction  PROC FAR
          mov     ax, AbortTransactionOp ; load op code
          call    CallBtrv               ; call local routine
          mov     TransActive, FALSE     ; set it = FALSE
          retf                           ; return to caller
AbortTransaction  ENDP

; PROCEDURE EndTransaction; EXTERNAL;

EndTransaction    PROC FAR
          mov     ax, EndTransactionOp   ; load op code
          call    CallBtrv               ; call local routine
          cmp     IndexError, FALSE      ; if index error then jump
          jne     SHORT EndError         ; else set and return
          mov     TransActive, FALSE
          retf                           ; return to caller
EndError:
          push    LastErrCode            ; save last error code
          call    AbortTransaction       ; abort it if we can't end it
          call    SetErr                 ; set last error code before abort
          retf                           ; return to caller
EndTransaction    ENDP

; PROCEDURE BeginTransaction; EXTERNAL;

BeginTransaction  PROC FAR
          cmp     TransActive, FALSE     ; see if a transaction is active
          jz      SHORT BNotActive       ; jump if not
          call    EndTransaction         ; end the current transaction first
BNotActive:
          mov     ax, BeginTransactionOp ; load op code
          call    CallBtrv               ; call local routine
          mov     al, IndexError         ; TransActive:= NOT IndexError
          not     al
          and     al, 00000001B
          mov     TransActive, al
          retf                           ; return to caller
BeginTransaction  ENDP

CODE      ENDS

          END
