; Assembler interface to Turbo Pascal - MULKEY
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE      MULKEY

CODE       SEGMENT BYTE PUBLIC

           ASSUME  CS:CODE

           EXTRN   RPN_Record: NEAR

           PUBLIC  GetLowest, GetHighest, NextRecord, PrevRecord

NextRecordOp EQU 6
PrevRecordOp EQU 7
GetLowestOp  EQU 12
GetHighestOp EQU 13

; PROCEDURE xxxxxx(Handle: WORD;
;                  KeyNum: WORD;
;                  VAR d);

Handle     EQU     WORD  PTR ss:[bx + 10]
KeyNum     EQU     WORD  PTR ss:[bx + 8]
DBuf       EQU     DWORD PTR ss:[bx + 4]

NextRecord PROC    FAR
           mov     al, NextRecordOp       ; set op code
CallEntry:
           mov     bx, sp                 ; set up stack frame in bx
           push    Handle                 ; set up for call to RPN_Record
           push    KeyNum
           les     di, DBuf
           push    es
           push    di
           push    es
           push    di
           push    ax
           call    RPN_Record             ; make the call
           ret     8                      ; clean up and return to caller
NextRecord ENDP

PrevRecord PROC    FAR
           mov     al, PrevRecordOp       ; load op code
           jmp     SHORT CallEntry        ; make the call
PrevRecord ENDP

GetLowest  PROC    FAR
           mov     al, GetLowestOp        ; load op code
           jmp     SHORT CallEntry        ; make the call
GetLowest  ENDP

GetHighest PROC    FAR
           mov     al, GetHighestOp       ; load op code
           jmp     SHORT CallEntry        ; make the call
GetHighest ENDP

CODE       ENDS

           END
