; Assembler interface to Turbo Pascal - FMOVE
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

; WARNING! Only use this procedure if you are sure there will be no overlap

TITLE    FASTMOVE

CODE     SEGMENT WORD PUBLIC

         ASSUME  cs:CODE

         PUBLIC  FastMove

; PROCEDURE FastMove(VAR Source, Dest; Size: WORD); EXTERNAL;

Source   EQU     DWORD PTR ss:[bx + 10]
Dest     EQU     DWORD PTR ss:[bx + 6]
Num      EQU     WORD  PTR ss:[bx + 4]

FastMove PROC    FAR
         mov     bx, sp                 ; set up stack frame in bx
         mov     dx, ds                 ; save ds in dx
         les     di, Dest               ; es:[di] = destination
         lds     si, Source             ; ds:[si] = source
         mov     cx, Num                ; get number of bytes to move
         cld                            ; string ops go forward
         shr     cx, 1                  ; convert bytes to words
         jnc     SHORT WordMove         ; jump if not odd number
         movsb                          ; move the odd byte
WordMove:
         jcxz    Done                   ; if there was only one byte then jump
         rep     movsw                  ; move a word at a time
Done:
         mov     ds, dx                 ; restore ds from dx
         ret     10                     ; clean up and return to caller
FastMove ENDP

CODE     ENDS

         END
