; Assembler interface to Turbo Pascal - FFILL
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

; WARNING! Only use this procedure if you are sure there will be no overlap

TITLE    FASTFILL

CODE     SEGMENT WORD PUBLIC

         ASSUME  cs:CODE

         PUBLIC  FastFill

; PROCEDURE FastFill(VAR Dest; Size: WORD; Fill: BYTE); EXTERNAL;

Dest     EQU     DWORD PTR ss:[bx + 8]
FSize    EQU     WORD  PTR ss:[bx + 6]
Fill     EQU     BYTE  PTR ss:[bx + 4]

FastFill PROC    FAR
         mov     bx, sp                 ; set up stack frame in bx
         les     di, Dest               ; es:[di] = destination
         mov     al, Fill               ; get value to fill with
         mov     cx, FSize              ; get number of bytes to move
         cld                            ; string ops go forward
         shr     cx, 1                  ; convert bytes to words
         jnc     SHORT WordFill         ; jump if not odd number
         stosb                          ; store the odd byte
WordFill:
         jcxz    Done                   ; if there was only one byte then jump
         mov     ah, al                 ; copy al value to ah
         rep     stosw                  ; store a full word at a time
Done:
         ret     8                      ; clean up and return to caller
FastFill ENDP

CODE     ENDS

         END
