; Assembler interface to Turbo Pascal - CRC Unit
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE    CRC

DATA     SEGMENT WORD PUBLIC

         ASSUME  DS:DATA

         EXTRN   CrcTable: WORD

DATA     ENDS

CODE     SEGMENT BYTE PUBLIC

         ASSUME  CS:CODE

         PUBLIC  CalcCrc

; PROCEDURE CalcCrc(b: BYTE; VAR TheCrc: WORD); EXTERNAL;

TheByte  EQU     BYTE  PTR ss:[bx + 8]
TheCRC   EQU     DWORD PTR ss:[bx + 4]

; WARNING: This procedure must not destroy: ss, sp, ds, bp, cx or si

CalcCrc  PROC    FAR
         mov     bx, sp                 ; set up stack frame in bx
         les     di, TheCRC             ; get address of the crc value
         mov     bl, TheByte            ; get the byte into bl
         mov     dx, es:[di]            ; get the value into dx
         xor     bl, dh                 ; bl = array index = dh XOR TheByte
         xor     bh, bh                 ; clear out bh
         shl     bx, 1                  ; multiply by 2 for array index address
         mov     ax, CrcTable[bx]       ; get the crc table value
         xor     ah, dl                 ; calculate the crc value
         mov     es:[di], ax            ; store the value
         ret     6                      ; clean up and return to caller
CalcCrc  ENDP

CODE     ENDS

         END
