; Assembler interface to Turbo Pascal - CRC Unit
;
; Copyright 1988 by Mark R. Boler  -  All Rights Reserved

TITLE    CRC

CODE     SEGMENT BYTE PUBLIC

         ASSUME  CS:CODE

         PUBLIC  CalcCrc

; PROCEDURE CalcCrc(b: BYTE; VAR TheCrc: WORD); EXTERNAL;

TheByte  EQU     BYTE  PTR ss:[bx + 8]
TheCRC   EQU     DWORD PTR ss:[bx + 4]

; WARNING: This procedure must not destroy: ss, sp, ds, bp, cx or si

CalcCrc  PROC    FAR
         mov     bx, sp                 ; set up stack frame in bx
         mov     al, TheByte            ; get the byte into al
         les     di, TheCRC             ; get address of the crc value
         mov     bx, es:[di]            ; get old crc in bx
         xor     ah, ah                 ; compute the crc
         xor     al, bh
         mov     bh, bl
         mov     bl, al
         mov     dl, al
         and     dl, 0F0H
         xor     bh, dl
         rol     ax, 1
         xor     bh, ah
         mov     dl, al
         and     dl, 0E0H
         xor     bl, dl
         rol     ax, 1
         rol     ax, 1
         rol     ax, 1
         xor     bl, ah
         xor     bh, al
         rol     ax, 1
         xor     ax, bx
         mov     es:[di], ax            ; store the result
         ret     6                      ; clean up and return to caller
CalcCrc  ENDP

CODE     ENDS

         END
