;  Copyright 1988 by Mark R. Boler  -  All Rights Reserved
;
;  Code for bit manipulation of 8 bit bytes only
;
; PROCEDURE SetBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;
;
; PROCEDURE ClearBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;
;

TITLE   BITS8

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE

        PUBLIC  SetBit8, ClearBit8

; PROCEDURE SetBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;
; PROCEDURE ClearBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;

Target   EQU    DWORD PTR ss:[bx + 6]
BitNum   EQU    BYTE  PTR ss:[bx + 4]

SetBit8  PROC   FAR
         mov    bx, sp            ; set up stack frame in bx
         mov    cl, BitNum        ; cl = bit number
         and    cl, 00000111B     ; clear upper 5 bits out
         mov    al, 00000001B     ; al = mask
         shl    al, cl            ; set up the mask
         les    bx, Target        ; es:[bx] = Target
         or     es:[bx], al       ; set the bit of the byte
         ret    6                 ; return
SetBit8  ENDP

; PROCEDURE ClearBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;

ClearBit8       PROC  FAR
         mov    bx, sp            ; set up stack frame in bx
         mov    cl, BitNum        ; cl = bit number
         and    cl, 00000111B     ; clear upper 5 bits out
         mov    al, 00000001B     ; al = mask
         shl    al, cl            ; set up the mask
         not    al                ; negate the mask
         les    bx, Target        ; es:[bx] = Target
         and    es:[bx], al       ; clear the bit of the byte
         ret    6                 ; return to caller
ClearBit8       ENDP

CODE     ENDS

         END
