{ BITS }

{ Copyright 1988, 1989 by Mark R. Boler  -  All Rights Reserved }

{ Bit manipulation routines.   Contains functions and procedures that
  will set, clear or test individual bits in a BYTE or WORD.
  For the WORD sized routines, you can manipulate bits 0 through 15.
  Higher values will be masked off. (ie: BitNum will be logically ANDed
  with 15).  For the BYTE sized routines, you can manipulate bits 0
  through 7.  Higher values will be masked off - BitNumb will be logically
  ANDed with 7, UNLESS you use the BitIsSet function, which works with WORDS. }

{ --------------------------------------------------------------------------- }

{$B-}    { Boolean complete evaluation off }
{$D+}    { Debug information on            }
{$I-}    { I/O checking off                }
{$L+}    { Linker uses memory for a buffer }
{$N-}    { No numeric coprocessor          }
{$R-}    { Range checking off              }
{$S-}    { Stack checking off              }
{$V-}    { No VAR-String checks            }

UNIT Bits;

INTERFACE

PROCEDURE SetBit(VAR Target: WORD; BitNumb: BYTE);

PROCEDURE ClearBit(VAR Target: WORD; BitNumb: BYTE);

PROCEDURE SetBit8(VAR Target: BYTE; BitNumb: BYTE);

PROCEDURE ClearBit8(VAR Target: BYTE; BitNumb: BYTE);

FUNCTION BitIsSet(Target: WORD; BitNumb: BYTE): BOOLEAN;

{ --------------------------------------------------------------------------- }

IMPLEMENTATION

PROCEDURE SetBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;

PROCEDURE ClearBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;

PROCEDURE SetBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;

PROCEDURE ClearBit8(VAR Target: BYTE; BitNumb: BYTE); EXTERNAL;

FUNCTION BitIsSet(Target: WORD; BitNumb: BYTE): BOOLEAN; EXTERNAL;

{$L BITS.OBJ}
{$L BITS8.OBJ}

END. {Unit Bits}
