;  Copyright 1988 by Mark R. Boler  -  All Rights Reserved
;
;  Code for bit manipulation
;
; PROCEDURE SetBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;
;
; PROCEDURE ClearBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;
;
; FUNCTION BitIsSet(Target: WORD; BitNumb: BYTE): BOOLEAN; EXTERNAL;
;

TITLE   BITS

CODE    SEGMENT BYTE PUBLIC

        ASSUME  cs:CODE

        PUBLIC  SetBit, ClearBit, BitIsSet

; PROCEDURE SetBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;

Target   EQU    DWORD PTR ss:[bx + 6]
BitNum   EQU    BYTE  PTR ss:[bx + 4]

SetBit   PROC   FAR
         mov    bx, sp                ; set up stack frame in bx
         mov    cl, BitNum            ; cl = bit number
         and    cl, 00001111B         ; clear upper 4 bits out
         mov    ax, 0000000000000001B ; make ax = mask
         shl    ax, cl                ; set up the mask
         les    bx, Target            ; es:[bx] = Target
         or     es:[bx], ax           ; set the bit
         ret    6                     ; return
SetBit   ENDP

; PROCEDURE ClearBit(VAR Target: WORD; BitNumb: BYTE); EXTERNAL;

ClearBit PROC   FAR
         mov    bx, sp                ; set up stack frame
         mov    cl, BitNum            ; cl = bit number
         and    cl, 00001111B         ; clear upper 4 bits out
         mov    ax, 0000000000000001B ; make ax = mask
         shl    ax, cl                ; set up the mask
         not    ax                    ; negate the mask
         les    bx, Target            ; es:[bx] = Target
         and    es:[bx], ax           ; clear the bit
         ret    6                     ; return
ClearBit ENDP

; FUNCTION BitIsSet(Target; WORD; BitNumb: BYTE): BOOLEAN; EXTERNAL;

BTarget  EQU    WORD  PTR ss:[bx + 6]
BBitNum  EQU    BYTE  PTR ss:[bx + 4]

BitIsSet PROC   FAR
         mov    bx, sp                ; set up stack frame in bx
         mov    cl, BBitNum           ; cl = bit number
         and    cl, 00001111B         ; clear upper 4 bits out
         mov    ax, BTarget           ; Target in ax
         shr    ax, cl                ; shift to get result
         and    al, 00000001B         ; set function result
         ret    4                     ; return to caller
BitIsSet ENDP

CODE     ENDS

         END
