unit ShadoU;

interface
uses StrnU, ColorIU, FastWr;
procedure Shadow( X1,
                  Y1,
                  X2,
                  Y2:       integer;   (* X & Y plus offsets *)
                  Attr:     byte;
                  Fill:     boolean);

implementation

procedure Shadow;
var I:                      integer;
    TopLine,
    BottomLine,
    TempLine:              string;
begin
TempLine := Strng(X2 - X1 - 1,#205);
TopLine :=  #201 + TempLine + #187;
BottomLine := #200 + TempLine + #188;
FastWrite(TopLine, Y1, X1, Attr);
FastWrite(BottomLine, Y2, X1, Attr);
for I := Y1+1 to Y2-1 do
    begin
    FastWrite(#186, I, X1, Attr);
    FastWrite(#186, I, X2, Attr);
    end;
if Fill then
   begin
   ColorIn( X1+1, Y1+1, X2-1, Y2-1, Attr);
   ColorIn( X1+2, Y2+1, X2+1, Y2+1, $0000);  (* bottom in black *)
   ColorIn( X2+1, Y1+1, X2+2, Y2+1, $0000);  (* side in black   *)
   end;
end;

end.
