unit GenMenus;

interface
uses Crt, FastWr, ColorDef, ColorIU, ShadoU, GetKeU, IMaU, LPaU, CPaU;
type LineArray =         array [0..10] of string[80];
function RetMenu( Line:        LineArray;
                  MaxLine:     integer;
              var FunctionKey: boolean): char;

implementation

function RetMenu;
var I,
    Width,
    Col,
    Row:               integer;
    Ch:                char;
begin
clrscr;
ColorIn( 1, 1, 80, 25, Displays.Attr);
Row := ((24 - (MaxLine + 2)) div 2) + 2;
Width := 0;
for I := 0 to MaxLine do Width := IMax( Width, ord(length(Line[I])) );
Col:= (80 - Width) div 2;
Shadow( Col-2, Row-2, Col+Width+1, Row+succ(MaxLine), Menus.Attr, true);
for I := 1 to MaxLine do Line[I] := LPad( Line[I], Width);
Line[0] := CPad( Line[0], Width);
for I := 1 to MaxLine do
      begin
      FastWrite( Line[I], Row+I, Col, Menus.Attr);
      end;
FastWrite(Line[0], Row-1, Col, Menus.Attr);
GetKey(Ch,FunctionKey);
clrscr;
RetMenu := Ch;
end;

end.
