{$S-,R-,V-,D-,T-}

unit FastWr;

interface
type     DisplayType = (Monochrome, CGA, EGA, MCGA, VGA);
var      BaseOfScreen:   Word;       {Base address of video memory}
         WaitForRetrace: Boolean;    {Check for snow on color cards?}
procedure FastWrite(St: string; Row, Col, Attr: Byte);
procedure FastWriteNA(St: string; Row, Col: Byte);
procedure ChangeAttribute(Number: Word; Row, Col, Attr: Byte);
procedure MoveFromScreen(var Source, Dest; Length: Word);
procedure MoveToScreen(var Source, Dest; Length: Word);
function CurrentDisplay: DisplayType;
procedure ReinitFastWrite;

implementation

  {$L FASTWR}

  {$F+}
  procedure FastWrite(St: string; Row, Col, Attr: Byte);
    external {FASTWR} ;

  procedure FastWriteNA(St: string; Row, Col: Byte);
    external {FASTWR} ;

  procedure ChangeAttribute(Number: Word; Row, Col, Attr: Byte);
    external {FASTWR} ;

  procedure MoveFromScreen(var Source, Dest; Length: Word);
    external {FASTWR} ;

  procedure MoveToScreen(var Source, Dest; Length: Word);
    external {FASTWR} ;

  function CurrentDisplay: DisplayType;
    external {FASTWR} ;

  function CurrentVideoMode: Byte;
    external {FASTWR} ;
  {$F-}

  procedure ReinitFastWrite;
  begin                      {InitFastWrite}
    if CurrentVideoMode = 7 then
      BaseOfScreen:= $B000  {Mono}
    else
      BaseOfScreen:= $B800; {Color}
    WaitForRetrace:= (CurrentDisplay = CGA);
  end;                       {InitFastWrite}

begin
  ReinitFastWrite;
end.

