unit Colors;

interface
uses Crt,      SetAttU,    ColorDef, DrawSqar, FastWr, CPaU, GetKeU,
     TestFile, RenFile;
var TempFile:      string;
procedure GetColors;
procedure PutColors;
procedure ColorSet;

implementation

procedure GetColors;
var  Continue:            boolean;
     Err:                 integer;
     ColorFile:           file of AttrRecord;
     OldFile,
     TempFile:            string;
begin

Continue := true;
OldFile  := 'MailColr';
TempFile := 'ColorUse';
if TestFileExist(OldFile) then ReNameFile( OldFile, TempFile);
assign(ColorFile,TempFile);
{$i-}
reset(ColorFile);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
Inputs.FG := white;
Inputs.BG := black;
Inputs.Blink := false;
Inputs.Intense := false;
Inputs.Attr := SetAttr(Inputs.Blink,Inputs.Intense,Inputs.FG,Inputs.BG);
if Continue then
   read(ColorFile,Inputs);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
Headings.FG := white;
Headings.BG := black;
Headings.Blink := false;
Headings.Intense := false;
Headings.Attr := SetAttr(Headings.Blink,Headings.Intense,Headings.FG,Headings.BG);
if Continue then
   read(ColorFile,Headings);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
Displays.FG := white;
Displays.BG := black;
Displays.Blink := false;
Displays.Intense := false;
Displays.Attr := SetAttr(Displays.Blink,Displays.Intense,Displays.FG,Displays.BG);
if Continue then
   read(ColorFile,Displays);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
Msgs.FG := white;
Msgs.BG := black;
Msgs.Blink := false;
Msgs.Intense := false;
Msgs.Attr := SetAttr(Msgs.Blink,Msgs.Intense,Msgs.FG,Msgs.BG);
if Continue then
   read(ColorFile,Msgs);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
Menus.FG := white;
Menus.BG := black;
Menus.Blink := false;
Menus.Intense := false;
Menus.Attr := SetAttr(Menus.Blink,Menus.Intense,Menus.FG,Menus.BG);
if Continue then
   read(ColorFile,Menus);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

{$i-}
close(ColorFile);
{$i+}  Err := ioresult;
if Err <> 0 then Continue := false;

end;


procedure PutColors;
var  ColorFile:           file of AttrRecord;
begin

TempFile := 'ColorUse';
assign(ColorFile,TempFile);
rewrite(ColorFile);

write(ColorFile,Inputs);
write(ColorFile,Headings);
write(ColorFile,Displays);
write(ColorFile,Msgs);
write(ColorFile,Menus);

close(ColorFile);
end;

procedure ColorSet;
var Inpts,
    Head,
    Dsply,
    Msg,
    Menu,
    Blink:                 string;
    OffSet,
    Normal:                byte;


    procedure ShowColorMenu( X: byte);
    var Point:                             byte;
    begin
    Point := X * 4 + 1;
    case X of
        1:  begin
            DrawSquare( OffSet, Point, OffSet+40, Point+3,
                         (Inputs.Attr or $0008), true);
            FastWrite( Inpts, Point+1, succ(OffSet), Inputs.Attr);
            FastWrite( CPad('[F1] = FG   [F2] = BG',38),
                       Point+2, succ(OffSet), Inputs.Attr);
            end;
        2:  begin
            DrawSquare( OffSet, Point, OffSet+40, Point+3,
                         (Displays.Attr or $0008), true);
            FastWrite( Dsply, Point+1, succ(OffSet), Displays.Attr);
            FastWrite( CPad('[F3] = FG   [F4] = BG',38),
                       Point+2, succ(OffSet),Displays.Attr);
            end;
        3:  begin
            DrawSquare( OffSet, Point, OffSet+40, Point+3,
                         (Msgs.Attr or $0008), true);
            FastWrite(Msg,succ(Point), succ(OffSet),Msgs.Attr);
            FastWrite( CPad('[F5] = FG   [F6] = BG',38),
                       Point+2, succ(OffSet),Msgs.Attr);
            end;
        4:  begin
            DrawSquare( OffSet, Point, OffSet+40, Point+3,
                         (Headings.Attr or $0008), true);
            FastWrite(Head,succ(Point), succ(OffSet),Headings.Attr);
            FastWrite( CPad('[F7] = FG   [F8] = BG',38),
                       Point+2, succ(OffSet), Headings.Attr);
            end;
        5:  begin
            DrawSquare( OffSet, Point, OffSet+40, Point+3,
                         (Menus.Attr or $0008), true);
            FastWrite(Menu,succ(Point), succ(OffSet),Menus.Attr);
            FastWrite( CPad('[F9] = FG   [F10]= BG',38),
                       Point+2, succ(OffSet), Menus.Attr);
            end;
        end;
    end;


    procedure IncBG( var X: AttrRecord; Show: integer);
    begin
    X.Blink := false;
    inc(X.BG);
    if X.BG > 7 then
       begin
       X.BG := 0;
       end;
    X.Attr := SetAttr( X.Blink, X.Intense, X.FG, X.BG);
    ShowColorMenu(Show);
    end;


    procedure IncFG( var X: AttrRecord; Show: integer);
    begin
    X.Blink := false;
    inc(X.FG);
    if X.FG > 7 then
       begin
       X.FG := 0;
       X.Intense := not X.Intense;
       end;
    X.Attr := SetAttr( X.Blink, X.Intense, X.FG, X.BG);
    ShowColorMenu(Show);
    end;


    procedure DecBG( var X: AttrRecord; Show: integer);
    begin
    X.Blink := false;
    dec(X.BG);
    if X.BG < 0 then
       begin
       X.BG := 7;
       end;
    X.Attr := SetAttr( X.Blink, X.Intense, X.FG, X.BG);
    ShowColorMenu(Show);
    end;


    procedure DecFG( var X: AttrRecord; Show: integer);
    begin
    X.Blink := false;
    dec(X.FG);
    if X.FG < 0 then
       begin
       X.FG := 7;
       X.Intense := not X.Intense;
       end;
    X.Attr := SetAttr( X.Blink, X.Intense, X.FG, X.BG);
    ShowColorMenu(Show);
    end;


    procedure ColorControl;
    var I:                  integer;
        FunctionKey,
        Continue:           boolean;
        Ch:                 char;
    begin
    for I := 1 to 5 do ShowColorMenu(I);
    FastWrite(CPad('[Function key] - rolls forward 1 color',78), 1, 2, Normal);
    FastWrite(CPad('[SHIFT] and [Function key] - rolls backward 1 color',78),2,2,Normal);
    FastWrite(CPad('FG = foreground color   BG = background color',78), 3, 2, Normal);
    FastWrite(CPad('[ESC] to exit',78), 4, 2, Normal);
    Continue := true;
    while Continue do
        begin
        GetKey(Ch,FunctionKey);
        if not FunctionKey then
           begin
           if Ch = #27 then Continue := false;
           end
          else
           begin
           case ord(Ch) of
               59: IncFG(Inputs,1);
               60: IncBG(Inputs,1);
               61: IncFG(Displays,2);
               62: IncBG(Displays,2);
               63: IncFG(Msgs,3);
               64: IncBG(Msgs,3);
               65: IncFG(Headings,4);
               66: IncBG(Headings,4);
               67: IncFG(Menus,5);
               68: IncBG(Menus,5);
               84: DecFG(Inputs,1);
               85: DecBG(Inputs,1);
               86: DecFG(Displays,2);
               87: DecBG(Displays,2);
               88: DecFG(Msgs,3);
               89: DecBG(Msgs,3);
               90: DecFG(Headings,4);
               91: DecBG(Headings,4);
               92: DecFG(Menus,5);
               93: DecBG(Menus,5);
               end;
           end;
        end;
    end;


begin
GetColors;
textcolor(7);
textbackground(0);
clrscr;
OffSet := 20;
Normal := SetAttr(false,true,7,0);

Inpts   := CPad('  All Input Fields  ',38);
Head    := CPad('    All Headings    ',38);
Dsply   := CPad('   Major Displays   ',38);
Msg     := CPad('  Control Messages  ',38);
Menu    := CPad('     All Menus      ',38);

ColorControl;
PutColors;

end;

end.

