unit State;

interface
uses Crt, Def, ColorDef, FastWr, GetKeU, SetAttU, DrawSqar, SetBU, LPaU;
const
StateTop  : integer = 13;
StateLine : array [1..13] of Line = (
'AL Alabama          IN Indiana          NE Nebraska         SC South Carolina',
'AK Alaska           IA Iowa             NV Nevada           SD South Dakota',
'AZ Arizona          KS Kansas           NH New Hampshire    TN Tennessee',
'AR Arkansas         KY Kentucky         NJ New Jersey       TX Texas',
'CA California       LA Louisiana        NM New Mexico       UT Utah',
'CO Colorado         ME Maine            NY New York         VT Vermont',
'CT Connecticut      MD Maryland         NC North Carolina   VA Virginia',
'DE Delaware         MA Massachusetts    ND North Dakota     WA Washington',
'FL Florida          MI Michigan         OH Ohio             WV West Virginia',
'GA Georgia          MN Minnesota        OK Oklahoma         WI Wisconsin',
'HI Hawaii           MS Mississippi      OR Oregon           WY Wyoming',
'ID Idaho            MO Missouri         PA Pennsylvania        -------  ',
'IL Illinois         MT Montana          RI Rhode Island        ------- ');

function DisplayStates: S2;

implementation

function DisplayStates;
var I,
    Row,
    Col,
    X:        integer;
    AltAttr:  byte;
    ScreenBuffer:   array [1..2000] of word;

  procedure GetState;
  var Point,
      OCh:            integer;
      Ch:             char;
      Continue,
      FunctionKey:        boolean;
      Str:             S2;
  begin
  Continue := true;
  while Continue do
    begin
    Point := (Col-1) * 20 + 1;
    FastWrite( copy(StateLine[Row],Point,19), Row, Point, AltAttr);
    GetKey(Ch,FunctionKey);
    FastWrite( copy(StateLine[Row],Point,19), Row, Point, Menus.Attr);
    if FunctionKey then
       begin
       if (Ch = #75) and (Col > 1) then dec(Col);
       if (Ch = #77) and (Col < 4) then inc(Col);
       if (Ch = #72) and (Row > 1) then dec(Row);
       if (Ch = #80) and (Row < StateTop) then inc(Row);
       if Ch = #68 then
          begin
          Str := copy(StateLine[Row], Point, 2);
          Continue := false;
          end;
       end
      else
       begin
       if Ch = #27 then
          begin
          Str := '  ';
          Continue := false;
          end;
       end;
    end;
    DisplayStates := Str;
  end;

begin
MoveFromScreen( mem[BaseOfScreen:0], ScreenBuffer, 2000);
SetBG;
clrscr;
AltAttr := SetAttr( Menus.Blink, false, Menus.bg, Menus.fg);
for I := 1 to StateTop do FastWrite(LPad(StateLine[I],80), I, 1, Menus.Attr);
FastWrite( BlankLine, 24, 1, Menus.Attr);
DrawSquare( 1, 23, 80, 25, Menus.Attr, true);
FastWrite( '[ESC]', 24, 19, Menus.Attr);
FastWrite( '= exit', 24, 25, (Menus.Attr xor $0008));
FastWrite( '[F10]', 24, 34, Menus.Attr);
FastWrite( '= select state', 24, 40, (Menus.Attr xor $0008));
Row := 1; Col := 1;
GetState;
MoveToScreen( ScreenBuffer, mem[BaseOfScreen:0], 2000);
end;

end.

