unit SS;

interface
uses Crt, Def, ColorDef, FastWr, LPaU, ColorIU, CE, RE, DL, DrawSqar;
procedure ScreenDisplay(var BeginLine, EndLine: longint);

implementation

procedure ScreenDisplay;
var I,
    Row:      integer;

(* this proc. Displays operations menu  *)
(* scrnmenu.mp *)

    procedure ScreenMenu;
    var PageBottom,
        I:                 integer;
        TempStr,
        X:                 string;
    begin
    PageBottom := 16;

    TempStr := 'Addressee';
    if ProgramUse = 2 then TempStr := 'Company';
    FastWrite( LPad(TempStr,29), PageBottom, 6, Headings.Attr);
    case ShowMode of
        1:  begin
            FastWrite( LPad('Phone #1',12), PageBottom, 36, Headings.Attr);
            FastWrite( LPad('Phone #2',12), PageBottom, 49, Headings.Attr);
            FastWrite( LPad('Division',9),  PageBottom, 62, Headings.Attr);
            FastWrite( LPad('Sub-dvsn',9),  PageBottom, 72, Headings.Attr);
            end;
        2:  begin
            FastWrite( LPad('Auxiliary address',30), PageBottom,36,
                      Headings.Attr);
            FastWrite( LPad('Phone #1',12), PageBottom, 67, Headings.Attr);
            end;
        3:  begin
            FastWrite( LPad('Mailing address',24), PageBottom,36,
                      Headings.Attr);
            FastWrite( LPad('City',11), PageBottom, 61, Headings.Attr);
            FastWrite( 'St', PageBottom, 73, Headings.Attr);
            FastWrite( LPad('Zip',5), PageBottom, 76, Headings.Attr);
            end;
        4:  begin
            FastWrite( LPad('Title',15),    PageBottom, 36, Headings.Attr);
            if ProgramUse = 2 then
               FastWrite( LPad('Addressee',16),  PageBottom, 52, Headings.Attr)
              else
               FastWrite( LPad('Company',16),  PageBottom, 52, Headings.Attr);
            FastWrite( LPad('Phone #1',12), PageBottom, 69, Headings.Attr);
            end;
        end;
    DrawSquare( 1, PageBottom+1, 80, PageBottom+7, (Menus.Attr xor $0008),
                 true);
    FastWrite( ' PG UP        HOME                     F1 = SHIFT UP         F2 = SHIFT DN',
              PageBottom+2, 2, Menus.Attr);
    FastWrite( ' PG DN        END                      F3 = FILE PRINT       F4 = EDIT',
              PageBottom+3, 2, Menus.Attr);
    FastWrite( ' DELETE       MULTIPLE PRINT (^P)      F5 = SYSTEM SETUP     F6 = PHONE FIND',
              PageBottom+4, 2, Menus.Attr);
    FastWrite( ' INSERT       RETURN ADDRESS (^R)      F7 = PRINT LINE       F8 = PRINT FORM',
              PageBottom+5, 2, Menus.Attr);
    FastWrite( ' ESC                                   F9 = BUILD LIST       F10= FIND NAME',
              PageBottom+6, 2, Menus.Attr);
    ColorIn( 1, 24, 80, 25, Msgs.Attr);
    FastWrite('Printer  ',24,1,Msgs.Attr);
    FastWrite('Entries  ',25,1,Msgs.Attr);
    FastWrite('Sorted   ',25,41,Msgs.Attr);
    FastWrite('Drive    ',25,61,Msgs.Attr);

    FastWrite( Printers[ActivePrinter], 24, 10, (Msgs.Attr xor $0008));
    str(FileTop,X);
    FastWrite( X, 25, 10, (Msgs.Attr xor $0008));
    str(SortTop,X);
    FastWrite( X, 25, 50, (Msgs.Attr xor $0008));
    FastWrite( DataDrive, 25, 70, (Msgs.Attr xor $0008));

    end;

begin
clrscr;
CheckEnds(BeginLine,EndLine);
Row := 0;
for I := BeginLine to EndLine do
    begin
    GetRec(Entry,I);
    inc(Row);
    { writeln(Row); }
    DisplayLine(Entry, Row, Displays.Attr);
    end;
ScreenMenu;
end;

end.
