unit SortLisU;

interface
uses Crt,     Def,    ColorDef, SetBU,    ShadoU,   FastWr, LPaU, Str2InU,
     GetForU, UCasU,  RE,       CursorOU, DrawSqar, CPaU;
procedure SortList( var Stack:              BlockArray;
                         StackTop:          integer;
                     var FirstSortElement:  integer);

implementation

procedure SortList;
type
LinkPointer = ^Node;
Node        = record
              Info:       string;
              RecordNum:  integer;
              Left,
              Right:      LinkPointer
              end;

var
Info:         string;
Offset,
Position,
I:            integer;
Top,
P,
A:            LinkPointer;
Order:        array [0..LastDescription] of integer;


   procedure SelectOrder;
   var Error,
       I,
       AllowControl,
       Entry:            integer;
       TempStr:          S10;
       AllowInput:       boolean;
   begin
   SetBG;
   clrscr;
   Order[0] := 0;
   Shadow( 1, 3, 29, LastDescription+4, Menus.Attr, true);
   for I := 1 to LastDescription do
       begin
       str(I:3,TempStr);
       FastWrite( LPad(TempStr+' '+Description[I],25), I+3, 3, Menus.Attr);
       end;
   Entry := 7;
   FastWrite( 'Enter zero (0) to sort !', 1, 33, Msgs.Attr);
   while Entry <> 0 do
      begin
      FastWrite('Next in order ? (-1 = restart)  ', 3+Order[0], 33, Inputs.Attr);
      AllowInput := true;
      AllowControl := -1;
      Entry := Str2Int( GetForm( 67, 3+Order[0], 2, '  ', '0', AllowControl,
                        AllowInput, (Inputs.Attr or $0008), ['0'..'9','-']),
               Error);
      SetBG;
      if ((Entry < 1) and (Entry <> -1)) or (Entry > LastDescription) then
         Entry := 0
        else
         if Entry <> -1 then
            begin
            inc(Order[0]);
            Order[Order[0]] := Entry;
            gotoxy(33,2+Order[0]);    clreol;
            FastWrite( LPad( Description[Order[Order[0]]],45),
                       2+Order[0], 33, Msgs.Attr);
            end
           else
            begin
            for I := 1 to succ(Order[0]) do
                begin
                FastWrite( copy(BlankLine,1,49), 2+I, 33, Displays.Attr);
                end;
            Order[0] := 0;
            end;
      end;
   end;

   procedure AssignValues( RecordNum: integer; var A: LinkPointer);
   var Field,
       ZipPositions,
       I:                      integer;
       TempEntry:                 MainRecordType;
   begin
   GetRec(TempEntry,RecordNum);
   with TempEntry do
      begin
      new(A);
      A^.Left := nil;
      A^.Right := nil;
      A^.RecordNum  := RecordNum;
      A^.Info := '';
      for I := 1 to Order[0] do
          begin
          Field := Order[I];
          case Field of
              1:  A^.Info := A^.Info + UCase(Addressee);
              2:  A^.Info := A^.Info + UCase(Title);
              3:  A^.Info := A^.Info + UCase(Company);
              4:  A^.Info := A^.Info + UCase(AuxAddress);
              5:  A^.Info := A^.Info + UCase(MailAddress);
              6:  A^.Info := A^.Info + UCase(City);
              7:  A^.Info := A^.Info + UCase(State);
              8:  begin
                  if (ord(ZipCode[7]) < 48)
                  or (ord(ZipCode[7]) > 57) then
                        ZipPositions := 5
                       else
                        ZipPositions := 10;
                  A^.Info := A^.Info + UCase(copy(ZipCode,1,ZipPositions));
                  end;
              9:  A^.Info := A^.Info + UCase(Phone1);
             10:  A^.Info := A^.Info + UCase(Phone2);
             11:  A^.Info := A^.Info + UCase(Comments);
             end;   (* case *)
          end;      (* for loop *)
      end;          (* with statement *)
   end;

   procedure Sort( Info: string; A,P: LinkPointer);
   begin
   if Info >= P^.Info then
      begin
      if P^.Right = nil then
         P^.Right := A
        else
         Sort(Info,A,P^.Right);
      end
     else
      begin
      if P^.Left = nil then
         P^.Left := A
        else
         Sort(Info,A,P^.Left);
      end;
   end;

   procedure Traverse( A: LinkPointer);
   begin
   if A <> nil then
      begin
      Traverse(A^.Left);
      inc(Position);
      Stack[Position] := A^.RecordNum;
      Traverse(A^.Right)
      end;
   end;

begin
SelectOrder;
if Order[0]  >  0 then
   begin
   CursorOn(false);
   SetBG;
   clrscr;
   DrawSquare( 30, 10, 50, 15, Msgs.Attr, true);
   FastWrite( CPad('Standby',10), 12, 35, Msgs.Attr);
   FastWrite( CPad('Sorting',10), 13, 35, (Msgs.Attr or $0080));
   AssignValues(Stack[1],Top);
   for I := 2 to StackTop do
       begin
       AssignValues(Stack[I],A);
       Sort(A^.Info,A,Top)
       end;
   Position := 0;
   Traverse(Top);
   FirstSortElement := Order[1];
   clrscr;
   CursorOn(true);
   end;
end;

end.
