unit SO;

interface
uses Crt,   Def,    ColorDef, FT,       CursorOU, RE,      FastWr, DrawSqar,
     CPaU,  UCasU,  SetBU,    LPaU,     GetKeU;
procedure InPlaceSort( StartRec: integer);
procedure InsertSort;
procedure MergeSort;
procedure SortQuery(var Continue : boolean);

implementation

procedure InPlaceSort;
var Continue:                    boolean;
    RecordNum:                   integer;
    Above,
    Below:                       MainRecordType;
begin
CursorOn(false);
GetRec(HoldEntry,StartRec);
DrawSquare( 30, 11, 50, 13, Msgs.Attr, true);
FastWrite( CPad('Sorting',10), 12, 35, (Msgs.Attr or $0080));
while Continue do
   begin
   if StartRec <> FileTop then
      GetRec(Above,succ(StartRec))
     else
      Above := HoldEntry;
   if StartRec <> 1 then
      GetRec(Below,pred(StartRec))
     else
      Below := HoldEntry;
   if  (UCase(HoldEntry.Addressee) >= UCase(Below.Addressee))
   and (UCase(HoldEntry.Addressee) <= UCase(Above.Addressee)) then
       Continue := false                           (* if..then 1 *)
     else
      begin
      if UCase(HoldEntry.Addressee)  >  UCase(Above.Addressee) then
         begin                                     (* if..then 2 *)
         GetRec(Entry,succ(StartRec));
         PutRec(Entry,StartRec);
         inc(StartRec);
         end
      else
         begin
         GetRec(Entry,pred(StartRec));
         PutRec(Entry,StartRec);
         dec(StartRec);
         end;      (* if..then..else 2 *)
      end;         (* if..then..else 1 *)
   end;            (* while loop *)
PutRec(HoldEntry,StartRec);
CursorOn(true);
end;

(* -------------------------------------------------------------------- *)

procedure InsertSort;
var Found:                    boolean;
    TempStr:                  S10;
    Start,
    N,
    K,
    I:                        integer;
begin
SetBG;
clrscr;
CursorOn(false);
FastWrite( CPad('Sorting',20), 1, 30, (Msgs.Attr or $0080));
DrawSquare( 30, 9, 50, 14, Headings.Attr, true);
FastWrite( CPad('Top of file',18), 10, 31, Headings.Attr);
str(FileTop, TempStr);
FastWrite( CPad(TempStr,10), 11, 35, Headings.Attr);
FastWrite( CPad('Sorting',18), 12, 31, Headings.Attr);
if FileTop  >  1 then
   begin
   Start := succ(SortTop);
   for N := Start to FileTop do
       begin
       str(N,TempStr);
       FastWrite( CPad(TempStr,10), 13, 35, Msgs.Attr);
       GetRec(Entry,N);                      (* get sort Entry *)
       HoldEntry := Entry;                   (* save for later *)
       TestName := Entry.Addressee;
       K := pred(N);
       Found := false;
       while (not Found) and (K > 0) do
           begin                                    (* search list in *)
           GetRec(Entry,K);                         (* descending order *)
           if UCase(Entry.Addressee)  >  UCase(TestName) then
              begin                                 (* move each Entry *)
              PutRec(Entry,succ(K));                (* upward *)
              dec(K);
              end
           else                                   (* until proper *)
              begin                               (* place is *)
              PutRec(HoldEntry,succ(K));
              Found := true;                      (* Found *)
              end;  (* if..then..else *)
           end;     (* while *)
       if not Found then PutRec(HoldEntry,1);
       inc(SortTop);
       PutFileTop;
       end;         (* for..next loop *)
   end;             (* other for..next loop *)
CursorOn(true);
end;

(* -------------------------------------------------------------------- *)

procedure MergeSort;
var GetPoint,
    PutPoint,
    TempTop,
    UseTop,
    J,
    I:            integer;
    FromArray:    boolean;
    TempStr:      S10;
    Entries:      array [0..100] of MainRecordType;

    procedure DoMerge;
    var Continue:         boolean;
        J,
        I:                integer;
        TempStr:          S10;
    begin
    FastWrite( CPad('sorting',10), 1, 30, (Msgs.Attr or $0080));
    FastWrite( LPad('top of file :',18), 3, 30, Headings.Attr);
    FastWrite( LPad('sorted Entries :',18), 5, 30, Headings.Attr);
    FastWrite( LPad('testing :',18), 7, 30, Headings.Attr);
    FastWrite( LPad('reading to :',18), 9, 30, Headings.Attr);
    FastWrite( LPad('sorting to :',18), 11, 30, Headings.Attr);
    FastWrite( LPad('placing :',18), 13, 30, Headings.Attr);
    str(FileTop:5,TempStr);
    FastWrite( TempStr, 3, 50, Msgs.Attr);
    str(SortTop:5,TempStr);
    FastWrite( TempStr, 5, 50, Msgs.Attr);
    Continue := true;
    I := 1;
    while Continue do
       begin
       if (I mod 5) = 0 then
          begin
          str(I:5,TempStr);
          FastWrite( TempStr, 7, 50, Msgs.Attr);
          end;
       GetRec(Entry,I);
       GetRec(HoldEntry,succ(I));
       if UCase(Entry.Addressee)  >  UCase(HoldEntry.Addressee) then
          begin
          SortTop := I;
          Continue := false;
          end
         else
          begin
          inc(I);
          if I >= SortTop then Continue := false;
          end;
       end;
    PutPoint := 0;
    UseTop := SortTop + 100;
    if UseTop > FileTop then UseTop := FileTop;
    for I := succ(SortTop) to UseTop do
        begin
        str(I:5,TempStr);
        FastWrite( TempStr, 9, 50, Msgs.Attr);
        GetRec(Entry,I);
        inc(PutPoint);
        Entries[PutPoint] := Entry;
        end;
    TempTop := PutPoint;
    for J := TempTop downto 2 do
        begin
        str(succ(UseTop)-J:5,TempStr);
        FastWrite( TempStr, 11, 50, Msgs.Attr);
        for I := 1 to pred(J) do
            if UCase(Entries[J].Addressee)  < UCase(Entries[I].Addressee) then
               begin
               Entries[0] := Entries[J];
               Entries[J] := Entries[I];
               Entries[I] := Entries[0];
               end;
        end;
    str(UseTop:5,TempStr);
    FastWrite( TempStr, 11, 50, Msgs.Attr);
    PutPoint := UseTop;
    GetPoint := SortTop;
    str(succ(UseTop)-TempTop:5,TempStr);
    FastWrite( TempStr, 13, 50, Msgs.Attr);
    while TempTop > 0 do
       begin
       if GetPoint > 0 then
          begin
          GetRec(Entry,GetPoint);
          if UCase(Entries[TempTop].Addressee)  >  UCase(Entry.Addressee) then
             FromArray := true
            else
             FromArray := false;
          end
         else
          begin
          FromArray := true;
          end;
       if FromArray then
          begin
          PutRec(Entries[TempTop],PutPoint);
          dec(TempTop);
          dec(PutPoint);
          str(succ(UseTop)-TempTop:5,TempStr);
          FastWrite( TempStr, 13, 50, Msgs.Attr);
          end
         else
          begin
          GetRec(Entry,GetPoint);
          PutRec(Entry,PutPoint);
          dec(PutPoint);
          dec(GetPoint);
          end;
       end;                  (* end while *)
    SortTop := UseTop;
    PutFileTop;
    if FileTop <> SortTop then DoMerge;
    end;

begin
clrscr;
CursorOn(false);
DoMerge;
CursorOn(true);
end;

(* -------------------------------------------------------------------- *)

procedure SortQuery;
var Ch:                  char;
    FunctionKey:         boolean;
    TempStr:             S10;
begin
SetBG;
clrscr;
DrawSquare( 5, 9, 75, 12, Msgs.Attr, true);
str(FileTop:5,TempStr);
FastWrite( CPad('There are '+TempStr+' total  entries in the file.',60),
          10, 10, Msgs.Attr);
str(SortTop:5,TempStr);
FastWrite( CPad('There are '+TempStr+' sorted entries in the file.',60),
          11, 10, Msgs.Attr);
DrawSquare( 15, 14, 65, 16, Inputs.Attr, true);
FastWrite( CPad('Would you like to sort at this time ?',40),
          15, 20, Inputs.Attr);
Ch := ' ';
while (Ch <> 'Y') and (Ch <> 'N') do
    begin
    GetKey(Ch,FunctionKey);
    Ch := upcase(Ch);
    end;
if Ch = 'Y' then Continue := true else Continue := false;
end;

end.
