unit PR;

interface
uses Def;
procedure GetPrinters;
procedure PutPrinters;
procedure GetPrinterCodes;
procedure PutPrinterCodes;

implementation

procedure GetPrinters;
var TempFile:              text;
    I:                     integer;
begin
{$I-}
assign(TempFile,'printers.drv');
reset(TempFile);
for I := 1 to MostPrinters do
    begin
    Printers[I] := ' ';
    readln(TempFile,Printers[I]);
    end;
{$I+}
if ioresult = 0 then begin end;
close(TempFile);
end;

procedure PutPrinters;
var TempFile:              text;
    I:                     integer;
begin
assign(TempFile,'printers.drv');
rewrite(TempFile);
for I := 1 to MostPrinters do writeln(TempFile,Printers[I]);
close(TempFile);
end;

procedure GetPrinterCodes;
var I:           integer;
    Continue:    boolean;
begin
TempFileLine := DataDrive + 'printcod';
assign(IntFile,TempFileLine);
reset(IntFile);
I := 1;
Continue := true;
while (I <= MostPrinters) and Continue do
   begin
   {$I-}
   read(IntFile,Compress1[I]);
   read(IntFile,Compress2[I]);
   read(IntFile,DeCompress1[I]);
   read(IntFile,DeCompress2[I]);
   {$I+}
   if ioresult <> 0 then Continue := false;
   inc(I);
   end;
close(IntFile);
end;

procedure PutPrinterCodes;
var I:           integer;
begin
TempFileLine := DataDrive + 'printcod';
assign(IntFile,TempFileLine);
rewrite(IntFile);
for I := 1 to MostPrinters do
   begin
   write(IntFile,Compress1[I]);
   write(IntFile,Compress2[I]);
   write(IntFile,DeCompress1[I]);
   write(IntFile,DeCompress2[I]);
   end;
close(IntFile);
end;

end.
