unit PG;

interface
uses Crt,      Def,      ColorDef, FastWr,   GetForU,  StrnU, StriU,  RE,
     FixNamU,  LPaU,     StripOuU, SetBU,    DrawSqar, CPaU,  GetKeU, Str2InU,
     CursorOU;
procedure PrintDevice;
procedure CompressPrint;
procedure DeCompressPrint;
procedure PrintLabel( Top, RecordNum: integer);
procedure PrintRecord( Top, RecordNum: integer);
procedure MailMergeRecord(RecordNum: integer);
procedure PrintQuery;

implementation

procedure PrintDevice;
var Temp:              string;
    AllowInput:        boolean;
    AllowControl:      integer;
begin
CursorOn(False);
AllowControl := -1;
AllowInput := true;
Temp := '';
FastWrite( 'File name for print-out ? ([ENTER] defaults to the printer)',
          1, 1, Inputs.Attr);
Temp := Strip( GetForm( 1, 2, 78, Strng(78,' '), Temp, AllowControl,
                        AllowInput, Inputs.Attr, [#31..#126]));
Device := 'PRN';
if ord(Temp[0]) > 1 then Device := Temp;
FastWrite( Strng(80,#32), 1, 1, Displays.Attr);
FastWrite( Strng(80,#32), 2, 1, Displays.Attr);
end;

procedure CompressPrint;
begin
if ((Compress1[ActivePrinter] <> 0) or (Compress2[ActivePrinter] <> 0))
   and (Device='PRN') then
   begin
   if Compress1[ActivePrinter] <> 0 then
      write( OutPutDevice, chr(Compress1[ActivePrinter]));
   if Compress2[ActivePrinter] <> 0 then
      write( OutPutDevice, chr(Compress2[ActivePrinter]));
   end;
end;

procedure DeCompressPrint;
begin
if ((DeCompress1[ActivePrinter]<>0) or (DeCompress2[ActivePrinter]<>0))
   and (Device='PRN') then
   begin
   if DeCompress1[ActivePrinter] <> 0  then
      write(OutPutDevice,chr(DeCompress1[ActivePrinter]));
   if DeCompress2[ActivePrinter] <> 0  then
      write(OutPutDevice,chr(DeCompress2[ActivePrinter]));
   end;
end;

procedure PrintLabel;
var ReturnAddressName,
    Use,
    AddressName:                  s40;
    ExtraLines,
    Count,
    X1,
    X2,
    J,
    I:                     integer;

   procedure PrintActiveLabel( Entry: MainRecordType);
   var A:            array [1..MaxFormLength,1..MaxFormWidth] of char;
       J,
       I:            integer;

     procedure PlaceFileds(E: MainRecordType; X, Y: integer);
     var I,
         J,
         K,
         Row,
         Col:                                  integer;
         Temp:                                 S80;
         PrintSomething:                      boolean;
     begin
     Row := Y;
     I := 1;
     while (Form[ActiveForm].PlaceArray[I,1] <> 0) and (I < LastDescription) do
         begin
         Col := X;
         PrintSomething := false;
         J := 1;
         while (Form[ActiveForm].PlaceArray[I,J] <> 0)
         and   (J <= MaxFieldLine) do
             begin
             case Form[ActiveForm].PlaceArray[I,J] of
                1:  Temp := Use;
                2:  Temp := E.Title;
                3:  Temp := E.Company;
                4:  Temp := E.AuxAddress;
                5:  Temp := E.MailAddress;
                6:  if Komma then
                       Temp := Strip(E.City)+','
                      else
                       Temp := Strip(E.City);
                7:  if Komma then
                       Temp := E.State+'.'
                      else
                       Temp := E.State;
                8:  Temp := E.ZipCode;
                9:  Temp := E.Phone1;
                10: Temp := E.Phone2;
                11: Temp := E.Comments;
                end;
             if ord(Temp[0]) > 1 then
                while (ord(Temp[ord(Temp[0])]) < 33)
                and   (ord(Temp[0]) > 1) do
                    dec(Temp[0]);
             if length(Temp) > 1 then
                begin
                if Form[ActiveForm].PlaceArray[I,J] = 8 then
                   if length(Temp) = 6 then
                      delete(Temp,6,1);
                PrintSomething := true;
                for K := 1 to length(Temp) do
                    begin
                    A[Row,Col] := Temp[K];
                    inc(Col);
                    end;
                A[Row,Col] := ' ';
                inc(Col);
                end;
             inc(J);
             end;
         if PrintSomething then inc(Row);
         inc(I);
         end;
     end;

     function FindLastCol( Row: integer): integer;
     var Col:                             integer;
     begin
     Col := Form[ActiveForm].FormWidth;
     while (A[Row,Col] = ' ') and (Col > 1) do dec(Col);
     FindLastCol := Col;
     end;

   begin
   with Form[ActiveForm] do
      begin
      for I := 1 to FormLen do
          for J := 1 to FormWidth do A[I,J] := ' ';
      Use := ReturnAddressName;
      if (ReturnColOffset <> 0) and (ReturnRowOffset <> 0) then
         PlaceFileds( ReturnAddress, ReturnColOffset, ReturnRowOffset);
      Use := AddressName;
      if (ColOffset <> 0) and (RowOffset <> 0) then
         PlaceFileds( Entry, ColOffset, RowOffset);
      for I := 1 to FormLen do
          begin
          for J := 1 to FindLastCol(I) do write(OutPutDevice,A[I,J]);
          writeln(OutPutDevice,' ');
          end;
      end;   (* with *)
   end;

   procedure PrintDefaultLabel( Entry: MainRecordType);
   var I:    integer;
   begin
   ExtraLines := 3;
   if length(Strip(AddressName)) > 30 then CompressPrint;
   writeln(OutPutDevice,AddressName);
   if length(Strip(AddressName)) > 30 then DeCompressPrint;
   if (length(Strip(Entry.Title)) > 0)
   or (length(Strip(Entry.Company)) > 0) then
      begin
      CompressPrint;
      if (length(Strip(Entry.Title)) > 0) then
         write(OutPutDevice,Entry.Title,' ');
      if (length(Strip(Entry.Company)) > 0) then
         write(OutPutDevice,Entry.Company);
      writeln(OutPutDevice,'');
      dec(ExtraLines);
      DeCompressPrint;
      end;
   X1 := length(Strip(Entry.AuxAddress));
   if (X1 > 0) then
      begin
      if X1 > 30 then CompressPrint;
      writeln(OutPutDevice,Entry.AuxAddress);
      if X1 > 30 then DeCompressPrint;
      dec(ExtraLines);
      end;
   X1 := length(Entry.MailAddress);
   if X1 > 30 then CompressPrint;
   writeln(OutPutDevice,Entry.MailAddress);
   if X1 > 30 then DeCompressPrint;
   CompressPrint;
   if Komma then
      write(OutPutDevice,Strip(Entry.City),', ',Entry.State,'. ')
     else
      write(OutPutDevice,Strip(Entry.City),' ',Entry.State);
   if (ord(Entry.ZipCode[7]) < 48) or
      (ord(Entry.ZipCode[7]) > 57) then X1 := 5 else X1 := 10;
   writeln(OutPutDevice,copy(Entry.ZipCode,1,X1));
   DeCompressPrint;
   for I := 1 to ExtraLines do writeln(OutPutDevice,' ');
   end;

begin
GetRec(Entry,RecordNum);
AddressName := Entry.Addressee;
FixName(AddressName);
ReturnAddressName := ReturnAddress.Addressee;
FixName(ReturnAddressName);
for Count := 1 to Top do
    if ActiveForm = 0 then
       PrintDefaultLabel(Entry)
      else
       PrintActiveLabel(Entry);
end;

(* -------------------------------------------------------------------- *)

procedure PrintRecord;
var Temp1,
    Temp2,
    Temp:                               s40;
    Count,
    I:                                  integer;
    Compress_test:                      boolean;
begin
Compress_test := false;
GetRec(Entry,RecordNum);
Temp := Entry.Addressee;
FixName(Temp);
CompressPrint;
for Count := 1 to Top do
    begin
    write(OutPutDevice, LPad(Temp,25));
    if (PrinterMode=1) or (PrinterMode=3) then
       begin
       write(OutPutDevice,' ',Entry.MailAddress,' ',Entry.City,' ',Entry.State);
       write(OutPutDevice,' ',Entry.ZipCode);
       end;
    if (PrinterMode=2) or (PrinterMode=3) then
       begin
       write(OutPutDevice,' ',Entry.Phone1,' ',Entry.Phone2);
       if PrinterMode = 2 then
          write(OutPutDevice,' ',Entry.Title,' ',Entry.Company);
       end;
    if (PrinterMode=4) then
       begin
       writeln(OutPutDevice,#92,Entry.Title,#92,Entry.Company);
       write(OutPutDevice,'   ',Entry.AuxAddress,#92,Entry.MailAddress,#92);
       writeln(OutPutDevice,Entry.City,#92,Entry.State,#92,Entry.ZipCode);
       Ch := Entry.Division;        I := ord(Ch);
       Ch := Entry.SubDivision;     J := ord(Ch);
       if (I < 1) or (I > DivisionTop) then
          Temp1 := ' null AlphaCode'
         else
          Temp1 := AlphaCode[I,0];
       if (J < 1) or (J > SubDivisionTop) then
          Temp2 := ' null AlphaCode'
         else
          Temp2 := AlphaCode[I,J];
       Temp1 := LPad(Temp1,14);
       Temp2 := LPad(Temp2,14);
       write(OutPutDevice,'   ',Entry.Phone1,#92,Entry.Phone2,#92,Temp1:14);
       writeln(OutPutDevice,#92,Temp2:14,#92,Entry.Comments);
       end;
    if PrinterMode=4 then
       writeln(OutPutDevice,'--------')
      else
       writeln(OutPutDevice,'');
    end;
DeCompressPrint;
end;

(* -------------------------------------------------------------------- *)

procedure MailMergeRecord;
var Temp1,
    Temp2,
    FirstName,
    LastName:                                 s40;
    Lngth,
    X:                                  integer;
begin
GetRec(Entry,RecordNum);
FirstName := Strip(Entry.Addressee);
LastName := FirstName;
X := pos(';',FirstName);
if X = 0 then
   LastName := ''
  else
   begin
   LastName[0] := chr(pred(X));
   X := succ(X);
   Lngth := succ(ord(FirstName[0]) - X);
   move( FirstName[X], FirstName[1], Lngth);
   FirstName[0] := chr(Lngth);
   FirstName := Strip(FirstName);
   LastName := Strip(LastName);
   end;

Ch := Entry.Division;        I := ord(Ch);
Ch := Entry.SubDivision;     J := ord(Ch);
if (I < 1) or (I > DivisionTop) then
   Temp1 := ' null AlphaCode'
  else
   Temp1 := AlphaCode[I,0];
if (J < 1) or (J > SubDivisionTop) then
   Temp2 := ' null AlphaCode'
  else
   Temp2 := AlphaCode[I,J];
Temp1 := Strip(Temp1);
Temp2 := Strip(Temp2);
Entry.ZipCode := Strip(Entry.ZipCode);
Lngth := ord(Entry.ZipCode[0]);
if Entry.ZipCode[Lngth] = '-' then dec(Entry.ZipCode[0]);
(*  := chr(pred(Lngth));  *)

if StripOut(Entry.Phone1,'/- ') = '' then Entry.Phone1 := '';
if StripOut(Entry.Phone2,'/- ') = '' then Entry.Phone2 := '';

writeln( OutPutDevice,
         '"', FirstName, '","', LastName, '","',
         StripOut(Strip(Entry.Title),'"'), '","',
         StripOut(Strip(Entry.Company),'"'), '","',
         StripOut(Strip(Entry.AuxAddress),'"'), '","',
         StripOut(Strip(Entry.MailAddress),'"'), '","',
         StripOut(Strip(Entry.City),'"'), '","',
         StripOut(Strip(Entry.State),'"'), '","',
         StripOut(Strip(Entry.ZipCode),'"'), '","',
         StripOut(Strip(Entry.Phone1),'"'), '","',
         StripOut(Strip(Entry.Phone2),'"'), '","',
         StripOut(Strip(Entry.Comments),'"'), '","',
         chr(ord(Entry.Division)+64), '","', Temp1, '","',
         chr(ord(Entry.SubDivision)+64), '","', Temp2, '"' );
end;

(* -------------------------------------------------------------------- *)

procedure PrintQuery;
var Row,
    I,
    J,
    Err,
    AllowControl,
    Col:                   integer;
    AllowInput,
    FunctionKey:           boolean;
    Ch:                    char;
begin
SetBG;
clrscr;
Col := 30;  Row := 12;
DrawSquare( 1, 1, 80, 25, Menus.Attr, true);
FastWrite( CPad('1. Use current form method',20), Row+1, Col, Menus.Attr);
FastWrite( CPad('2. Use current line method',20), Row+2, Col, Menus.Attr);
GetKey(Ch,FunctionKey);
if (Ch = '1') or (Ch = '2') then
   begin
   AllowControl := -1;
   AllowInput := true;
   FastWrite( LPad('How many entries ?',40), 20, 5, Inputs.Attr);
   I := Str2Int( GetForm( 50, 20, 5, Strng(5,' '), '1', AllowControl,
                          AllowInput, (Inputs.Attr or $0008), ['0'..'9']),
                 Err);
   SetBG;
   if (I > 0) then
      begin
      assign(OutPutDevice,'PRN');
      rewrite(OutPutDevice);
      case Ch of
          '1': PrintLabel(I,RecordNum);
          '2': PrintRecord(I,RecordNum);
          end;
      close(OutPutDevice);
      end;
   end;
end;

end.

