unit NS;

interface
uses Crt,   GetForU, Def,    ColorDef, FindFile, LPaU, ShadoU, FastWr,
     SetBU, StriU,   StrnU,  UCasU;
procedure NameSearch;

implementation

procedure NameSearch;
var Continue:      boolean;
    I:             integer;
    DisplayLines:  array [1..11] of S80;
    AllowInput:    boolean;
    ValidChar:     SetType;
    AllowControl:  integer;

    procedure NameSearchHelp;
    var I,
        J:    integer;
    begin
    I := 0;
    inc(I);
    DisplayLines[I] := 'To start at the beginning of the list, simply strike [ENTER].';
    inc(I);
    DisplayLines[I] := ' ';
    inc(I);
    DisplayLines[I] := ' ';
    inc(I);
    DisplayLines[I] := 'If you type an entry here, the computer finds the first word that';
    inc(I);
    DisplayLines[I] := 'occurs which starts with the entered sequence of letters.';
    inc(I);
    DisplayLines[I] := 'For example, if you enter "C" the first name that starts with "C" is';
    inc(I);
    DisplayLines[I] := 'listed at the top of the screen.  If you enter "CAR" then the';
    inc(I);
    DisplayLines[I] := 'computer begins listing from the first name that begins with "CAR".';
    inc(I);
    DisplayLines[I] := 'In this way not only portions of names, but also entire names may be';
    inc(I);
    DisplayLines[I] := 'entered.';
    for J := 1 to I do DisplayLines[J] := LPad(DisplayLines[J],68);
    Shadow( 3, 6, 74, 19, Msgs.Attr, true);
    for J := 1 to I do FastWrite( DisplayLines[J], J+7, 5, Msgs.Attr);
    end;

begin
Continue := true;
SetBG;
clrscr;
while Continue do
   begin
   AllowInput := true;
   AllowControl := -1;      (* dis-allows control codes to be returned. *)
   FastWrite( 'Name ?   (or HELP)  ', 1, 1, Msgs.Attr);
   FindName := Strip( GetForm( 25, 1, 25, Strng(25,' '), '', AllowControl,
                               AllowInput, Inputs.Attr, [#32..#126]));
   SetBG;
   I := ord(FindName[0]);
   if (I > 0) and (I < FieldLen[1]) then
      begin
      FindName := UCase(FindName);
      if FindName = 'HELP' then
         NameSearchHelp
        else
         begin
         FirstDisplay := FindInFile(FindName);
         Continue := false;
         end;
      end
     else
      begin
      FirstDisplay := 1;
      Continue := false;
      end;
   end;
end;

end.
