{
The easiest method to compile this program,
is to place all source files in one hard  disk  subdirectory  and  compile
using Make - F9. This will compile all units first, then the main EXE file.

BE SURE to set Var-string checking to Relaxed in the Options/Compiler menu.

}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,65500,655360} {Turbo 3 default stack and heap}

program mailpro (input,output);

uses
BL,       CE,       CF,       Colors,   CO,       DEF,      DL,       DQ,
DR,       ED,       ER,       FD,       FF,       FR,       FT,       MF,
MO,       NS,       PG,       PR,       RE,       RET,      SM,       SO,
SS,       IT,
Crt,      ColorDef, DrawSqar, FastWr,   CPaU,     GetForU,  StrnU,    UCasU,
SetBU,    CursorOU, GetKeU,   SetAttU,  BeeU,     ShadoU,   ColorIU,  GenMenus,
TestFile;

(*
BldList,                 BL
CheckEnd,                CE
ClrForm,                 CF
Colors;                  CL
Codes,                   CO
CreditDisplay,           IT
MP1Def,                  DEF
DsplyLin,                DL
DelQuery,                DQ
Drive,                   DR
Editor,                  ED
EditRec,                 ER
FileDumU,                FD
FindFone,                FF
Forms,                   FR
FileTops,                FT
GetState,                GS
MP1Files,                MF
Modes,                   MO
NameSrch,                NS
Printing,                PG
Printers,                PR
Records,                 RE
Return,                  RET
SysMenu,                 SM
Sorts,                   SO
ScrnShow,                SS

*)

procedure ShiftUp;
var Place:         integer;
begin
gotoxy(1,1);                     delline;
gotoxy(1,succ(DisplayLines));    insline;
inc(FirstDisplay);
CheckEnds(FirstDisplay,LastDisplay);
Place := LastDisplay - FirstDisplay + 1;
gotoxy(1,Place);
GetRec(Entry,LastDisplay);
DisplayLine(Entry,Place, Displays.Attr);
end;

procedure ShiftDown;
var Place:          integer;
begin
if FirstDisplay <> 1 then
   begin
   gotoxy(1,succ(DisplayLines));     delline;
   gotoxy(1,1);                      insline;
   dec(FirstDisplay);
   CheckEnds(FirstDisplay,LastDisplay);
   gotoxy(1,1);
   GetRec(Entry,FirstDisplay);
   DisplayLine(Entry, 1, Displays.Attr);
   end;
end;

(* this procedure initializes the data disk !!! *)
procedure MailStart;
var Answer:     line;
    RecordNum,
    AllowControl,
    I,
    J:          integer;
    AllowInput: boolean;
begin
AllowControl := -1;
AllowInput := true;
DriveSet;
SetBG;
clrscr;
DrawSquare( 1, 1, 80, 5, Msgs.Attr, true);
FastWrite( CPad('You are about to erase any data on drive '+ DataDrive+'.  If that is your',78), 2, 2, Msgs.Attr);
FastWrite( CPad('intent then type "START" and hit [ENTER].',78), 3, 2, Msgs.Attr);
FastWrite( CPad('To exit, strike [ENTER].',78), 4, 2, Msgs.Attr);
Answer := GetForm( 37, 7, 10, Strng(10,#32), 'ABORT', AllowControl, AllowInput,
                   (Inputs.Attr or $0008), [#31..#126]);
clrscr;
if UCase(Answer) = 'START' then
   begin
   Blank := ' ';
   SortTop := 0;        FileTop := 0;
   PutFileTop;
   for I := 1 to MostPrinters do
       begin
       Compress1[I] := 0;      Compress2[I] := 0;
       DeCompress1[I] := 0;    DeCompress2[I] := 0;
       Printers[I] := ' ';
       end;
   PutPrinterCodes;
   PutPrinters;
   for RecordNum := 0 to DivisionTop do
       for J := 0 to SubDivisionTop do
           AlphaCode[RecordNum,J] := Blank;
   PutAlphaCodes;
   ShowMode := 1;          PrinterMode := 1;
   ActivePrinter := 1;       ProgramUse := 1;     ActiveForm := 0;
   PutMode(ShowMode,PrinterMode);
   if not TestFileExist('forms') then
     begin
     for I := 1 to MaxForms do ClearForm(Form[I]);
     WriteForms;
     end;
   MainFileStart;                         (* found at beginning of program *)
   end;                                   (* if..then *)
end;


(* -------------------------------------------------------------------- *)

procedure EditData;
var Temp,
    Continue:       boolean;
    Row:            integer;
    TempEntry:     MainRecordType;
    AltAttr:            byte;

  procedure CentralControl(var Continue: boolean);
  var ActionTaken,
      SortContinue,
      FunctionKey:        boolean;
      SortDifference,
      I:              integer;
      X:              string;
  begin
  RecordNum := ( pred(FirstDisplay) + Row );
  FastWrite('Entry    ', 25, 21, Msgs.Attr);
  str(RecordNum,X);  X := X + ' ';
  FastWrite( X, 25, 30, (Msgs.Attr xor $0008));
  CursorOn(false);
  GetKey(Ch,FunctionKey);
  I := ord(Ch);
  DisplayLine( TempEntry, Row, Displays.Attr);
  if FunctionKey then
     begin
     if I=72 then dec(Row);                                 (* uparr *)
     if I=80 then inc(Row);                                 (* dnarr *)
     if I=73 then                                                 (* pg up *)
        begin
        FirstDisplay := FirstDisplay + succ(DisplayLines);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=81 then                                                 (* pg dn *)
        begin
        FirstDisplay := FirstDisplay - succ(DisplayLines);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=71 then Row := 1;                                       (* home *)
     if I=79 then Row := succ(DisplayLines);                      (* end *)
     if Row > succ(DisplayLines) then Row := succ(DisplayLines);
     if Row < 1 then Row := 1;
     if I=59 then ShiftUp;                                         (* f1 *)
     if I=60 then ShiftDown;                                       (* f2 *)
     if Row > (LastDisplay-FirstDisplay+1) then
        Row := LastDisplay - FirstDisplay + 1;
     if I=61 then                                                 (* f3 *)
        begin
        FileDump;
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=62 then                                                 (* f4=edit *)
        begin
        EditRecord(RecordNum);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=63 then                                                 (* f5=mode *)
        begin
        ModeMenu;
        TextAttr := Displays.Attr;
        clrscr;
        PutMode(ShowMode,PrinterMode);
        AltAttr := SetAttr( Displays.Blink, false, Displays.BG, Displays.FG);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=64 then                                                 (* f6=Phone *)
        begin
        FindPhone;
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=65 then                                                 (* f7=record *)
        begin
        assign(OutPutDevice,'PRN');
        rewrite(OutPutDevice);
        PrintRecord(1,RecordNum);
        close(OutPutDevice);
        end;
     if I=66 then                                                 (* f8=label *)
        begin
        assign(OutPutDevice,'PRN');
        rewrite(OutPutDevice);
        PrintLabel(1,RecordNum);
        close(OutPutDevice);
        end;
     if I=67 then                                                 (* f9=list *)
        begin
        BuildList;
        AltAttr := SetAttr(Displays.Blink,false,Displays.BG,Displays.FG);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=68 then                                                 (* f10=name *)
        begin
        NameSearch;
        Row:=1; LastDisplay := FirstDisplay+DisplayLines; Continue := true;
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=82 then
        begin
        NewDataInput;                                           (* insert *)
        SortQuery(SortContinue);
        if SortContinue then
           begin
           SortDifference := FileTop - SortTop;
           if SortDifference > 0 then
              if SortDifference > MaxSortDiff then
                 MergeSort
                else
                 InsertSort;
           end;
        Continue := true;
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=83 then                                                 (* delete *)
        begin
        DeleteQuery(ActionTaken,RecordNum);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=32 then                                                 (* delete *)
        begin
        DeleteQuery(ActionTaken,RecordNum);
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     Continue := true;
     end
  else
     begin
     if I=16 then
        begin
        PrintQuery;
        ScreenDisplay(FirstDisplay,LastDisplay);
        end;
     if I=18 then
        begin
        GetRec(ReturnAddress,RecordNum);
        WriteReturn;
        Beep(2);
        end;
     if I = 27 then Continue := false else Continue := true;
     end;
  RecordNum := ( pred(FirstDisplay) + Row );
  GetRec(TempEntry,RecordNum);
  DisplayLine( TempEntry, Row, AltAttr);
  end;

  (* -------------------------------------------------------------------- *)

begin
NameSearch;
Row:=1;
LastDisplay := FirstDisplay + DisplayLines;
Continue := true;
AltAttr := SetAttr( Displays.Blink, false, Displays.BG, Displays.FG);
RecordNum := ( pred(FirstDisplay) + Row );
GetRec(TempEntry,RecordNum);
DisplayLine( TempEntry, Row, AltAttr);
ScreenDisplay(FirstDisplay,LastDisplay);
while Continue do begin
   if SortTop < 1 then Continue := false;
   if Continue then
      begin
      RecordNum := ( pred(FirstDisplay) + Row );
      GetRec(TempEntry,RecordNum);
      DisplayLine( TempEntry, Row, AltAttr);
      CentralControl(Continue);
      end;  (* if..then *)
   end;     (* while *)
end;

(* -------------------------------------------------------------------- *)

procedure SetUp;
var Continue,
    SortContinue:       boolean;
    SortDifference:           integer;
begin
GetDrive;
GetMode;
SetFieldLen;
GetAlphaCodes;
GetFileTop;
GetPrinterCodes;
OpenMainFile;
GetPrinters;
ReadForms;
WriteState := false;   (* only used if windows are used *)
ReadReturn;
end;

(* -------------------------------------------------------------------- *)

procedure Main;
var SortContinue:       boolean;
    SortDifference:     integer;
begin
clrscr;
(* DrawSquare( 1, 1, 80, 25, Displays.Attr, true); *)
Shadow( 25, 10, 55, 15, Msgs.Attr, true);
FastWrite( CPad('Standby !',20), 12, 30, Msgs.Attr);
FastWrite( CPad('Loading files ...',20), 13, 30, (Msgs.Attr or $0080) );
(* loading *)
SetUp;
AlphaCode[0,0] := 'Main Division Menu';
if SortTop < 2 then
   begin
   NewDataInput;
   SortQuery(SortContinue);
   if SortContinue then
      begin
      SortDifference := FileTop - SortTop;
      if SortDifference > 0 then
         if SortDifference > MaxSortDiff then
            MergeSort
           else
            InsertSort;
      end;
   EditData;
   end
else
   EditData;
CloseMainFile;
end;

(* -------------------------------------------------------------------- *)

procedure MainMenu;
var FunctionKey:       boolean;
    Ch:                char;
    Temp:              LineArray;
begin
Temp[0] := 'Main Menu';
Temp[1] := '1. Run main program';
Temp[2] := '2. Set program colors';
Temp[3] := '3. Set drive designation';
Temp[4] := '4. Initialize data disk';
Temp[5] := '5. Set top of file';
Temp[6] := '9. EXIT program';
while Ch <> #27 do
  begin
  Ch := RetMenu( Temp, 6, FunctionKey);
  case Ch of
     '1':   Main;
     '2':   ColorSet;
     '3':   DriveSet;
     '4':   MailStart;
     '5':   SetTopOfFile;
     '9':   Ch := #27;
     end;   (* case *)
  end;        (* while *)
end;

(* -------------------------------------------------------------------- *)

(*                            *** Main program ****
*)
begin
clrscr;
Menus.FG := 0;
Menus.BG := 0;
CursorOn(false);
DataDrive := DriveDefault;
Device := 'PRN';
BlankLine := Strng(80, ' ');

CreditDisplay;
Delay(5000);

GetColors;
TextAttr := Displays.Attr;

MainMenu;
CursorOn(true);
clrscr;
end.

