unit ED;

interface
uses Crt,      Def,    ColorDef, FastWr, DrawSqar, SubEdit,  DivEdit,
     CursorOU, State,  BeeU,     GetKeU, RE,       FT,       CPaU;
procedure SetConstants;
procedure EmptyFrame;
procedure PrintFrame;
procedure PageHeadingDisplay;
procedure EmptyPageDisplay;
procedure FullPageDisplay;
procedure CheckCursor(var Row, Col: integer; I: integer);
procedure PageEditor;
procedure FieldSet(var X:s40;Row:integer);
procedure RecordSet;
procedure Query(var X:boolean);
procedure NewDataInput;

implementation

procedure SetConstants;
begin
Frame[6,ZipLine] := '-';
Frame[4,Phone1Line] := '/';
Frame[8,Phone1Line] := '-';
Frame[4,Phone2Line] := '/';
Frame[8,Phone2Line] := '-';
end;

(* -------------------------------------------------------------------- *)

procedure EmptyFrame;
var I,
    J:    integer;
begin
for I := 1 to LastDescription do
    for J := 1 to FieldLen[I] do
        Frame[J,I] := chr(PrintBlock);
SetConstants;
end;

(* -------------------------------------------------------------------- *)

procedure PrintFrame;
var I,
    J:                  integer;
begin
for I := 1 to LastDescription do
    for J := 1 to FieldLen[I] do
        FastWrite( Frame[J,I], I, BeginBlock+J-1, Inputs.Attr);
FastWrite( chr(PrintBlock), FinalLine, BeginBlock, Inputs.Attr);
for I := 22 to 24 do FastWrite( BlankLine, I, 1, Displays.Attr);
DrawSquare( 1, 23, 80, 25, Menus.Attr, true);
FastWrite( 'F1', 24, 6, (Menus.Attr or $0008));
FastWrite( 'F2', 24, 27, (Menus.Attr or $0008));
FastWrite( 'F3', 24, 53, (Menus.Attr or $0008));
FastWrite( '= Enter codes !', 24, 9, (Menus.Attr or $0008));
FastWrite( '= Go to mail address', 24, 30, (Menus.Attr or $0008));
FastWrite( '= Display states', 24, 56, (Menus.Attr or $0008));
end;

(* -------------------------------------------------------------------- *)

procedure PageHeadingDisplay;
var I,
    J,
    Col,
    X:           integer;
    Temp1,
    Temp2:       s30;
    Ch:          char;
begin
Col := 43;
for I := 1 to 11 do
    FastWrite( Description[I], I, Col, Headings.Attr);
FastWrite( 'Hit  [ESC]', 12, Col, Headings.Attr);
FastWrite( 'division', 14, Col, Headings.Attr);
FastWrite( 'sub-division', 15, Col, Headings.Attr);
Ch := Entry.Division;          I := ord(Ch);
Ch := Entry.SubDivision;       J := ord(Ch);
if (I < 1) or (I > DivisionTop) then
   begin
   Temp1 := 'NULL CODE';
   I := -16;
   end
  else
   Temp1 := AlphaCode[I,0];
if (J < 1) or (J > SubDivisionTop) then
   begin
   Temp2 := 'NULL CODE';
   J := -16;
   end
  else
   Temp2 := AlphaCode[I,J];

FastWrite( chr(I+64)+' '+Temp1, 14, BeginBlock, Inputs.Attr);
FastWrite( chr(J+64)+' '+Temp2, 15, BeginBlock, Inputs.Attr);
end;

(* -------------------------------------------------------------------- *)

procedure EmptyPageDisplay;
begin
TextAttr := Displays.Attr;
clrscr;
PageHeadingDisplay;
EmptyFrame;
PrintFrame;
end;

(* -------------------------------------------------------------------- *)

procedure FullPageDisplay;
var I,J,X:integer;
    Temp1,Temp2:s30;
begin
clrscr;
PageHeadingDisplay;
PrintFrame;
end;

(* -------------------------------------------------------------------- *)

procedure CheckCursor;
begin
if Row < 1 then
   begin
   Row := 1;
   Col := BeginBlock;
   end;
if Row > FinalLine then
   begin
   Row := FinalLine;
   Col := BeginBlock;
   end;
if Col < BeginBlock then
   begin
   dec(Row);
   Col := BeginBlock + pred(FieldLen[Row]);
   if Row < 1 then Row := 1;
   end;
if Col > (BeginBlock + pred(FieldLen[Row])) then
   begin
   if (I <> 72) and (I <> 80) then
      begin
      inc(Row);
      Col := BeginBlock;
      if Row > FinalLine then Row := FinalLine;
      end
   else
      Col := BeginBlock + pred(FieldLen[Row]);
   end;
end;

(* -------------------------------------------------------------------- *)

procedure PageEditor;
var I,
    Row,
    Col:                      integer;
    check_space:              boolean;
    Ch,
    Ch2,
    Ch3:                      char;

    procedure SwapC(I: integer);
    var Temp: char;
    begin
    Temp := Frame[I,Row];
    Frame[I,Row] := Frame[succ(I),Row];
    Frame[succ(I),Row] := Temp;
    end;

(* these next two procedures keep the format for Zip AlphaCode and phone number
   correctly established *)

    procedure fix_constants_1;
    var I:integer;
    begin
    for I:=FieldLen[Row] downto (Col-BeginBlock+2) do
        if (Frame[I,Row]='/') or (Frame[I,Row]='-') then SwapC(I);
    end;

    procedure fix_constants_2;
    var I:integer;
    begin
    for I:= (Col-BeginBlock+2) to FieldLen[Row] do
        if (Frame[I,Row]='/') or (Frame[I,Row]='-') then SwapC(I-1);
    end;

    procedure enter_control(Ch:char);
    var TempDiv,
        TempSub,
        OCh:                         integer;
        Str:                          s2;
    begin
    I := ord(Ch);
    if (I=27) then                                    (* esc *)
       begin
       if (Row=FinalLine) then
          Continue := false
         else
          begin
          Row := FinalLine;
          Col := 1;
          end;
       end;
    if I=59 then                                      (* f1 = enter AlphaCode *)
       begin
       CursorOn(false);
       DivisionEdit(TempDiv, TempSub);
       CursorOn(true);
       FullPageDisplay;
       end;
    if I=60 then                                      (* f2 = jump *)
       begin
       Row := MailLine;
       Col := 1;
       end;
    if I = 61 then                                    (* f3 = states *)
       begin
       CursorOn(false);
       Str := DisplayStates;
       if Str <> '  ' then
          begin
          Frame[1,7] := Str[1];
          Frame[2,7] := Str[2];
          FastWrite( Frame[1,7], 7, BeginBlock+(1)-1, Inputs.Attr);
          FastWrite( Frame[2,7], 7, BeginBlock+(2)-1, Inputs.Attr);
          end;
       CursorOn(true);
       end;
    if (I=8) and (Col > BeginBlock) then             (* back space key *)
       begin
       dec(Col);
       if (row >= ZipLine) and (row <= Phone2Line) then
          begin
          Ch2 := Frame[Col-BeginBlock+1,Row];
          if (Ch2='/') or (Ch2='-') then
             begin
             for J := Col-BeginBlock+2 to FieldLen[Row] do
                 Frame[J,Row] := Frame[J+1,Row];
             Frame[FieldLen[Row],Row] := chr(PrintBlock);
             Frame[(Col-BeginBlock+1),Row] := Ch2;
             fix_constants_1;
             dec(Col);
             Frame[Col-BeginBlock+1,Row] := chr(PrintBlock);
             end
          else
             begin
             for J := Col-BeginBlock+1 to FieldLen[Row] do
                 Frame[J,Row] := Frame[J+1,Row];
             Frame[FieldLen[Row],Row] := chr(PrintBlock);
             fix_constants_1;
             end;
          end
       else
          begin
          for J := Col-BeginBlock+1 to pred(FieldLen[Row]) do
              Frame[J,Row] := Frame[J+1,Row];
          Frame[FieldLen[Row],Row] := chr(PrintBlock);
          end;
       for J := 1 to FieldLen[Row] do
           FastWrite( Frame[J,Row], Row, BeginBlock+J-1, Inputs.Attr);
       end;
    if I=83 then                                        (* del key *)
       begin
       for J := Col-BeginBlock+1 to FieldLen[Row] do
           Frame[J,Row] := Frame[J+1,Row];
       Frame[FieldLen[Row],Row] := chr(PrintBlock);
       if (row>=ZipLine) and (row<=Phone2Line) then fix_constants_1;
       for J := 1 to FieldLen[Row] do
           FastWrite( Frame[J,Row], Row, BeginBlock+J-1, Inputs.Attr);
       end;
    if I=82 then                                        (* insert key *)
       begin
       for J := FieldLen[Row] downto Col-BeginBlock+2 do
           Frame[J,Row] := Frame[J-1,Row];
       Frame[(Col-BeginBlock+1),Row] := chr(PrintBlock);
       if (row>=ZipLine) and (row<=Phone2Line) then fix_constants_2;
       for J := 1 to FieldLen[Row] do
           FastWrite( Frame[J,Row], Row, BeginBlock+J-1, Inputs.Attr);
       end;
    if I=72 then dec(row);             (* up arrow *)
    if I=80 then inc(Row);             (* down arrow *)
    if I=75 then dec(Col);             (* left arrow *)
    if I=77 then inc(Col);             (* right arrow *)
    if I=71 then                       (* home *)
       begin
       Col := 1;
       Row := 1;
       end;
    if I=13 then                       (* [enter] *)
       begin
       inc(Row);
       Col := BeginBlock;
       end;
    CheckCursor(Row,Col,I);
    end;

    procedure enter_other(Ch:char);
    var OCh:                       integer;
    begin
    OCh := ord(Ch);
    if (OCh > 31) and (OCh < 126) then
       begin
       if Col < BeginBlock+FieldLen[Row] then
          begin
          Frame[Col-BeginBlock+1,Row] := Ch;
          gotoxy(Col,Row);
          FastWrite( Frame[Col-BeginBlock+1,Row], Row, Col, Inputs.Attr);
          inc(Col);
          if Col > FieldLen[Row]+BeginBlock-1 then
             Beep(1)
            else
             begin
             Ch2 := Frame[Col-BeginBlock+1,Row];
             Ch3 := Frame[Col-BeginBlock+2,Row];
             if (Ch2='/') or (Ch2='-') then
                inc(Col);
             end;
          end
         else
          begin
          Beep(1);
          end;      (* if..then..else *)
       end;
    end;

begin
Row :=1; Col := BeginBlock; Continue := true;
CursorOn(true);
while Continue do begin
   gotoxy(Col,Row);
   GetKey(Ch,FunctionKey);
   if (Ch = #13) then FunctionKey := true;
   if (Ch = #27) then FunctionKey := true;
   if (Ch = #8) then FunctionKey := true;
   if FunctionKey then
      enter_control(Ch)
   else
      enter_other(Ch);
   end;  (* while *)
CursorOn(false);
end;

procedure FieldSet;
var I:integer;
begin
X := '';
for I := 1 to FieldLen[Row] do
    begin
    if Frame[I,Row]=chr(PrintBlock) then Frame[I,Row] := ' ';
    X := concat(X,Frame[I,Row]);
    end;
if X[ord(X[0])] = '-' then dec(X[0]);
end;

procedure RecordSet;
var X:          s40;
    I:          integer;
begin
FieldSet(X,1);     Entry.Addressee := X;
FieldSet(X,2);     Entry.Title := X;
FieldSet(X,3);     Entry.Company := X;
FieldSet(X,4);     Entry.AuxAddress := X;
FieldSet(X,5);     Entry.MailAddress := X;
FieldSet(X,6);     Entry.City := X;
FieldSet(X,7);     Entry.State := X;
FieldSet(X,8);     Entry.ZipCode := X;
FieldSet(X,9);     Entry.Phone1 := X;
FieldSet(X,10);    Entry.Phone2 := X;
FieldSet(X,11);    Entry.Comments := X;
end;

procedure Query;
var garbage:boolean;
    Ch:char;
begin
gotoxy(55,25);
FastWrite( 'Another Entry ? (Y/N)', 21, 5, Inputs.Attr);
GetKey(Ch,garbage);
Ch := upcase(Ch);
if Ch='Y' then X := true else X := false;
end;

procedure NewDataInput;
var Continue:            boolean;
    test:                s30;
    Temp2:                 integer;
begin
Continue := true;
if FileTop <= high_record then
   begin
   while Continue do
      begin
      Entry.Division := #0;
      Entry.SubDivision := #0;
      EmptyPageDisplay;
      PageEditor;
      FastWrite( ' Saving record ! ', 20, 5, (Msgs.Attr or $0008));
      RecordSet;
      test := copy(Entry.Addressee,1,3);
      if test <> '   ' then
         begin
         FileTop := FileTop + 1;
         PutRec(Entry,FileTop);
         PutFileTop;
         FastWrite( ' Record saved !   ', 20, 5, (Msgs.Attr or $0008));
         Query(Continue);
         end
      else
         Continue := false;
      if (FileTop - SortTop) > 97 then Continue := false;
{$ifdef DemoOnly}
         I := Restriction1;
         I := I div Restriction2;
         if FileTop >= I then
            begin
            FileTop := I;
            FastWrite( CPad('Only 35 Addresses allowed in demo !',78),
                      21, 2, Msgs.Attr);
            Beep(3);
            Continue := false;
            end;
         if SortTop >= I then SortTop := I;
{$endif}
      end;            (* while *)
   end;               (* if..then *)
end;


end.

